/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class BufferOutputStream
extends OutputStream {
    private static final int CHUNK_SIZE = 8192;
    public byte[] buf = new byte[8192];
    public int len = 0;

    public void reset() {
        this.len = 0;
    }

    @Override
    public final void write(int v) throws IOException {
        if (this.len >= this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length + 8192);
        }
        this.buf[this.len++] = (byte)v;
    }

    @Override
    public final void write(byte[] b, int off, int wlen) {
        if (wlen > 0) {
            if (this.len + wlen - 1 >= this.buf.length) {
                int nlen = this.len + wlen + 8192 - 1;
                this.buf = Arrays.copyOf(this.buf, nlen - nlen % 8192);
            }
            for (int i = 0; i < wlen; ++i) {
                this.buf[this.len++] = b[off++];
            }
        }
    }

    @Override
    public final void write(byte[] b) {
        this.write(b, 0, b.length);
    }
}

