/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.IOException;
import java.util.ArrayList;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.exporter.OBJExport;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class ChunkVersionHDShader
implements HDShader {
    private final String name;
    static final DataVersionMap[] versionmap = new DataVersionMap[]{new DataVersionMap(0, "unknown", 0x202020), new DataVersionMap(1519, "1.13.0", 16377759), new DataVersionMap(1628, "1.13.1", 16044095), new DataVersionMap(1631, "1.13.2", 13937677), new DataVersionMap(1952, "1.14.0", 11267014), new DataVersionMap(1957, "1.14.1", 5822093), new DataVersionMap(1963, "1.14.2", 2667619), new DataVersionMap(1968, "1.14.3", 2333526), new DataVersionMap(1976, "1.14.4", 1934152), new DataVersionMap(2225, "1.15.0", 11458289), new DataVersionMap(2227, "1.15.1", 6139362), new DataVersionMap(2230, "1.15.2", 3049153), new DataVersionMap(2566, "1.16.0", 14138850), new DataVersionMap(2567, "1.16.1", 12819411), new DataVersionMap(2578, "1.16.2", 11500229), new DataVersionMap(2580, "1.16.3", 10181046), new DataVersionMap(2584, "1.16.4", 8933024), new DataVersionMap(2586, "1.16.5", 7750794), new DataVersionMap(2724, "1.17.0", 16108455), new DataVersionMap(2730, "1.17.1", 15439950), new DataVersionMap(2860, "1.18.0", 10740951), new DataVersionMap(2865, "1.18.1", 4770224)};
    static final Color unknown_color = new Color(255, 255, 255);
    private ArrayList<Integer> unknown_vers = new ArrayList();
    private static final String[] nulllist = new String[0];

    public ChunkVersionHDShader(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get("name");
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return false;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        return new OurShaderState(mapiter, map, cache, scale);
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "shader", this.name);
    }

    @Override
    public void exportAsMaterialLibrary(DynmapCommandSender sender, OBJExport out) throws IOException {
        throw new IOException("Export unsupported");
    }

    @Override
    public String[] getCurrentBlockMaterials(DynmapBlockState blk, MapIterator mapiter, int[] txtidx, BlockStep[] steps) {
        return nulllist;
    }

    private class OurShaderState
    implements HDShaderState {
        private Color[] color;
        private Color c;
        protected HDMap map;
        private HDLighting lighting;
        final int[] lightingTable;

        private OurShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache, int scale) {
            this.map = map;
            this.lighting = map.getLighting();
            this.color = this.lighting.isNightAndDayEnabled() ? new Color[]{new Color(), new Color()} : new Color[]{new Color()};
            this.c = new Color();
            this.lightingTable = (int[])(MapManager.mapman.useBrightnessTable() ? cache.getWorld().getBrightnessTable() : null);
        }

        @Override
        public HDShader getShader() {
            return ChunkVersionHDShader.this;
        }

        @Override
        public HDMap getMap() {
            return this.map;
        }

        @Override
        public HDLighting getLighting() {
            return this.lighting;
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            for (int i = 0; i < this.color.length; ++i) {
                this.color[i].setTransparent();
            }
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            if (ps.getBlockState().isAir()) {
                return false;
            }
            int ver = ps.getMapIterator().getDataVersion();
            boolean match = false;
            for (int i = 0; i < versionmap.length; ++i) {
                if (ver > ChunkVersionHDShader.versionmap[i].dataVersion) continue;
                this.c.setColor(ChunkVersionHDShader.versionmap[i].defcolor);
                match = true;
                break;
            }
            if (!match) {
                this.c.setColor(unknown_color);
                if (!ChunkVersionHDShader.this.unknown_vers.contains(ver)) {
                    Log.warning("Unknown chunk dataVersion: " + ver);
                    ChunkVersionHDShader.this.unknown_vers.add(ver);
                }
            }
            this.lighting.applyLighting(ps, this, this.c, this.color);
            return true;
        }

        @Override
        public void rayFinished(HDPerspectiveState ps) {
        }

        @Override
        public void getRayColor(Color c, int index) {
            c.setColor(this.color[index]);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public DynLongHashMap getCTMTextureCache() {
            return null;
        }

        @Override
        public int[] getLightingTable() {
            return this.lightingTable;
        }

        @Override
        public void setLastBlockState(DynmapBlockState new_lastbs) {
        }
    }

    private static class DataVersionMap {
        int dataVersion;
        String version;
        Color defcolor;

        DataVersionMap(int dv, String v, int c) {
            this.dataVersion = dv;
            this.version = v;
            this.defcolor = new Color(c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF);
        }
    }
}

