/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_18;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.dynmap.DynmapChunk;
import org.dynmap.Log;
import org.dynmap.common.chunk.GenericChunk;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.common.chunk.GenericMapChunkCache;
import org.dynmap.forge_1_18.ForgeWorld;
import org.dynmap.forge_1_18.NBT;

public class ForgeMapChunkCache
extends GenericMapChunkCache {
    private ServerLevel w;
    private ServerChunkCache cps;

    public ForgeMapChunkCache(GenericChunkCache cc) {
        super(cc);
    }

    @Override
    protected GenericChunk getLoadedChunk(DynmapChunk chunk) {
        CompoundTag nbt;
        GenericChunk gc = null;
        ChunkAccess ch = this.cps.m_7587_(chunk.x, chunk.z, ChunkStatus.f_62326_, false);
        if (ch != null && (nbt = ChunkSerializer.m_63454_((ServerLevel)this.w, (ChunkAccess)ch)) != null) {
            gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        }
        return gc;
    }

    @Override
    protected GenericChunk loadChunk(DynmapChunk chunk) {
        GenericChunk gc = null;
        CompoundTag nbt = this.readChunk(chunk.x, chunk.z);
        if (nbt != null) {
            gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        }
        return gc;
    }

    public void setChunks(ForgeWorld dw, List<DynmapChunk> chunks) {
        this.w = dw.getWorld();
        if (dw.isLoaded()) {
            this.cps = this.w.m_7726_();
        }
        super.setChunks(dw, chunks);
    }

    private CompoundTag readChunk(int x, int z) {
        try {
            CompoundTag rslt = this.cps.f_8325_.m_140427_(new ChunkPos(x, z));
            if (rslt != null) {
                if (rslt.m_128441_("Level")) {
                    rslt = rslt.m_128469_("Level");
                }
                String stat = rslt.m_128461_("Status");
                ChunkStatus cs = ChunkStatus.m_62397_((String)stat);
                if (stat == null || !cs.m_62427_(ChunkStatus.f_62323_)) {
                    rslt = null;
                }
            }
            return rslt;
        }
        catch (Exception exc) {
            Log.severe(String.format("Error reading chunk: %s,%d,%d", this.dw.getName(), x, z), exc);
            return null;
        }
    }
}

