/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_18;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Registry;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.UserBanList;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.PlayerList;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.common.DynmapServerInterface;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.forge_1_18.DmapCommand;
import org.dynmap.forge_1_18.DmarkerCommand;
import org.dynmap.forge_1_18.DynmapCommand;
import org.dynmap.forge_1_18.DynmapExpCommand;
import org.dynmap.forge_1_18.DynmapMod;
import org.dynmap.forge_1_18.ForgeMapChunkCache;
import org.dynmap.forge_1_18.ForgeWorld;
import org.dynmap.forge_1_18.VersionCheck;
import org.dynmap.forge_1_18.permissions.FilePermissions;
import org.dynmap.forge_1_18.permissions.OpPermissions;
import org.dynmap.forge_1_18.permissions.PermissionProvider;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.permissions.PermissionsHandler;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.DynmapLogger;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.VisibilityLimit;

public class DynmapPlugin {
    private DynmapCore core;
    private PermissionProvider permissions;
    private boolean core_enabled;
    public GenericChunkCache sscache;
    public PlayerList playerList;
    private MapManager mapManager;
    private static MinecraftServer server;
    public static DynmapPlugin plugin;
    private ChatHandler chathandler;
    private HashMap<String, Integer> sortWeights = new HashMap();
    private long worldIdleTimeoutNS = 30000000000L;
    private HashMap<String, ForgeWorld> worlds = new HashMap();
    private LevelAccessor last_world;
    private ForgeWorld last_fworld;
    private Map<String, ForgePlayer> players = new HashMap<String, ForgePlayer>();
    private HashSet<String> modsused = new HashSet();
    private ForgeServer fserver = new ForgeServer();
    private boolean tickregistered = false;
    private double tps;
    private long lasttick;
    private long avgticklen;
    private long perTickLimit = 50000000L;
    private boolean useSaveFolder = true;
    private static final String[] TRIGGER_DEFAULTS;
    private static final Pattern patternControlCode;
    ConcurrentLinkedQueue<BlockUpdateRec> blockupdatequeue = new ConcurrentLinkedQueue();
    public static DynmapBlockState[] stateByID;
    private Map<String, LongOpenHashSet> knownloadedchunks = new HashMap<String, LongOpenHashSet>();
    private boolean didInitialKnownChunks = false;
    private static Registry<Biome> reg;
    private static Biome[] biomelist;
    private ConcurrentLinkedQueue<ChatMessage> msgqueue = new ConcurrentLinkedQueue();
    private static final Gson gson;
    private DynmapCommand dynmapCmd;
    private DmapCommand dmapCmd;
    private DmarkerCommand dmarkerCmd;
    private DynmapExpCommand dynmapexpCmd;
    private PlayerTracker playerTracker = null;
    private WorldTracker worldTracker = null;
    private boolean onblockchange = false;
    private boolean onchunkpopulate = false;
    private boolean onchunkgenerate = false;
    private boolean onblockchange_with_id = false;

    private void addKnownChunk(ForgeWorld fw, ChunkPos pos) {
        LongOpenHashSet cset = this.knownloadedchunks.get(fw.getName());
        if (cset == null) {
            cset = new LongOpenHashSet();
            this.knownloadedchunks.put(fw.getName(), cset);
        }
        cset.add(pos.m_45588_());
    }

    private void removeKnownChunk(ForgeWorld fw, ChunkPos pos) {
        LongOpenHashSet cset = this.knownloadedchunks.get(fw.getName());
        if (cset != null) {
            cset.remove(pos.m_45588_());
        }
    }

    private boolean checkIfKnownChunk(ForgeWorld fw, ChunkPos pos) {
        LongOpenHashSet cset = this.knownloadedchunks.get(fw.getName());
        if (cset != null) {
            return cset.contains(pos.m_45588_());
        }
        return false;
    }

    private static Registry<Biome> getBiomeReg() {
        if (reg == null) {
            reg = server.m_129911_().m_175512_(Registry.f_122885_);
        }
        return reg;
    }

    public void initializeBlockStates() {
        stateByID = new DynmapBlockState[16384];
        Arrays.fill(stateByID, DynmapBlockState.AIR);
        IdMapper bsids = Block.f_49791_;
        DynmapBlockState basebs = null;
        Block baseb = null;
        int baseidx = 0;
        Iterator iter = bsids.iterator();
        DynmapBlockState.Builder bld = new DynmapBlockState.Builder();
        while (iter.hasNext()) {
            DynmapBlockState dbs;
            String bn;
            ResourceLocation ui;
            Block b;
            BlockState bs = (BlockState)iter.next();
            int idx = bsids.m_7447_((Object)bs);
            if (idx >= stateByID.length) {
                int plen = stateByID.length;
                stateByID = Arrays.copyOf(stateByID, idx * 11 / 10);
                Arrays.fill(stateByID, plen, stateByID.length, DynmapBlockState.AIR);
            }
            if ((b = bs.m_60734_()) != baseb) {
                basebs = null;
                baseidx = idx;
                baseb = b;
            }
            if ((ui = b.getRegistryName()) == null || (bn = ui.m_135827_() + ":" + ui.m_135815_()).equals(DynmapBlockState.AIR_BLOCK)) continue;
            Material mat = bs.m_60767_();
            Object statename = "";
            for (net.minecraft.world.level.block.state.properties.Property p : bs.m_61147_()) {
                if (((String)statename).length() > 0) {
                    statename = (String)statename + ",";
                }
                statename = (String)statename + p.m_61708_() + "=" + bs.m_61143_(p).toString();
            }
            int lightAtten = 15;
            try {
                lightAtten = bs.m_60804_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_) ? 15 : (bs.m_60631_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_) ? 0 : 1);
            }
            catch (Exception x) {
                Log.warning(String.format("Exception while checking lighting data for block state: %s[%s]", bn, statename));
                Log.verboseinfo("Exception: " + x.toString());
            }
            bld.setBaseState(basebs).setStateIndex(idx - baseidx).setBlockName(bn).setStateName((String)statename).setMaterial(mat.toString()).setLegacyBlockID(idx).setAttenuatesLight(lightAtten);
            if (mat.m_76333_()) {
                bld.setSolid();
            }
            if (mat == Material.f_76296_) {
                bld.setAir();
            }
            if (mat == Material.f_76320_) {
                bld.setLog();
            }
            if (mat == Material.f_76274_) {
                bld.setLeaves();
            }
            if (!bs.m_60819_().m_76178_() && !(bs.m_60734_() instanceof LiquidBlock)) {
                bld.setWaterlogged();
            }
            DynmapPlugin.stateByID[idx] = dbs = bld.build();
            if (basebs != null) continue;
            basebs = dbs;
        }
        for (int gidx = 0; gidx < DynmapBlockState.getGlobalIndexMax(); ++gidx) {
            DynmapBlockState dynmapBlockState = DynmapBlockState.getStateByGlobalIndex(gidx);
        }
    }

    public static final Biome[] getBiomeList() {
        if (biomelist == null) {
            biomelist = new Biome[256];
            for (Biome b : DynmapPlugin.getBiomeReg()) {
                int bidx = DynmapPlugin.getBiomeReg().m_7447_((Object)b);
                if (bidx >= biomelist.length) {
                    biomelist = Arrays.copyOf(biomelist, bidx + biomelist.length);
                }
                DynmapPlugin.biomelist[bidx] = b;
            }
        }
        return biomelist;
    }

    private ForgePlayer getOrAddPlayer(ServerPlayer p) {
        String name = p.m_7755_().getString();
        ForgePlayer fp = this.players.get(name);
        if (fp != null) {
            fp.player = p;
        } else {
            fp = new ForgePlayer(p);
            this.players.put(name, fp);
        }
        return fp;
    }

    public DynmapPlugin(MinecraftServer srv) {
        plugin = this;
        server = srv;
    }

    public boolean isOp(String player) {
        String[] ops;
        for (String op : ops = server.m_6846_().m_11307_().m_5875_()) {
            if (!op.equalsIgnoreCase(player)) continue;
            return true;
        }
        return server.m_129792_() && player.equalsIgnoreCase(server.m_129791_());
    }

    private boolean hasPerm(ServerPlayer psender, String permission) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (psender != null && ph != null && ph.hasPermission(psender.m_7755_().getString(), permission)) {
            return true;
        }
        return this.permissions.has(psender, permission);
    }

    private boolean hasPermNode(ServerPlayer psender, String permission) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (psender != null && ph != null && ph.hasPermissionNode(psender.m_7755_().getString(), permission)) {
            return true;
        }
        return this.permissions.hasPermissionNode(psender, permission);
    }

    private Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        Set<String> rslt = null;
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null) {
            rslt = ph.hasOfflinePermissions(player, perms);
        }
        Set<String> rslt2 = this.hasOfflinePermissions(player, perms);
        if (rslt != null && rslt2 != null) {
            HashSet<String> newrslt = new HashSet<String>(rslt);
            newrslt.addAll(rslt2);
            rslt = newrslt;
        } else if (rslt2 != null) {
            rslt = rslt2;
        }
        return rslt;
    }

    private boolean hasOfflinePermission(String player, String perm) {
        PermissionsHandler ph = PermissionsHandler.getHandler();
        if (ph != null && ph.hasOfflinePermission(player, perm)) {
            return true;
        }
        return this.permissions.hasOfflinePermission(player, perm);
    }

    public void loadExtraBiomes(String mcver) {
        int cnt = 0;
        BiomeMap.loadWellKnownByVersion(mcver);
        Biome[] list = DynmapPlugin.getBiomeList();
        for (int i = 0; i < list.length; ++i) {
            Biome bb = list[i];
            if (bb == null) continue;
            String id = bb.getRegistryName().m_135815_();
            String rl = bb.getRegistryName().toString();
            float tmp = bb.m_47554_();
            float hum = bb.m_47548_();
            int watermult = bb.m_47560_();
            Log.verboseinfo("biome[" + i + "]: hum=" + hum + ", tmp=" + tmp + ", mult=" + Integer.toHexString(watermult));
            BiomeMap bmap = BiomeMap.NULL;
            bmap = rl != null ? BiomeMap.byBiomeResourceLocation(rl) : BiomeMap.byBiomeID(i);
            if (bmap.isDefault() || bmap == BiomeMap.NULL) {
                bmap = new BiomeMap(rl != null ? -2 : i, id, tmp, hum, rl);
                Log.verboseinfo("Add custom biome [" + bmap.toString() + "] (" + i + ")");
                ++cnt;
            } else {
                bmap.setTemperature(tmp);
                bmap.setRainfall(hum);
            }
            if (watermult == -1) continue;
            bmap.setWaterColorMultiplier(watermult);
            Log.verboseinfo("Set watercolormult for " + bmap.toString() + " (" + i + ") to " + Integer.toHexString(watermult));
        }
        if (cnt > 0) {
            Log.info("Added " + cnt + " custom biome mappings");
        }
    }

    private String[] getBiomeNames() {
        Biome[] list = DynmapPlugin.getBiomeList();
        String[] lst = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            Biome bb = list[i];
            if (bb == null) continue;
            lst[i] = bb.toString();
        }
        return lst;
    }

    public void onEnable() {
        File dataDirectory;
        String mcver = server.m_7630_();
        this.loadExtraBiomes(mcver);
        this.registerPlayerLoginListener();
        this.permissions = FilePermissions.create();
        if (this.permissions == null) {
            this.permissions = new OpPermissions(new String[]{"webchat", "marker.icons", "marker.list", "webregister", "stats", "hide.self", "show.self"});
        }
        if (!(dataDirectory = new File("dynmap")).exists()) {
            dataDirectory.mkdirs();
        }
        if (this.core == null) {
            this.core = new DynmapCore();
        }
        this.core.setPluginJarFile(DynmapMod.jarfile);
        this.core.setPluginVersion(DynmapMod.ver);
        this.core.setMinecraftVersion(mcver);
        this.core.setDataFolder(dataDirectory);
        this.core.setServer(this.fserver);
        this.core.setTriggerDefault(TRIGGER_DEFAULTS);
        this.core.setBiomeNames(this.getBiomeNames());
        if (!this.core.initConfiguration(null)) {
            return;
        }
        File filepermexample = new File(this.core.getDataFolder(), "permissions.yml.example");
        this.core.createDefaultFileFromResource("/permissions.yml.example", filepermexample);
        DynmapCommonAPIListener.apiInitialized(this.core);
    }

    private static int test(CommandSource source) throws CommandSyntaxException {
        Log.warning(source.toString());
        return 1;
    }

    public void onStarting(CommandDispatcher<CommandSourceStack> cd) {
        this.dynmapCmd = new DynmapCommand(this);
        this.dmapCmd = new DmapCommand(this);
        this.dmarkerCmd = new DmarkerCommand(this);
        this.dynmapexpCmd = new DynmapExpCommand(this);
        this.dynmapCmd.register(cd);
        this.dmapCmd.register(cd);
        this.dmarkerCmd.register(cd);
        this.dynmapexpCmd.register(cd);
        Log.info("Register commands");
    }

    public void onStart() {
        this.initializeBlockStates();
        if (!this.core.enableCore(null)) {
            return;
        }
        this.core_enabled = true;
        VersionCheck.runCheck(this.core);
        this.perTickLimit = this.core.getMaxTickUseMS() * 1000000;
        this.lasttick = System.nanoTime();
        this.tps = 20.0;
        if (!this.tickregistered) {
            MinecraftForge.EVENT_BUS.register((Object)this.fserver);
            this.tickregistered = true;
        }
        this.playerList = this.core.playerList;
        this.sscache = new GenericChunkCache(this.core.getSnapShotCacheSize(), this.core.useSoftRefInSnapShotCache());
        this.mapManager = this.core.getMapManager();
        this.loadWorlds();
        for (ServerLevel world : server.m_129785_()) {
            ForgeWorld forgeWorld = this.getWorld(world);
        }
        for (ForgeWorld w : this.worlds.values()) {
            if (!this.core.processWorldLoad(w) || !w.isLoaded()) continue;
            this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, w);
        }
        this.core.updateConfigHashcode();
        this.registerEvents();
        Log.info("Register events");
        Log.info("Enabled");
    }

    public void onDisable() {
        DynmapCommonAPIListener.apiTerminated();
        this.saveWorlds();
        this.fserver.runqueue.clear();
        this.core.disableCore();
        this.core_enabled = false;
        if (this.sscache != null) {
            this.sscache.cleanup();
            this.sscache = null;
        }
        Log.info("Disabled");
    }

    void onCommand(CommandSourceStack commandSourceStack, String cmd, String[] args) {
        ServerPlayer psender;
        try {
            psender = commandSourceStack.m_81375_();
        }
        catch (CommandSyntaxException x) {
            psender = null;
        }
        ForgeCommandSender dsender = psender != null ? new ForgePlayer(psender) : new ForgeCommandSender(commandSourceStack);
        try {
            this.core.processCommand(dsender, cmd, cmd, args);
        }
        catch (Exception x) {
            dsender.sendMessage("Command internal error: " + x.getMessage());
            Log.severe("Error with command: " + cmd + Arrays.deepToString(args), x);
        }
    }

    private DynmapLocation toLoc(ServerLevel level, double x, double y, double z) {
        return new DynmapLocation(this.getWorld(level).getName(), x, y, z);
    }

    private void registerPlayerLoginListener() {
        if (this.playerTracker == null) {
            this.playerTracker = new PlayerTracker();
            MinecraftForge.EVENT_BUS.register((Object)this.playerTracker);
        }
    }

    private void registerEvents() {
        this.onblockchange = this.core.isTrigger("blockupdate");
        this.onchunkpopulate = this.core.isTrigger("chunkpopulate");
        this.onchunkgenerate = this.core.isTrigger("chunkgenerate");
        this.onblockchange_with_id = this.core.isTrigger("blockupdate-with-id");
        if (this.onblockchange_with_id) {
            this.onblockchange = true;
        }
        if (this.worldTracker == null && (this.onblockchange || this.onchunkpopulate || this.onchunkgenerate)) {
            this.worldTracker = new WorldTracker();
            MinecraftForge.EVENT_BUS.register((Object)this.worldTracker);
        }
        if (this.onchunkgenerate && server.m_129785_() != null) {
            for (ServerLevel world : server.m_129785_()) {
                ForgeWorld fw = this.getWorld(world);
                if (fw == null) continue;
                Long2ObjectLinkedOpenHashMap chunks = world.m_7726_().f_8325_.f_140130_;
                for (Map.Entry k : chunks.long2ObjectEntrySet()) {
                    long key = (Long)k.getKey();
                    ChunkHolder ch = (ChunkHolder)k.getValue();
                    ChunkAccess c = null;
                    try {
                        c = ch.m_140089_();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (c == null) continue;
                    ChunkStatus cs = c.m_6415_();
                    ChunkPos pos = ch.m_140092_();
                    if (cs != ChunkStatus.f_62326_) continue;
                    this.addKnownChunk(fw, pos);
                }
            }
        }
    }

    private ForgeWorld getWorldByName(String name) {
        return this.worlds.get(name);
    }

    private ForgeWorld getWorld(ServerLevel w) {
        return this.getWorld(w, true);
    }

    private ForgeWorld getWorld(ServerLevel w, boolean add_if_not_found) {
        if (this.last_world == w) {
            return this.last_fworld;
        }
        String wname = ForgeWorld.getWorldName((ServerLevelAccessor)w);
        for (ForgeWorld fw : this.worlds.values()) {
            if (!fw.getRawName().equals(wname)) continue;
            this.last_world = w;
            this.last_fworld = fw;
            if (!fw.isLoaded()) {
                fw.setWorldLoaded((ServerLevelAccessor)w);
            }
            fw.updateWorld((ServerLevelAccessor)w);
            return fw;
        }
        ForgeWorld fw = null;
        if (add_if_not_found) {
            fw = new ForgeWorld((ServerLevelAccessor)w);
            this.worlds.put(fw.getName(), fw);
        }
        this.last_world = w;
        this.last_fworld = fw;
        return fw;
    }

    private void saveWorlds() {
        File f = new File(this.core.getDataFolder(), "forgeworlds.yml");
        ConfigurationNode cn = new ConfigurationNode(f);
        ArrayList lst = new ArrayList();
        for (DynmapWorld fw : this.core.mapManager.getWorlds()) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put("name", fw.getRawName());
            vals.put("height", fw.worldheight);
            vals.put("miny", fw.minY);
            vals.put("sealevel", fw.sealevel);
            vals.put("nether", fw.isNether());
            vals.put("the_end", ((ForgeWorld)fw).isTheEnd());
            vals.put("title", fw.getTitle());
            lst.add(vals);
        }
        cn.put("worlds", (Object)lst);
        cn.put("useSaveFolderAsName", (Object)this.useSaveFolder);
        cn.put("maxWorldHeight", (Object)ForgeWorld.getMaxWorldHeight());
        cn.save();
    }

    private void loadWorlds() {
        List<Map<String, Object>> lst;
        File f = new File(this.core.getDataFolder(), "forgeworlds.yml");
        if (!f.canRead()) {
            this.useSaveFolder = true;
            return;
        }
        ConfigurationNode cn = new ConfigurationNode(f);
        cn.load();
        ForgeWorld.setMaxWorldHeight(cn.getInteger("maxWorldHeight", 256));
        if (cn.containsKey("useSaveFolderAsName")) {
            this.useSaveFolder = cn.getBoolean("useSaveFolderAsName", this.useSaveFolder);
        }
        if ((lst = cn.getMapList("worlds")) == null) {
            Log.warning("Discarding bad forgeworlds.yml");
            return;
        }
        for (Map<String, Object> world : lst) {
            try {
                String name = (String)world.get("name");
                int height = (Integer)world.get("height");
                Integer miny = (Integer)world.get("miny");
                int sealevel = (Integer)world.get("sealevel");
                boolean nether = (Boolean)world.get("nether");
                boolean theend = (Boolean)world.get("the_end");
                String title = (String)world.get("title");
                if (name == null) continue;
                ForgeWorld fw = new ForgeWorld(name, height, sealevel, nether, theend, title, miny != null ? miny : 0);
                fw.setWorldUnloaded();
                this.core.processWorldLoad(fw);
                this.worlds.put(fw.getName(), fw);
            }
            catch (Exception x) {
                Log.warning("Unable to load saved worlds from forgeworlds.yml");
                return;
            }
        }
    }

    public void serverStarted() {
        this.onStart();
        if (this.core != null) {
            this.core.serverStarted();
        }
    }

    public MinecraftServer getMCServer() {
        return server;
    }

    static {
        TRIGGER_DEFAULTS = new String[]{"blockupdate", "chunkpopulate", "chunkgenerate"};
        patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
        reg = null;
        biomelist = null;
        gson = new GsonBuilder().create();
    }

    public class ForgePlayer
    extends ForgeCommandSender
    implements DynmapPlayer {
        private ServerPlayer player;
        private final String skinurl;
        private final UUID uuid;

        public ForgePlayer(ServerPlayer p) {
            this.player = p;
            String url = null;
            if (this.player != null) {
                Property textureProperty;
                this.uuid = this.player.m_142081_();
                GameProfile prof = this.player.m_36316_();
                if (prof != null && (textureProperty = (Property)Iterables.getFirst((Iterable)prof.getProperties().get((Object)"textures"), null)) != null) {
                    TexturesPayload result = null;
                    try {
                        String json = new String(Base64.getDecoder().decode(textureProperty.getValue()), StandardCharsets.UTF_8);
                        result = (TexturesPayload)gson.fromJson(json, TexturesPayload.class);
                    }
                    catch (JsonParseException jsonParseException) {
                        // empty catch block
                    }
                    if (result != null && result.textures != null && result.textures.containsKey("SKIN")) {
                        url = result.textures.get((Object)"SKIN").url;
                    }
                }
            } else {
                this.uuid = null;
            }
            this.skinurl = url;
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public String getName() {
            if (this.player != null) {
                String n = this.player.m_7755_().getString();
                return n;
            }
            return "[Server]";
        }

        @Override
        public String getDisplayName() {
            if (this.player != null) {
                String n = this.player.m_5446_().getString();
                return n;
            }
            return "[Server]";
        }

        @Override
        public boolean isOnline() {
            return true;
        }

        @Override
        public DynmapLocation getLocation() {
            if (this.player == null) {
                return null;
            }
            Vec3 v = this.player.m_20182_();
            return DynmapPlugin.this.toLoc(this.player.m_183503_(), v.f_82479_, v.f_82480_, v.f_82481_);
        }

        @Override
        public String getWorld() {
            if (this.player == null) {
                return null;
            }
            if (this.player.f_19853_ != null) {
                return DynmapPlugin.this.getWorld((ServerLevel)this.player.f_19853_).getName();
            }
            return null;
        }

        public static final Connection getNetworkManager(ServerGamePacketListenerImpl nh) {
            return nh.f_9742_;
        }

        @Override
        public InetSocketAddress getAddress() {
            SocketAddress sa;
            ServerGamePacketListenerImpl nsh;
            if (this.player != null && this.player instanceof ServerPlayer && (nsh = this.player.f_8906_) != null && ForgePlayer.getNetworkManager(nsh) != null && (sa = ForgePlayer.getNetworkManager(nsh).m_129523_()) instanceof InetSocketAddress) {
                return (InetSocketAddress)sa;
            }
            return null;
        }

        @Override
        public boolean isSneaking() {
            if (this.player != null) {
                return this.player.m_20089_() == Pose.CROUCHING;
            }
            return false;
        }

        @Override
        public double getHealth() {
            if (this.player != null) {
                double h = this.player.m_21223_();
                if (h > 20.0) {
                    h = 20.0;
                }
                return h;
            }
            return 0.0;
        }

        @Override
        public int getArmorPoints() {
            if (this.player != null) {
                return this.player.m_21230_();
            }
            return 0;
        }

        @Override
        public DynmapLocation getBedSpawnLocation() {
            return null;
        }

        @Override
        public long getLastLoginTime() {
            return 0L;
        }

        @Override
        public long getFirstLoginTime() {
            return 0L;
        }

        @Override
        public boolean hasPrivilege(String privid) {
            if (this.player != null) {
                return DynmapPlugin.this.hasPerm(this.player, privid);
            }
            return false;
        }

        @Override
        public boolean isOp() {
            return DynmapPlugin.this.isOp(this.player.m_7755_().getString());
        }

        @Override
        public void sendMessage(String msg) {
            TextComponent ichatcomponent = new TextComponent(msg);
            this.player.m_6352_((Component)ichatcomponent, Util.f_137441_);
        }

        @Override
        public boolean isInvisible() {
            if (this.player != null) {
                return this.player.m_20145_();
            }
            return false;
        }

        @Override
        public int getSortWeight() {
            Integer wt = DynmapPlugin.this.sortWeights.get(this.getName());
            if (wt != null) {
                return wt;
            }
            return 0;
        }

        @Override
        public void setSortWeight(int wt) {
            if (wt == 0) {
                DynmapPlugin.this.sortWeights.remove(this.getName());
            } else {
                DynmapPlugin.this.sortWeights.put(this.getName(), wt);
            }
        }

        @Override
        public boolean hasPermissionNode(String node) {
            if (this.player != null) {
                return DynmapPlugin.this.hasPermNode(this.player, node);
            }
            return false;
        }

        @Override
        public String getSkinURL() {
            return this.skinurl;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public void sendTitleText(String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
            if (this.player instanceof ServerPlayer) {
                ServerPlayer mp = this.player;
                ClientboundSetTitlesAnimationPacket times = new ClientboundSetTitlesAnimationPacket(fadeInTicks, stayTicks, fadeOutTicks);
                mp.f_8906_.m_141995_((Packet)times);
                if (title != null) {
                    ClientboundSetTitleTextPacket titlepkt = new ClientboundSetTitleTextPacket((Component)new TextComponent(title));
                    mp.f_8906_.m_141995_((Packet)titlepkt);
                }
                if (subtitle != null) {
                    ClientboundSetSubtitleTextPacket subtitlepkt = new ClientboundSetSubtitleTextPacket((Component)new TextComponent(subtitle));
                    mp.f_8906_.m_141995_((Packet)subtitlepkt);
                }
            }
        }
    }

    public class ForgeServer
    extends DynmapServerInterface {
        private Object schedlock = new Object();
        private long cur_tick;
        private long next_id;
        private long cur_tick_starttime;
        private PriorityQueue<TaskRecord> runqueue = new PriorityQueue();
        private Set<DynmapListenerManager.EventType> registered = new HashSet<DynmapListenerManager.EventType>();

        private GameProfile getProfileByName(String player) {
            GameProfileCache cache = server.m_129927_();
            Optional val = cache.m_10996_(player);
            return val.isPresent() ? (GameProfile)val.get() : null;
        }

        @Override
        public int getBlockIDAt(String wname, int x, int y, int z) {
            return -1;
        }

        @Override
        public int isSignAt(String wname, int x, int y, int z) {
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleServerTask(Runnable run, long delay) {
            TaskRecord tr = new TaskRecord();
            tr.future = new FutureTask<Object>(run, null);
            Object object = this.schedlock;
            synchronized (object) {
                tr.id = this.next_id++;
                tr.ticktorun = this.cur_tick + delay;
                this.runqueue.add(tr);
            }
        }

        @Override
        public DynmapPlayer[] getOnlinePlayers() {
            if (server.m_6846_() == null) {
                return new DynmapPlayer[0];
            }
            List playlist = server.m_6846_().m_11314_();
            int pcnt = playlist.size();
            DynmapPlayer[] dplay = new DynmapPlayer[pcnt];
            for (int i = 0; i < pcnt; ++i) {
                ServerPlayer p = (ServerPlayer)playlist.get(i);
                dplay[i] = DynmapPlugin.this.getOrAddPlayer(p);
            }
            return dplay;
        }

        @Override
        public void reload() {
            plugin.onDisable();
            plugin.onEnable();
            plugin.onStart();
        }

        @Override
        public DynmapPlayer getPlayer(String name) {
            List players = server.m_6846_().m_11314_();
            for (ServerPlayer p : players) {
                if (!p.m_7755_().getString().equalsIgnoreCase(name)) continue;
                return DynmapPlugin.this.getOrAddPlayer(p);
            }
            return null;
        }

        @Override
        public Set<String> getIPBans() {
            UserBanList bl = server.m_6846_().m_11295_();
            HashSet<String> ips = new HashSet<String>();
            for (String s : bl.m_5875_()) {
                ips.add(s);
            }
            return ips;
        }

        @Override
        public <T> Future<T> callSyncMethod(Callable<T> task) {
            return this.callSyncMethod(task, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> Future<T> callSyncMethod(Callable<T> task, long delay) {
            TaskRecord tr = new TaskRecord();
            FutureTask<T> ft = new FutureTask<T>(task);
            tr.future = ft;
            Object object = this.schedlock;
            synchronized (object) {
                tr.id = this.next_id++;
                tr.ticktorun = this.cur_tick + delay;
                this.runqueue.add(tr);
            }
            return ft;
        }

        @Override
        public String getServerName() {
            String sn = server.m_129792_() ? "Integrated" : server.m_130009_();
            if (sn == null) {
                sn = "Unknown Server";
            }
            return sn;
        }

        @Override
        public boolean isPlayerBanned(String pid) {
            UserBanList bl = server.m_6846_().m_11295_();
            return bl.m_11406_(this.getProfileByName(pid));
        }

        @Override
        public String stripChatColor(String s) {
            return patternControlCode.matcher(s).replaceAll("");
        }

        @Override
        public boolean requestEventNotification(DynmapListenerManager.EventType type) {
            if (this.registered.contains((Object)type)) {
                return true;
            }
            switch (type) {
                case WORLD_LOAD: 
                case WORLD_UNLOAD: {
                    break;
                }
                case WORLD_SPAWN_CHANGE: {
                    break;
                }
                case PLAYER_JOIN: 
                case PLAYER_QUIT: {
                    break;
                }
                case PLAYER_BED_LEAVE: {
                    break;
                }
                case PLAYER_CHAT: {
                    if (DynmapPlugin.this.chathandler != null) break;
                    DynmapPlugin.this.chathandler = new ChatHandler();
                    MinecraftForge.EVENT_BUS.register((Object)DynmapPlugin.this.chathandler);
                    break;
                }
                case BLOCK_BREAK: {
                    break;
                }
                case SIGN_CHANGE: {
                    break;
                }
                default: {
                    Log.severe("Unhandled event type: " + type);
                    return false;
                }
            }
            this.registered.add(type);
            return true;
        }

        @Override
        public boolean sendWebChatEvent(String source, String name, String msg) {
            return DynmapCommonAPIListener.fireWebChatEvent(source, name, msg);
        }

        @Override
        public void broadcastMessage(String msg) {
            TextComponent component = new TextComponent(msg);
            server.m_6846_().m_11264_((Component)component, ChatType.SYSTEM, Util.f_137441_);
            Log.info(this.stripChatColor(msg));
        }

        @Override
        public String[] getBiomeIDs() {
            BiomeMap[] b = BiomeMap.values();
            String[] bname = new String[b.length];
            for (int i = 0; i < bname.length; ++i) {
                bname[i] = b[i].toString();
            }
            return bname;
        }

        @Override
        public double getCacheHitRate() {
            if (DynmapPlugin.this.sscache != null) {
                return DynmapPlugin.this.sscache.getHitRate();
            }
            return 0.0;
        }

        @Override
        public void resetCacheStats() {
            if (DynmapPlugin.this.sscache != null) {
                DynmapPlugin.this.sscache.resetStats();
            }
        }

        @Override
        public DynmapWorld getWorldByName(String wname) {
            return DynmapPlugin.this.getWorldByName(wname);
        }

        @Override
        public DynmapPlayer getOfflinePlayer(String name) {
            return null;
        }

        @Override
        public Set<String> checkPlayerPermissions(String player, Set<String> perms) {
            net.minecraft.server.players.PlayerList scm = server.m_6846_();
            if (scm == null) {
                return Collections.emptySet();
            }
            UserBanList bl = scm.m_11295_();
            if (bl == null) {
                return Collections.emptySet();
            }
            if (bl.m_11406_(this.getProfileByName(player))) {
                return Collections.emptySet();
            }
            Set<String> rslt = DynmapPlugin.this.hasOfflinePermissions(player, perms);
            if (rslt == null) {
                rslt = new HashSet<String>();
                if (plugin.isOp(player)) {
                    rslt.addAll(perms);
                }
            }
            return rslt;
        }

        @Override
        public boolean checkPlayerPermission(String player, String perm) {
            net.minecraft.server.players.PlayerList scm = server.m_6846_();
            if (scm == null) {
                return false;
            }
            UserBanList bl = scm.m_11295_();
            if (bl == null) {
                return false;
            }
            if (bl.m_11406_(this.getProfileByName(player))) {
                return false;
            }
            return DynmapPlugin.this.hasOfflinePermission(player, perm);
        }

        @Override
        public MapChunkCache createMapChunkCache(DynmapWorld w, List<DynmapChunk> chunks, boolean blockdata, boolean highesty, boolean biome, boolean rawbiome) {
            ForgeMapChunkCache c = (ForgeMapChunkCache)w.getChunkCache(chunks);
            if (c == null) {
                return null;
            }
            if (w.visibility_limits != null) {
                for (VisibilityLimit limit : w.visibility_limits) {
                    c.setVisibleRange(limit);
                }
                c.setHiddenFillStyle(w.hiddenchunkstyle);
            }
            if (w.hidden_limits != null) {
                for (VisibilityLimit limit : w.hidden_limits) {
                    c.setHiddenRange(limit);
                }
                c.setHiddenFillStyle(w.hiddenchunkstyle);
            }
            if (chunks.size() == 0) {
                c.loadChunks(0);
                return c;
            }
            final ForgeMapChunkCache cc = c;
            Future<Boolean> f = this.callSyncMethod(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ForgeWorld fw = (ForgeWorld)cc.getWorld();
                    cc.getLoadedChunks();
                    return true;
                }
            }, 0L);
            try {
                f.get();
            }
            catch (CancellationException cx) {
                return null;
            }
            catch (ExecutionException xx) {
                Log.severe("Exception while loading chunks", xx.getCause());
                return null;
            }
            catch (Exception ix) {
                Log.severe(ix);
                return null;
            }
            if (!w.isLoaded()) {
                return null;
            }
            c.readChunks(chunks.size());
            return c;
        }

        @Override
        public int getMaxPlayers() {
            return server.m_7418_();
        }

        @Override
        public int getCurrentPlayers() {
            return server.m_6846_().m_11309_();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void tickEvent(TickEvent.ServerTickEvent event) {
            long now;
            if (event.phase == TickEvent.Phase.START) {
                return;
            }
            this.cur_tick_starttime = System.nanoTime();
            long elapsed = this.cur_tick_starttime - DynmapPlugin.this.lasttick;
            DynmapPlugin.this.lasttick = this.cur_tick_starttime;
            DynmapPlugin.this.avgticklen = DynmapPlugin.this.avgticklen * 99L / 100L + elapsed / 100L;
            DynmapPlugin.this.tps = 1.0E9 / (double)DynmapPlugin.this.avgticklen;
            if (DynmapPlugin.this.core != null) {
                DynmapPlugin.this.core.serverTick(DynmapPlugin.this.tps);
            }
            boolean done = false;
            TaskRecord tr = null;
            while (!DynmapPlugin.this.blockupdatequeue.isEmpty()) {
                BlockUpdateRec r = (BlockUpdateRec)DynmapPlugin.this.blockupdatequeue.remove();
                BlockState bs = r.w.m_8055_(new BlockPos(r.x, r.y, r.z));
                int idx = Block.f_49791_.m_7447_((Object)bs);
                if (idx < 0 || HDBlockModels.isChangeIgnoredBlock(stateByID[idx])) continue;
                if (DynmapPlugin.this.onblockchange_with_id) {
                    DynmapPlugin.this.mapManager.touch(r.wid, r.x, r.y, r.z, "blockchange[" + idx + "]");
                    continue;
                }
                DynmapPlugin.this.mapManager.touch(r.wid, r.x, r.y, r.z, "blockchange");
            }
            Object idx = this.schedlock;
            synchronized (idx) {
                ++this.cur_tick;
                now = System.nanoTime();
                tr = this.runqueue.peek();
                if (tr == null || tr.ticktorun > this.cur_tick || now - this.cur_tick_starttime > DynmapPlugin.this.perTickLimit) {
                    done = true;
                } else {
                    tr = this.runqueue.poll();
                }
            }
            while (!done) {
                tr.future.run();
                idx = this.schedlock;
                synchronized (idx) {
                    tr = this.runqueue.peek();
                    now = System.nanoTime();
                    if (tr == null || tr.ticktorun > this.cur_tick || now - this.cur_tick_starttime > DynmapPlugin.this.perTickLimit) {
                        done = true;
                    } else {
                        tr = this.runqueue.poll();
                    }
                }
            }
            while (!DynmapPlugin.this.msgqueue.isEmpty()) {
                ChatMessage cm = DynmapPlugin.this.msgqueue.poll();
                ForgePlayer dp = null;
                dp = cm.sender != null ? DynmapPlugin.this.getOrAddPlayer(cm.sender) : new ForgePlayer(null);
                DynmapPlugin.this.core.listenerManager.processChatEvent(DynmapListenerManager.EventType.PLAYER_CHAT, dp, cm.message);
            }
            if (this.cur_tick % 20L == 0L) {
                // empty if block
            }
        }

        @Override
        public boolean isModLoaded(String name) {
            boolean loaded = ModList.get().isLoaded(name);
            if (loaded) {
                DynmapPlugin.this.modsused.add(name);
            }
            return loaded;
        }

        @Override
        public String getModVersion(String name) {
            Optional mod = ModList.get().getModContainerById(name);
            if (mod.isPresent()) {
                ArtifactVersion vi = ((ModContainer)mod.get()).getModInfo().getVersion();
                return vi.getMajorVersion() + "." + vi.getMinorVersion() + "." + vi.getIncrementalVersion();
            }
            return null;
        }

        @Override
        public double getServerTPS() {
            return DynmapPlugin.this.tps;
        }

        @Override
        public String getServerIP() {
            if (server.m_129792_()) {
                return "0.0.0.0";
            }
            return server.m_130009_();
        }

        @Override
        public File getModContainerFile(String name) {
            ModFileInfo mfi = LoadingModList.get().getModFileById(name);
            if (mfi != null) {
                File f = mfi.getFile().getFilePath().toFile();
                return f;
            }
            return null;
        }

        @Override
        public List<String> getModList() {
            List mil = LoadingModList.get().getMods();
            ArrayList<String> lst = new ArrayList<String>();
            for (ModInfo mi : mil) {
                lst.add(mi.getModId());
            }
            return lst;
        }

        @Override
        public Map<Integer, String> getBlockIDMap() {
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            return map;
        }

        @Override
        public InputStream openResource(String modid, String rname) {
            Optional mc;
            Object mod;
            if (modid == null) {
                modid = "minecraft";
            }
            Object object = mod = (mc = ModList.get().getModContainerById(modid)).isPresent() ? ((ModContainer)mc.get()).getMod() : null;
            if (mod != null) {
                InputStream is;
                ClassLoader cl = mod.getClass().getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if ((is = cl.getResourceAsStream(rname)) != null) {
                    return is;
                }
            }
            List mcl = LoadingModList.get().getMods();
            for (ModInfo mci : mcl) {
                InputStream is;
                mc = ModList.get().getModContainerById(mci.getModId());
                mod = mc.isPresent() ? ((ModContainer)mc.get()).getMod() : null;
                if (mod == null) continue;
                ClassLoader cl = mod.getClass().getClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if ((is = cl.getResourceAsStream(rname)) == null) continue;
                return is;
            }
            return null;
        }

        @Override
        public Map<String, Integer> getBlockUniqueIDMap() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            return map;
        }

        @Override
        public Map<String, Integer> getItemUniqueIDMap() {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            return map;
        }
    }

    public class PlayerTracker {
        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final ForgePlayer dp = DynmapPlugin.this.getOrAddPlayer((ServerPlayer)event.getPlayer());
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    DynmapPlugin.this.core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_JOIN, dp);
                }
            }, 2L);
        }

        @SubscribeEvent
        public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            final ForgePlayer dp = DynmapPlugin.this.getOrAddPlayer((ServerPlayer)event.getPlayer());
            final String name = event.getPlayer().m_7755_().getString();
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    DynmapPlugin.this.core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_QUIT, dp);
                    DynmapPlugin.this.players.remove(name);
                }
            }, 0L);
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            DynmapPlugin.this.getOrAddPlayer((ServerPlayer)event.getPlayer());
        }

        @SubscribeEvent
        public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            DynmapPlugin.this.getOrAddPlayer((ServerPlayer)event.getPlayer());
        }
    }

    public class WorldTracker {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void handleWorldLoad(WorldEvent.Load event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            LevelAccessor w = event.getWorld();
            if (!(w instanceof ServerLevel)) {
                return;
            }
            final ForgeWorld fw = DynmapPlugin.this.getWorld((ServerLevel)w);
            DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                @Override
                public void run() {
                    if (DynmapPlugin.this.core.processWorldLoad(fw)) {
                        DynmapPlugin.this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, fw);
                    }
                }
            }, 0L);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void handleWorldUnload(WorldEvent.Unload event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            LevelAccessor w = event.getWorld();
            if (!(w instanceof ServerLevel)) {
                return;
            }
            final ForgeWorld fw = DynmapPlugin.this.getWorld((ServerLevel)w);
            if (fw != null) {
                DynmapPlugin.this.core.getServer().scheduleServerTask(new Runnable(){

                    @Override
                    public void run() {
                        DynmapPlugin.this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_UNLOAD, fw);
                        DynmapPlugin.this.core.processWorldUnload(fw);
                    }
                }, 0L);
                fw.setWorldUnloaded();
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void handleChunkLoad(ChunkEvent.Load event) {
            ForgeWorld fw;
            if (!DynmapPlugin.this.onchunkgenerate) {
                return;
            }
            LevelAccessor w = event.getWorld();
            if (!(w instanceof ServerLevel)) {
                return;
            }
            ChunkAccess c = event.getChunk();
            if (c != null && c.m_6415_() == ChunkStatus.f_62326_ && c instanceof LevelChunk && (fw = DynmapPlugin.this.getWorld((ServerLevel)w, false)) != null) {
                DynmapPlugin.this.addKnownChunk(fw, c.m_7697_());
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void handleChunkUnload(ChunkEvent.Unload event) {
            if (!DynmapPlugin.this.onchunkgenerate) {
                return;
            }
            LevelAccessor w = event.getWorld();
            if (!(w instanceof ServerLevel)) {
                return;
            }
            ChunkAccess c = event.getChunk();
            if (c != null) {
                ForgeWorld fw = DynmapPlugin.this.getWorld((ServerLevel)w, false);
                ChunkPos cp = c.m_7697_();
                if (fw != null) {
                    if (!DynmapPlugin.this.checkIfKnownChunk(fw, cp)) {
                        int ymax = Integer.MIN_VALUE;
                        int ymin = Integer.MAX_VALUE;
                        LevelChunkSection[] sections = c.m_7103_();
                        for (int i = 0; i < sections.length; ++i) {
                            if (sections[i] == null || sections[i].m_188008_()) continue;
                            int sy = sections[i].m_63017_();
                            if (sy < ymin) {
                                ymin = sy;
                            }
                            if (sy + 16 <= ymax) continue;
                            ymax = sy + 16;
                        }
                        int x = cp.f_45578_ << 4;
                        int z = cp.f_45579_ << 4;
                        if (ymax != Integer.MIN_VALUE) {
                            DynmapPlugin.this.mapManager.touchVolume(fw.getName(), x, ymin, z, x + 15, ymax, z + 15, "chunkgenerate");
                        }
                    }
                    DynmapPlugin.this.removeKnownChunk(fw, cp);
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void handleChunkDataSave(ChunkDataEvent.Save event) {
            if (!DynmapPlugin.this.onchunkgenerate) {
                return;
            }
            LevelAccessor w = event.getWorld();
            if (!(w instanceof ServerLevel)) {
                return;
            }
            ChunkAccess c = event.getChunk();
            if (c != null) {
                ForgeWorld fw = DynmapPlugin.this.getWorld((ServerLevel)w, false);
                ChunkPos cp = c.m_7697_();
                if (fw != null && !DynmapPlugin.this.checkIfKnownChunk(fw, cp)) {
                    int ymax = Integer.MIN_VALUE;
                    int ymin = Integer.MAX_VALUE;
                    LevelChunkSection[] sections = c.m_7103_();
                    for (int i = 0; i < sections.length; ++i) {
                        if (sections[i] == null || sections[i].m_188008_()) continue;
                        int sy = sections[i].m_63017_();
                        if (sy < ymin) {
                            ymin = sy;
                        }
                        if (sy + 16 <= ymax) continue;
                        ymax = sy + 16;
                    }
                    int x = cp.f_45578_ << 4;
                    int z = cp.f_45579_ << 4;
                    if (ymax != Integer.MIN_VALUE) {
                        DynmapPlugin.this.mapManager.touchVolume(fw.getName(), x, ymin, z, x + 15, ymax, z + 15, "chunkgenerate");
                    }
                    if (c.m_6415_() == ChunkStatus.f_62326_ && c instanceof LevelChunk) {
                        DynmapPlugin.this.addKnownChunk(fw, cp);
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void handleBlockEvent(BlockEvent event) {
            if (!DynmapPlugin.this.core_enabled) {
                return;
            }
            if (!DynmapPlugin.this.onblockchange) {
                return;
            }
            BlockUpdateRec r = new BlockUpdateRec();
            r.w = event.getWorld();
            ForgeWorld fw = DynmapPlugin.this.getWorld((ServerLevel)r.w, false);
            if (fw == null) {
                return;
            }
            r.wid = fw.getName();
            BlockPos p = event.getPos();
            r.x = p.m_123341_();
            r.y = p.m_123342_();
            r.z = p.m_123343_();
            DynmapPlugin.this.blockupdatequeue.add(r);
        }
    }

    public class ForgeCommandSender
    implements DynmapCommandSender {
        private CommandSourceStack sender;

        protected ForgeCommandSender() {
            this.sender = null;
        }

        public ForgeCommandSender(CommandSourceStack send) {
            this.sender = send;
        }

        @Override
        public boolean hasPrivilege(String privid) {
            return true;
        }

        @Override
        public void sendMessage(String msg) {
            if (this.sender != null) {
                TextComponent ichatcomponent = new TextComponent(msg);
                this.sender.m_81354_((Component)ichatcomponent, true);
            }
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        public boolean isOp() {
            return true;
        }

        @Override
        public boolean hasPermissionNode(String node) {
            return true;
        }
    }

    public class ProfileTexture {
        public String url;
    }

    public class TexturesPayload {
        public long timestamp;
        public String profileId;
        public String profileName;
        public boolean isPublic;
        public Map<String, ProfileTexture> textures;
    }

    public static class OurLog
    implements DynmapLogger {
        Logger log = LogManager.getLogger((String)"Dynmap");
        public static final String DM = "[Dynmap] ";

        OurLog() {
        }

        @Override
        public void info(String s) {
            this.log.info(DM + s);
        }

        @Override
        public void severe(Throwable t) {
            this.log.fatal((Object)t);
        }

        @Override
        public void severe(String s) {
            this.log.fatal(DM + s);
        }

        @Override
        public void severe(String s, Throwable t) {
            this.log.fatal(DM + s, t);
        }

        @Override
        public void verboseinfo(String s) {
            this.log.info(DM + s);
        }

        @Override
        public void warning(String s) {
            this.log.warn(DM + s);
        }

        @Override
        public void warning(String s, Throwable t) {
            this.log.warn(DM + s, t);
        }
    }

    public class ChatHandler {
        @SubscribeEvent
        public void handleChat(ServerChatEvent event) {
            String msg = event.getMessage();
            if (!msg.startsWith("/")) {
                ChatMessage cm = new ChatMessage();
                cm.message = msg;
                cm.sender = event.getPlayer();
                DynmapPlugin.this.msgqueue.add(cm);
            }
        }
    }

    private class ChatMessage {
        String message;
        ServerPlayer sender;

        private ChatMessage() {
        }
    }

    private static class TaskRecord
    implements Comparable<Object> {
        private long ticktorun;
        private long id;
        private FutureTask<?> future;

        private TaskRecord() {
        }

        @Override
        public int compareTo(Object o) {
            TaskRecord tr = (TaskRecord)o;
            if (this.ticktorun < tr.ticktorun) {
                return -1;
            }
            if (this.ticktorun > tr.ticktorun) {
                return 1;
            }
            if (this.id < tr.id) {
                return -1;
            }
            if (this.id > tr.id) {
                return 1;
            }
            return 0;
        }
    }

    public static class BlockUpdateRec {
        LevelAccessor w;
        String wid;
        int x;
        int y;
        int z;
    }
}

