/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.dynmap.DynmapCore;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.SkinUrlProvider;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.debug.Debug;
import org.dynmap.storage.MapStorage;
import org.dynmap.utils.BufferOutputStream;
import org.dynmap.utils.DynmapBufferedImage;
import org.dynmap.utils.ImageIOManager;

public class PlayerFaces {
    private boolean fetchskins;
    private boolean refreshskins;
    private String skinurl;
    public MapStorage storage;

    private void copyLayersToTarget(BufferedImage srcimg, int layer1x, int layer1y, int layer2x, int layer2y, int w, int h, int[] dest, int destoff, int destscansize) {
        int i;
        int[] l1 = new int[w * h];
        int[] l2 = new int[w * h];
        int imgh = srcimg.getHeight();
        if (imgh >= layer1y + h) {
            srcimg.getRGB(layer1x, layer1y, w, h, l1, 0, w);
        }
        if (imgh >= layer2y + h) {
            srcimg.getRGB(layer2x, layer2y, w, h, l2, 0, w);
        }
        boolean transp = false;
        int v = l2[0];
        for (i = 0; i < w * h; ++i) {
            if ((l2[i] & 0xFF000000) == 0) {
                transp = true;
                break;
            }
            if (l2[i] == v) continue;
            transp = true;
            break;
        }
        if (transp) {
            for (i = 0; i < w * h; ++i) {
                if ((l2[i] & 0xFF000000) == 0) continue;
                l1[i] = l2[i];
            }
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                dest[destoff + (y * destscansize + x)] = l1[y * w + x];
            }
        }
    }

    private void copyLayersToTarget(BufferedImage srcimg, int layer1x, int layer1y, int layer2x, int layer2y, int w, int h, BufferedImage dest, int destoff, int destscansize) {
        int[] tmp = new int[w * h];
        this.copyLayersToTarget(srcimg, layer1x, layer1y, layer2x, layer2y, w, h, tmp, 0, w);
        dest.setRGB(0, 0, w, h, tmp, destoff, destscansize);
    }

    public PlayerFaces(final DynmapCore core) {
        this.fetchskins = core.configuration.getBoolean("fetchskins", true);
        this.refreshskins = core.configuration.getBoolean("refreshskins", true);
        this.skinurl = core.configuration.getString("skin-url", "");
        if (this.skinurl.equals("http://s3.amazonaws.com/MinecraftSkins/%player%.png") || this.skinurl.equals("http://skins.minecraft.net/MinecraftSkins/%player%.png")) {
            this.skinurl = "";
        }
        core.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_JOIN, new DynmapListenerManager.PlayerEventListener(){

            @Override
            public void playerEvent(DynmapPlayer p) {
                LoadPlayerImages job = new LoadPlayerImages(p.getName(), p.getSkinURL(), p.getUUID(), core.skinUrlProvider);
                MapManager.scheduleDelayedJob(job, 0L);
            }
        });
        this.storage = core.getDefaultMapStorage();
    }

    private class LoadPlayerImages
    implements Runnable {
        private SkinUrlProvider mSkinUrlProvider;
        public final String playername;
        public final UUID playeruuid;
        public final String playerskinurl;

        public LoadPlayerImages(String playername, String playerskinurl, UUID playeruuid, SkinUrlProvider skinUrlProvider) {
            this.playername = playername;
            this.playeruuid = playeruuid;
            this.playerskinurl = playerskinurl;
            this.mSkinUrlProvider = skinUrlProvider;
        }

        @Override
        public void run() {
            BufferOutputStream bos;
            BufferOutputStream bos2;
            boolean has_8x8 = PlayerFaces.this.storage.hasPlayerFaceImage(this.playername, FaceType.FACE_8X8);
            boolean has_16x16 = PlayerFaces.this.storage.hasPlayerFaceImage(this.playername, FaceType.FACE_16X16);
            boolean has_32x32 = PlayerFaces.this.storage.hasPlayerFaceImage(this.playername, FaceType.FACE_32X32);
            boolean has_body = PlayerFaces.this.storage.hasPlayerFaceImage(this.playername, FaceType.BODY_32X32);
            boolean missing_any = !has_8x8 || !has_16x16 || !has_32x32 || !has_body;
            boolean is_64x32_skin = false;
            BufferedImage img = null;
            try {
                if (PlayerFaces.this.fetchskins && (PlayerFaces.this.refreshskins || missing_any)) {
                    URL url = null;
                    if (this.mSkinUrlProvider == null) {
                        if (!PlayerFaces.this.skinurl.equals("")) {
                            url = new URL(PlayerFaces.this.skinurl.replace("%player%", URLEncoder.encode(this.playername, "UTF-8")).replace("%uuid%", this.playeruuid.toString()));
                        } else if (this.playerskinurl != null) {
                            url = new URL(this.playerskinurl);
                        }
                    } else {
                        url = this.mSkinUrlProvider.getSkinUrl(this.playername);
                    }
                    if (url != null) {
                        img = ImageIO.read(url);
                    }
                }
            }
            catch (IOException iox) {
                Debug.debug("Error loading skin for '" + this.playername + "' - " + iox);
            }
            if (img == null) {
                try {
                    InputStream in = this.getClass().getResourceAsStream("/char.png");
                    img = ImageIO.read(in);
                    in.close();
                }
                catch (IOException iox) {
                    Debug.debug("Error loading default skin for '" + this.playername + "' - " + iox);
                }
            }
            if (img == null) {
                return;
            }
            if (img.getWidth() < 64 || img.getHeight() < 32) {
                img.flush();
                return;
            }
            if (img.getWidth() / img.getHeight() == 2) {
                is_64x32_skin = true;
            }
            int scale = img.getWidth() / 8 / 8;
            BufferedImage faceOriginal = new BufferedImage(8 * scale, 8 * scale, 2);
            PlayerFaces.this.copyLayersToTarget(img, 8 * scale, 8 * scale, 40 * scale, 8 * scale, 8 * scale, 8 * scale, faceOriginal, 0, 8 * scale);
            int[] faceaccessory = new int[64];
            DynmapBufferedImage face8x8 = DynmapBufferedImage.allocateBufferedImage(8, 8);
            Image face8x8_image = faceOriginal.getScaledInstance(8, 8, 4);
            BufferedImage face8x8_buff = new BufferedImage(8, 8, 2);
            face8x8_buff.getGraphics().drawImage(face8x8_image, 0, 0, null);
            face8x8_buff.getRGB(0, 0, 8, 8, face8x8.argb_buf, 0, 8);
            if ((PlayerFaces.this.refreshskins || !has_8x8) && (bos2 = ImageIOManager.imageIOEncode(face8x8.buf_img, MapType.ImageFormat.FORMAT_PNG)) != null) {
                PlayerFaces.this.storage.setPlayerFaceImage(this.playername, FaceType.FACE_8X8, bos2);
            }
            if (PlayerFaces.this.refreshskins || !has_16x16) {
                DynmapBufferedImage face16x16 = DynmapBufferedImage.allocateBufferedImage(16, 16);
                Image face16x16_image = faceOriginal.getScaledInstance(16, 16, 4);
                BufferedImage face16x16_buff = new BufferedImage(16, 16, 2);
                face16x16_buff.getGraphics().drawImage(face16x16_image, 0, 0, null);
                face16x16_buff.getRGB(0, 0, 16, 16, face16x16.argb_buf, 0, 16);
                bos = ImageIOManager.imageIOEncode(face16x16.buf_img, MapType.ImageFormat.FORMAT_PNG);
                if (bos != null) {
                    PlayerFaces.this.storage.setPlayerFaceImage(this.playername, FaceType.FACE_16X16, bos);
                }
                DynmapBufferedImage.freeBufferedImage(face16x16);
                face16x16_buff.flush();
            }
            if (PlayerFaces.this.refreshskins || !has_32x32) {
                DynmapBufferedImage face32x32 = DynmapBufferedImage.allocateBufferedImage(32, 32);
                Image face32x32_image = faceOriginal.getScaledInstance(32, 32, 4);
                BufferedImage face32x32_buff = new BufferedImage(32, 32, 2);
                face32x32_buff.getGraphics().drawImage(face32x32_image, 0, 0, null);
                face32x32_buff.getRGB(0, 0, 32, 32, face32x32.argb_buf, 0, 32);
                bos = ImageIOManager.imageIOEncode(face32x32.buf_img, MapType.ImageFormat.FORMAT_PNG);
                if (bos != null) {
                    PlayerFaces.this.storage.setPlayerFaceImage(this.playername, FaceType.FACE_32X32, bos);
                }
                DynmapBufferedImage.freeBufferedImage(face32x32);
                face32x32_buff.flush();
            }
            if (PlayerFaces.this.refreshskins || !has_body) {
                Image skin_image = null;
                BufferedImage skin_buff = null;
                if (is_64x32_skin) {
                    skin_image = img.getScaledInstance(64, 32, 4);
                    skin_buff = new BufferedImage(64, 32, 2);
                    skin_buff.getGraphics().drawImage(skin_image, 0, 0, null);
                } else {
                    skin_image = img.getScaledInstance(64, 64, 4);
                    skin_buff = new BufferedImage(64, 64, 2);
                    skin_buff.getGraphics().drawImage(skin_image, 0, 0, null);
                }
                DynmapBufferedImage body32x32 = DynmapBufferedImage.allocateBufferedImage(32, 32);
                for (int i = 0; i < 8; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        body32x32.argb_buf[i * 32 + j + 12] = face8x8.argb_buf[i * 8 + j];
                    }
                }
                PlayerFaces.this.copyLayersToTarget(skin_buff, 20, 20, 20, 36, 8, 12, body32x32.argb_buf, 268, 32);
                PlayerFaces.this.copyLayersToTarget(skin_buff, 4, 20, 4, 36, 4, 12, body32x32.argb_buf, 652, 32);
                if (is_64x32_skin) {
                    skin_buff.getRGB(4, 20, 4, 12, body32x32.argb_buf, 656, 32);
                } else {
                    PlayerFaces.this.copyLayersToTarget(skin_buff, 20, 52, 4, 52, 4, 12, body32x32.argb_buf, 656, 32);
                }
                PlayerFaces.this.copyLayersToTarget(skin_buff, 44, 20, 44, 36, 4, 12, body32x32.argb_buf, 264, 32);
                if (is_64x32_skin) {
                    skin_buff.getRGB(44, 20, 4, 12, body32x32.argb_buf, 276, 32);
                } else {
                    PlayerFaces.this.copyLayersToTarget(skin_buff, 36, 52, 52, 52, 4, 12, body32x32.argb_buf, 276, 32);
                }
                BufferOutputStream bos3 = ImageIOManager.imageIOEncode(body32x32.buf_img, MapType.ImageFormat.FORMAT_PNG);
                if (bos3 != null) {
                    PlayerFaces.this.storage.setPlayerFaceImage(this.playername, FaceType.BODY_32X32, bos3);
                }
                DynmapBufferedImage.freeBufferedImage(body32x32);
                skin_buff.flush();
            }
            DynmapBufferedImage.freeBufferedImage(face8x8);
            face8x8_buff.flush();
            faceOriginal.flush();
            img.flush();
        }
    }

    public static enum FaceType {
        FACE_8X8("8x8", 0),
        FACE_16X16("16x16", 1),
        FACE_32X32("32x32", 2),
        BODY_32X32("body", 3);

        public final String id;
        public final int typeID;

        private FaceType(String id, int typeid) {
            this.id = id;
            this.typeID = typeid;
        }

        public static FaceType byID(String i_d) {
            for (FaceType ft : FaceType.values()) {
                if (!ft.id.equals(i_d)) continue;
                return ft;
            }
            return null;
        }

        public static FaceType byTypeID(int tid) {
            for (FaceType ft : FaceType.values()) {
                if (ft.typeID != tid) continue;
                return ft;
            }
            return null;
        }
    }
}

