/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search.suffixtree;

import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import mezz.jei.search.suffixtree.Edge;
import org.jetbrains.annotations.Nullable;

class Node {
    private final IntList data;
    private final Char2ObjectMap<Edge> edges = new Char2ObjectOpenHashMap();
    @Nullable
    private Node suffix = null;

    Node() {
        this.data = new IntArrayList(0);
    }

    void getData(IntSet ret) {
        ret.addAll((IntCollection)this.data);
        for (Edge e : this.edges.values()) {
            e.getDest().getData(ret);
        }
    }

    boolean addRef(int index) {
        if (this.contains(index)) {
            return false;
        }
        this.addIndex(index);
        Node iter = this.suffix;
        while (iter != null && !iter.contains(index)) {
            iter.addIndex(index);
            iter = iter.suffix;
        }
        return true;
    }

    private boolean contains(int index) {
        return this.data.contains(index);
    }

    void addEdge(char ch, Edge e) {
        this.edges.put(ch, (Object)e);
    }

    @Nullable
    Edge getEdge(char ch) {
        return (Edge)this.edges.get(ch);
    }

    @Nullable
    Node getSuffix() {
        return this.suffix;
    }

    void setSuffix(Node suffix) {
        this.suffix = suffix;
    }

    private void addIndex(int index) {
        this.data.add(index);
    }

    public String toString() {
        return "Node: size:" + this.data.size() + " Edges: " + this.edges;
    }
}

