/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.ingredients.TypedIngredient;
import mezz.jei.util.MathUtil;
import mezz.jei.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class IngredientInfoRecipe {
    private static final int lineSpacing = 2;
    private final List<FormattedText> description;
    private final List<ITypedIngredient<?>> ingredients;

    public static <T> List<IngredientInfoRecipe> create(IIngredientManager ingredientManager, List<T> ingredients, IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        List<ITypedIngredient<?>> typedIngredients = ingredients.stream().map(i -> TypedIngredient.create(ingredientManager, ingredientType, i)).flatMap(Optional::stream).toList();
        ArrayList<IngredientInfoRecipe> recipes = new ArrayList<IngredientInfoRecipe>();
        List<FormattedText> descriptionLines = StringUtil.expandNewlines(descriptionComponents);
        descriptionLines = StringUtil.splitLines(descriptionLines, 160);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.m_91087_();
        Objects.requireNonNull(minecraft.f_91062_);
        int maxLinesPerPage = 105 / (9 + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i2 = 0; i2 < pageCount; ++i2) {
            int startLine = i2 * maxLinesPerPage;
            int endLine = Math.min((i2 + 1) * maxLinesPerPage, lineCount);
            List<FormattedText> description = descriptionLines.subList(startLine, endLine);
            IngredientInfoRecipe recipe = new IngredientInfoRecipe(typedIngredients, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private IngredientInfoRecipe(List<ITypedIngredient<?>> ingredients, List<FormattedText> description) {
        this.description = description;
        this.ingredients = ingredients;
    }

    public List<FormattedText> getDescription() {
        return this.description;
    }

    public List<ITypedIngredient<?>> getIngredients() {
        return this.ingredients;
    }
}

