/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import java.util.Optional;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.LimitedAreaInputHandler;
import mezz.jei.recipes.FocusFactory;
import mezz.jei.util.Rectangle2dBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;

public class GuiAreaInputHandler
implements IUserInputHandler {
    private final FocusFactory focusFactory;
    private final GuiScreenHelper guiScreenHelper;
    private final RecipesGui recipesGui;

    public GuiAreaInputHandler(IIngredientManager ingredientManager, GuiScreenHelper guiScreenHelper, RecipesGui recipesGui) {
        this.focusFactory = new FocusFactory(ingredientManager);
        this.guiScreenHelper = guiScreenHelper;
        this.recipesGui = recipesGui;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input) {
        if (input.is(KeyBindings.leftClick) && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            double guiMouseX = input.getMouseX() - (double)guiContainer.getGuiLeft();
            double guiMouseY = input.getMouseY() - (double)guiContainer.getGuiTop();
            return this.guiScreenHelper.getGuiClickableArea(guiContainer, guiMouseX, guiMouseY).map(clickableArea -> {
                if (!input.isSimulate()) {
                    clickableArea.onClick(this.focusFactory, this.recipesGui);
                }
                Rect2i screenArea = new Rectangle2dBuilder(clickableArea.getArea()).addX(guiContainer.getGuiLeft()).addY(guiContainer.getGuiTop()).build();
                return LimitedAreaInputHandler.create(this, screenArea);
            });
        }
        return Optional.empty();
    }
}

