/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import java.util.Optional;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.LimitedAreaInputHandler;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.GiveAmount;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public class CheatInputHandler
implements IUserInputHandler {
    private final IRecipeFocusSource showsRecipeFocuses;
    private final IWorldConfig worldConfig;
    private final IClientConfig clientConfig;

    public CheatInputHandler(IRecipeFocusSource showsRecipeFocuses, IWorldConfig worldConfig, IClientConfig clientConfig) {
        this.showsRecipeFocuses = showsRecipeFocuses;
        this.worldConfig = worldConfig;
        this.clientConfig = clientConfig;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input) {
        if (!this.worldConfig.isCheatItemsEnabled() || screen instanceof RecipesGui) {
            return Optional.empty();
        }
        if (input.is(KeyBindings.cheatItemStack)) {
            return this.handleGive(input, GiveAmount.MAX);
        }
        if (input.is(KeyBindings.cheatOneItem)) {
            return this.handleGive(input, GiveAmount.ONE);
        }
        return Optional.empty();
    }

    private Optional<IUserInputHandler> handleGive(UserInput input, GiveAmount giveAmount) {
        return this.showsRecipeFocuses.getIngredientUnderMouse(input.getMouseX(), input.getMouseY()).map(clicked -> {
            ItemStack itemStack;
            if (!input.isSimulate() && !(itemStack = clicked.getCheatItemStack()).m_41619_()) {
                CommandUtil.giveStack(itemStack, giveAmount, this.clientConfig);
            }
            return LimitedAreaInputHandler.create(this, clicked.getArea());
        });
    }
}

