/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.ingredients.TypedIngredient;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;

public class GuiContainerWrapper
implements IRecipeFocusSource {
    private final IIngredientManager ingredientManager;
    private final GuiScreenHelper guiScreenHelper;

    public GuiContainerWrapper(IIngredientManager ingredientManager, GuiScreenHelper guiScreenHelper) {
        this.ingredientManager = ingredientManager;
        this.guiScreenHelper = guiScreenHelper;
    }

    @Override
    public Optional<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        Screen guiScreen = Minecraft.m_91087_().f_91080_;
        if (!(guiScreen instanceof AbstractContainerScreen)) {
            return Optional.empty();
        }
        AbstractContainerScreen guiContainer = (AbstractContainerScreen)guiScreen;
        return this.guiScreenHelper.getPluginsIngredientUnderMouse(guiContainer, mouseX, mouseY).or(() -> this.getSlotIngredientUnderMouse(guiContainer));
    }

    private Optional<IClickedIngredient<?>> getSlotIngredientUnderMouse(AbstractContainerScreen<?> guiContainer) {
        return Optional.ofNullable(guiContainer.getSlotUnderMouse()).flatMap(slot -> {
            ItemStack stack = slot.m_7993_();
            return TypedIngredient.createTyped(this.ingredientManager, VanillaTypes.ITEM, stack).map(typedIngredient -> {
                Rect2i slotArea = new Rect2i(slot.f_40220_, slot.f_40221_, 16, 16);
                return new ClickedIngredient(typedIngredient, slotArea, false, false);
            });
        });
    }
}

