/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import com.google.common.base.MoreObjects;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ClickedIngredient<V>
implements IClickedIngredient<V> {
    private final ITypedIngredient<V> value;
    @Nullable
    private final Rect2i area;
    private final boolean canOverrideVanillaClickHandler;
    private final boolean allowsCheating;

    public ClickedIngredient(ITypedIngredient<V> value, @Nullable Rect2i area, boolean allowsCheating, boolean canOverrideVanillaClickHandler) {
        ErrorUtil.checkNotNull(value, "value");
        this.value = value;
        this.area = area;
        this.allowsCheating = allowsCheating;
        this.canOverrideVanillaClickHandler = canOverrideVanillaClickHandler;
    }

    @Override
    public ITypedIngredient<V> getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Rect2i getArea() {
        return this.area;
    }

    @Override
    public ItemStack getCheatItemStack() {
        if (this.allowsCheating) {
            IngredientManager ingredientManager = Internal.getIngredientManager();
            IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(this.value.getType());
            return ingredientHelper.getCheatItemStack(this.value.getIngredient());
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean canOverrideVanillaClickHandler() {
        return this.canOverrideVanillaClickHandler;
    }

    public String toString() {
        IngredientManager ingredientManager = Internal.getIngredientManager();
        IIngredientHelper<V> ingredientHelper = ingredientManager.getIngredientHelper(this.value.getType());
        return MoreObjects.toStringHelper(ClickedIngredient.class).add("value", (Object)ingredientHelper.getUniqueId(this.value.getIngredient(), UidContext.Ingredient)).add("area", (Object)this.area).add("allowsCheating", this.allowsCheating).add("canOverrideVanillaClickHandler", this.canOverrideVanillaClickHandler).toString();
    }
}

