/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.Internal;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientInfo;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientListElementInfo;
import mezz.jei.ingredients.TypedIngredient;
import mezz.jei.util.ErrorUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientManager
implements IIngredientManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IModIdHelper modIdHelper;
    private final IngredientBlacklistInternal blacklist;
    private final ImmutableMap<IIngredientType<?>, IngredientInfo<?>> ingredientsMap;
    private final @Unmodifiable List<IIngredientType<?>> registeredIngredientTypes;
    private final boolean enableDebugLogs;
    private final ImmutableMap<Class<?>, IIngredientType<?>> ingredientTypeMap;

    public IngredientManager(IModIdHelper modIdHelper, IngredientBlacklistInternal blacklist, List<IngredientInfo<?>> ingredientInfos, boolean enableDebugLogs) {
        this.modIdHelper = modIdHelper;
        this.blacklist = blacklist;
        ImmutableMap.Builder ingredientsMapBuilder = ImmutableMap.builder();
        for (IngredientInfo<?> ingredientInfo : ingredientInfos) {
            IIngredientType ingredientType = ingredientInfo.getIngredientType();
            ingredientsMapBuilder.put(ingredientType, ingredientInfo);
        }
        this.ingredientsMap = ingredientsMapBuilder.build();
        this.registeredIngredientTypes = ingredientInfos.stream().map(IngredientInfo::getIngredientType).toList();
        this.enableDebugLogs = enableDebugLogs;
        ImmutableMap.Builder ingredientTypeBuilder = ImmutableMap.builder();
        for (IIngredientType ingredientType : this.ingredientsMap.keySet()) {
            ingredientTypeBuilder.put(ingredientType.getIngredientClass(), (Object)ingredientType);
        }
        this.ingredientTypeMap = ingredientTypeBuilder.build();
    }

    public <V> IngredientInfo<V> getIngredientInfo(IIngredientType<V> ingredientType) {
        IngredientInfo ingredientInfo = (IngredientInfo)this.ingredientsMap.get(ingredientType);
        if (ingredientInfo == null) {
            throw new IllegalArgumentException("Unknown ingredient type: " + ingredientType.getIngredientClass());
        }
        return ingredientInfo;
    }

    @Override
    public <V> Collection<V> getAllIngredients(IIngredientType<V> ingredientType) {
        IngredientInfo<V> ingredientInfo = this.getIngredientInfo(ingredientType);
        return ingredientInfo.getAllIngredients();
    }

    @Nullable
    public <V> V getIngredientByUid(IIngredientType<V> ingredientType, String uid) {
        IngredientInfo<V> ingredientInfo = this.getIngredientInfo(ingredientType);
        return ingredientInfo.getIngredientByUid(uid);
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientHelper(ingredientType);
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IngredientInfo<V> ingredientInfo = this.getIngredientInfo(ingredientType);
        return ingredientInfo.getIngredientHelper();
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientRenderer(ingredientType);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IngredientInfo<V> ingredientInfo = this.getIngredientInfo(ingredientType);
        return ingredientInfo.getIngredientRenderer();
    }

    @Override
    public Collection<IIngredientType<?>> getRegisteredIngredientTypes() {
        return this.registeredIngredientTypes;
    }

    @Override
    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        this.addIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IngredientInfo<V> ingredientInfo = this.getIngredientInfo(ingredientType);
        LOGGER.info("Ingredients are being added at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        ingredientInfo.addIngredients(ingredients);
        List<ITypedIngredient> typedIngredients = ingredients.stream().map(i -> TypedIngredient.createTyped(this, ingredientType, i)).map(Optional::orElseThrow).toList();
        IIngredientHelper ingredientHelper = ingredientInfo.getIngredientHelper();
        for (ITypedIngredient value : typedIngredients) {
            Optional<IIngredientListElementInfo<V>> matchingElementInfo = ingredientFilter.searchForMatchingElement(ingredientHelper, value);
            if (matchingElementInfo.isPresent()) {
                IIngredientListElement<V> matchingElement = matchingElementInfo.get().getElement();
                ITypedIngredient<V> typedIngredient = matchingElement.getTypedIngredient();
                this.blacklist.removeIngredientFromBlacklist(typedIngredient, ingredientHelper);
                ingredientFilter.updateHiddenState(matchingElement);
                if (!this.enableDebugLogs) continue;
                LOGGER.debug("Updated ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
                continue;
            }
            IIngredientListElement element = IngredientListElementFactory.createOrderedElement(this, value);
            IIngredientListElementInfo info = IngredientListElementInfo.create(element, this, this.modIdHelper);
            if (info == null) continue;
            this.blacklist.removeIngredientFromBlacklist(value, ingredientHelper);
            ingredientFilter.addIngredient(info);
            if (!this.enableDebugLogs) continue;
            LOGGER.debug("Added ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
        }
        ingredientFilter.invalidateCache();
    }

    @Override
    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        this.removeIngredientsAtRuntime(ingredientType, ingredients, Internal.getIngredientFilter());
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        Class<?> ingredientClass = ingredient.getClass();
        return this.getIngredientType(ingredientClass);
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientType ingredientType = (IIngredientType)this.ingredientTypeMap.get(ingredientClass);
        if (ingredientType != null) {
            return ingredientType;
        }
        for (IIngredientType<?> type : this.registeredIngredientTypes) {
            if (!type.getIngredientClass().isAssignableFrom(ingredientClass)) continue;
            IIngredientType<?> castType = type;
            return castType;
        }
        throw new IllegalArgumentException("Unknown ingredient class: " + ingredientClass);
    }

    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IngredientInfo<V> ingredientInfo = this.getIngredientInfo(ingredientType);
        LOGGER.info("Ingredients are being removed at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        ingredientInfo.removeIngredients(ingredients);
        IIngredientHelper ingredientHelper = this.getIngredientHelper(ingredientType);
        ingredients.stream().map(i -> TypedIngredient.createTyped(this, ingredientType, i)).flatMap(Optional::stream).forEach(typedIngredient -> {
            Optional matchingElementInfo = ingredientFilter.searchForMatchingElement(ingredientHelper, typedIngredient);
            if (matchingElementInfo.isEmpty()) {
                String errorInfo = ingredientHelper.getErrorInfo(typedIngredient.getIngredient());
                LOGGER.error("Could not find a matching ingredient to remove: {}", (Object)errorInfo);
            } else {
                if (this.enableDebugLogs) {
                    LOGGER.debug("Removed ingredient: {}", (Object)ingredientHelper.getErrorInfo(typedIngredient.getIngredient()));
                }
                IIngredientListElement matchingElement = matchingElementInfo.get().getElement();
                this.blacklist.addIngredientToBlacklist(matchingElement.getTypedIngredient(), ingredientHelper);
                matchingElement.setVisible(false);
            }
        });
        ingredientFilter.invalidateCache();
    }
}

