/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.configbuilder.ConfigBuilder;
import com.sonicether.soundphysics.configbuilder.ConfigEntry;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SoundPhysicsConfig {
    public final ConfigEntry<Boolean> enabled;
    public final ConfigEntry<Double> attenuationFactor;
    public final ConfigEntry<Double> reverbGain;
    public final ConfigEntry<Double> reverbBrightness;
    public final ConfigEntry<Double> blockAbsorption;
    public final ConfigEntry<Double> occlusionVariation;
    public final ConfigEntry<Double> defaultBlockReflectivity;
    public final ConfigEntry<Double> defaultBlockOcclusionFactor;
    public final ConfigEntry<Double> soundDistanceAllowance;
    public final ConfigEntry<Double> airAbsorption;
    public final ConfigEntry<Double> underwaterFilter;
    public final ConfigEntry<String> soundBlacklistRegex;
    public final ConfigEntry<Integer> environmentEvaluationRayCount;
    public final ConfigEntry<Integer> environmentEvaluationRayBounces;
    public final ConfigEntry<Double> nonFullBlockOcclusionFactor;
    public final ConfigEntry<Integer> maxOcclusionRays;
    public final ConfigEntry<Double> maxOcclusion;
    public final ConfigEntry<Boolean> strictOcclusion;
    public final ConfigEntry<Boolean> soundDirectionEvaluation;
    public final ConfigEntry<Boolean> redirectNonOccludedSounds;
    public final ConfigEntry<Boolean> debugLogging;
    public final ConfigEntry<Boolean> occlusionLogging;
    public final ConfigEntry<Boolean> environmentLogging;
    public final ConfigEntry<Boolean> performanceLogging;
    public final ConfigEntry<Boolean> renderSoundBounces;
    public final ConfigEntry<Boolean> renderOcclusion;
    public Pattern soundBlacklist;

    public SoundPhysicsConfig(ConfigBuilder builder) {
        this.enabled = builder.booleanEntry("enabled", true);
        this.attenuationFactor = builder.doubleEntry("attenuation_factor", 1.0, 0.1, 1.0);
        this.reverbGain = builder.doubleEntry("reverb_gain", 1.0, 0.1, 2.0);
        this.reverbBrightness = builder.doubleEntry("reverb_brightness", 1.0, 0.1, 2.0);
        this.blockAbsorption = builder.doubleEntry("block_absorption", 1.0, 0.1, 4.0);
        this.occlusionVariation = builder.doubleEntry("occlusion_variation", 0.35, 0.0, 16.0);
        this.defaultBlockReflectivity = builder.doubleEntry("default_block_reflectivity", 0.5, 0.1, 4.0);
        this.defaultBlockOcclusionFactor = builder.doubleEntry("default_block_occlusion_factor", 1.0, 0.0, 10.0);
        this.soundDistanceAllowance = builder.doubleEntry("sound_distance_allowance", 4.0, 1.0, 6.0);
        this.airAbsorption = builder.doubleEntry("air_absorption", 1.0, 0.0, 5.0);
        this.underwaterFilter = builder.doubleEntry("underwater_filter", 1.0, 0.0, 1.0);
        this.soundBlacklistRegex = builder.stringEntry("sound_blacklist_regex", ".*rain.*");
        this.environmentEvaluationRayCount = builder.integerEntry("environment_evaluation_ray_count", 32, 8, 64);
        this.environmentEvaluationRayBounces = builder.integerEntry("environment_evaluation_ray_bounces", 4, 2, 64);
        this.nonFullBlockOcclusionFactor = builder.doubleEntry("non_full_block_occlusion_factor", 0.25, 0.0, 1.0);
        this.maxOcclusionRays = builder.integerEntry("max_occlusion_rays", 16, 1, 128);
        this.maxOcclusion = builder.doubleEntry("max_occlusion", 64.0, 0.0, 1024.0);
        this.strictOcclusion = builder.booleanEntry("strict_occlusion", false);
        this.soundDirectionEvaluation = builder.booleanEntry("sound_direction_evaluation", true);
        this.redirectNonOccludedSounds = builder.booleanEntry("redirect_non_occluded_sounds", true);
        this.debugLogging = builder.booleanEntry("debug_logging", false);
        this.occlusionLogging = builder.booleanEntry("occlusion_logging", false);
        this.environmentLogging = builder.booleanEntry("environment_logging", false);
        this.performanceLogging = builder.booleanEntry("performance_logging", false);
        this.renderSoundBounces = builder.booleanEntry("render_sound_bounces", false);
        this.renderOcclusion = builder.booleanEntry("render_occlusion", false);
    }

    public void reload() {
        SoundPhysics.LOGGER.info("Reloading config");
        try {
            this.soundBlacklist = Pattern.compile(this.soundBlacklistRegex.get());
        }
        catch (PatternSyntaxException e) {
            SoundPhysics.LOGGER.warn("Failed to parse sound blacklist regex '{}'", (Object)this.soundBlacklistRegex.get());
            this.soundBlacklist = Pattern.compile(this.soundBlacklistRegex.getDefault());
        }
        SoundPhysics.LOGGER.info("Reloading reverb parameters");
        SoundPhysics.syncReverbParams();
    }
}

