/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite.fallout;

import appeng.worldgen.meteorite.MeteoriteBlockPutter;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Fallout {
    private final MeteoriteBlockPutter putter;
    private final BlockState skyStone;
    protected final Random random;

    public Fallout(MeteoriteBlockPutter putter, BlockState skyStone, Random random) {
        this.putter = putter;
        this.skyStone = skyStone;
        this.random = random;
    }

    public static FalloutMode fromBiome(Biome biome) {
        return switch (biome.m_47567_()) {
            case Biome.BiomeCategory.MESA -> FalloutMode.TERRACOTTA;
            case Biome.BiomeCategory.DESERT, Biome.BiomeCategory.BEACH -> FalloutMode.SAND;
            case Biome.BiomeCategory.ICY -> FalloutMode.ICE_SNOW;
            default -> FalloutMode.DEFAULT;
        };
    }

    public int adjustCrater() {
        return 0;
    }

    public void getRandomFall(LevelAccessor level, BlockPos pos) {
        float a = this.random.nextFloat();
        if (a > 0.9f) {
            this.putter.put(level, pos, Blocks.f_50069_.m_49966_());
        } else if (a > 0.8f) {
            this.putter.put(level, pos, Blocks.f_50652_.m_49966_());
        } else if (a > 0.7f) {
            this.putter.put(level, pos, Blocks.f_50493_.m_49966_());
        } else {
            this.putter.put(level, pos, Blocks.f_49994_.m_49966_());
        }
    }

    public void getRandomInset(LevelAccessor level, BlockPos pos) {
        float a = this.random.nextFloat();
        if (a > 0.9f) {
            this.putter.put(level, pos, Blocks.f_50652_.m_49966_());
        } else if (a > 0.8f) {
            this.putter.put(level, pos, Blocks.f_50069_.m_49966_());
        } else if (a > 0.7f) {
            this.putter.put(level, pos, Blocks.f_50440_.m_49966_());
        } else if (a > 0.6f) {
            this.putter.put(level, pos, this.skyStone);
        } else if (a > 0.5f) {
            this.putter.put(level, pos, Blocks.f_49994_.m_49966_());
        } else {
            this.putter.put(level, pos, Blocks.f_50016_.m_49966_());
        }
    }
}

