/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.services.compass;

import appeng.core.AELog;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;

final class CompassRegion
extends SavedData {
    private static final int CHUNKS_PER_REGION = 1024;
    private static final int BITMAP_LENGTH = 0x100000;
    private final Map<Integer, BitSet> sections = new HashMap<Integer, BitSet>();

    CompassRegion() {
    }

    private static String getRegionSaveName(int regionX, int regionZ) {
        return "ae2_compass_" + regionX + "_" + regionZ;
    }

    public static CompassRegion get(ServerLevel level, ChunkPos chunkPos) {
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(chunkPos, "chunkPos");
        int regionX = chunkPos.f_45578_ / 1024;
        int regionZ = chunkPos.f_45579_ / 1024;
        return (CompassRegion)level.m_8895_().m_164861_(CompassRegion::load, CompassRegion::new, CompassRegion.getRegionSaveName(regionX, regionZ));
    }

    public static CompassRegion load(CompoundTag nbt) {
        CompassRegion result = new CompassRegion();
        for (String key : nbt.m_128431_()) {
            if (key.startsWith("section")) {
                try {
                    int sectionIndex = Integer.parseInt(key.substring("section".length()));
                    result.sections.put(sectionIndex, BitSet.valueOf(nbt.m_128463_(key)));
                }
                catch (NumberFormatException e) {
                    AELog.warn("Compass region contains invalid NBT tag %s", key);
                }
                continue;
            }
            AELog.warn("Compass region contains unknown NBT tag %s", key);
        }
        return result;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        for (Map.Entry<Integer, BitSet> entry : this.sections.entrySet()) {
            String key = "section" + entry.getKey();
            if (entry.getValue().isEmpty()) continue;
            compound.m_128382_(key, entry.getValue().toByteArray());
        }
        return compound;
    }

    boolean hasSkyStone(int cx, int cz) {
        int bitmapIndex = CompassRegion.getBitmapIndex(cx, cz);
        for (BitSet bitmap : this.sections.values()) {
            if (!bitmap.get(bitmapIndex)) continue;
            return true;
        }
        return false;
    }

    boolean hasSkyStone(int cx, int cz, int sectionIndex) {
        int bitmapIndex = CompassRegion.getBitmapIndex(cx, cz);
        BitSet section = this.sections.get(sectionIndex);
        if (section != null) {
            return section.get(bitmapIndex);
        }
        return false;
    }

    void setHasSkyStone(int cx, int cz, int sectionIndex, boolean hasSkyStone) {
        int bitmapIndex = CompassRegion.getBitmapIndex(cx, cz);
        BitSet section = this.sections.get(sectionIndex);
        if (section == null) {
            if (hasSkyStone) {
                section = new BitSet(0x100000);
                section.set(bitmapIndex);
                this.sections.put(sectionIndex, section);
                this.m_77762_();
            }
        } else {
            if (section.get(bitmapIndex) != hasSkyStone) {
                this.m_77762_();
            }
            if (!hasSkyStone) {
                section.clear(bitmapIndex);
                if (section.isEmpty()) {
                    this.sections.remove(sectionIndex);
                }
                this.m_77762_();
            } else {
                section.set(bitmapIndex);
            }
        }
    }

    private static int getBitmapIndex(int cx, int cz) {
        return (cx &= 0x3FF) + (cz &= 0x3FF) * 1024;
    }
}

