/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.parts.IPartItem;
import appeng.parts.p2p.P2PTunnelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class CapabilityP2PTunnelPart<P extends CapabilityP2PTunnelPart<P, C>, C>
extends P2PTunnelPart<P> {
    private final Capability<C> capability;
    private boolean inBlockUpdate = false;
    private int accessDepth = 0;
    private final CapabilityGuard capabilityGuard = new CapabilityGuard();
    private final EmptyCapabilityGuard emptyCapabilityGuard = new EmptyCapabilityGuard();
    protected C inputHandler;
    protected C outputHandler;
    protected C emptyHandler;

    public CapabilityP2PTunnelPart(IPartItem<?> partItem, Capability<C> capability) {
        super(partItem);
        this.capability = capability;
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public final <T> LazyOptional<T> getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == this.capability) {
            if (this.isOutput()) {
                return LazyOptional.of(() -> this.outputHandler).cast();
            }
            return LazyOptional.of(() -> this.inputHandler).cast();
        }
        return LazyOptional.empty();
    }

    protected final CapabilityGuard getAdjacentCapability() {
        ++this.accessDepth;
        return this.capabilityGuard;
    }

    protected final CapabilityGuard getInputCapability() {
        CapabilityP2PTunnelPart input = (CapabilityP2PTunnelPart)this.getInput();
        return input == null ? this.emptyCapabilityGuard : input.getAdjacentCapability();
    }

    private BlockPos getFacingPos() {
        return this.getHost().getLocation().getPos().m_142300_(this.getSide());
    }

    protected void sendBlockUpdate() {
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                BlockEntity self = this.getBlockEntity();
                self.m_58904_().m_46672_(self.m_58899_(), Blocks.f_50016_);
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        this.sendBlockUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (!this.getFacingPos().equals((Object)neighbor)) {
            return;
        }
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                if (this.isOutput()) {
                    CapabilityP2PTunnelPart input = (CapabilityP2PTunnelPart)this.getInput();
                    if (input != null) {
                        input.sendBlockUpdate();
                    }
                } else {
                    for (CapabilityP2PTunnelPart output : this.getOutputs()) {
                        output.sendBlockUpdate();
                    }
                }
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    protected class CapabilityGuard
    implements AutoCloseable {
        protected CapabilityGuard() {
        }

        protected C get() {
            if (CapabilityP2PTunnelPart.this.accessDepth == 0) {
                throw new IllegalStateException("get was called after closing the wrapper");
            }
            if (CapabilityP2PTunnelPart.this.accessDepth == 1) {
                BlockEntity self;
                BlockEntity te;
                if (CapabilityP2PTunnelPart.this.isActive() && (te = (self = CapabilityP2PTunnelPart.this.getBlockEntity()).m_58904_().m_7702_(CapabilityP2PTunnelPart.this.getFacingPos())) != null) {
                    return te.getCapability(CapabilityP2PTunnelPart.this.capability, CapabilityP2PTunnelPart.this.getSide().m_122424_()).orElse(CapabilityP2PTunnelPart.this.emptyHandler);
                }
                return CapabilityP2PTunnelPart.this.emptyHandler;
            }
            return CapabilityP2PTunnelPart.this.emptyHandler;
        }

        @Override
        public void close() {
            if (--CapabilityP2PTunnelPart.this.accessDepth < 0) {
                throw new IllegalStateException("Close has been called multiple times");
            }
        }
    }

    protected class EmptyCapabilityGuard
    extends CapabilityGuard
    implements AutoCloseable {
        protected EmptyCapabilityGuard() {
        }

        @Override
        public void close() {
        }

        @Override
        protected C get() {
            return CapabilityP2PTunnelPart.this.emptyHandler;
        }
    }
}

