/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.encoding;

import appeng.api.config.SecurityPermissions;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.IAEPatternDetails;
import appeng.helpers.IPatternTerminalHost;
import appeng.items.parts.PartModels;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.parts.PartModel;
import appeng.parts.encoding.EncodingMode;
import appeng.parts.reporting.AbstractTerminalPart;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class PatternEncodingTerminalPart
extends AbstractTerminalPart
implements IPatternTerminalHost {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("ae2", "part/pattern_encoding_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("ae2", "part/pattern_encoding_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    private final AppEngInternalInventory crafting = new AppEngInternalInventory(this, 9);
    private final AppEngInternalInventory output = new AppEngInternalInventory(this, 3);
    private final AppEngInternalInventory pattern = new AppEngInternalInventory(this, 2);
    private EncodingMode mode = EncodingMode.CRAFTING;
    private boolean substitute = false;
    private boolean substituteFluids = true;

    public PatternEncodingTerminalPart(IPartItem<?> partItem) {
        super(partItem);
    }

    @Override
    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack is : this.pattern) {
            if (is.m_41619_()) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        try {
            this.mode = EncodingMode.valueOf(data.m_128461_("mode"));
        }
        catch (IllegalArgumentException ignored) {
            this.mode = EncodingMode.CRAFTING;
        }
        this.setSubstitution(data.m_128471_("substitute"));
        this.setFluidSubstitution(data.m_128471_("substituteFluids"));
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "craftingGrid");
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128359_("mode", this.mode.name());
        data.m_128379_("substitute", this.substitute);
        data.m_128379_("substituteFluids", this.substituteFluids);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "craftingGrid");
    }

    @Override
    public MenuType<?> getMenuType(Player p) {
        if (Platform.checkPermissions(p, this, SecurityPermissions.CRAFT, false, false)) {
            return PatternEncodingTermMenu.TYPE;
        }
        return MEStorageMenu.TYPE;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.pattern && slot == 1) {
            ItemStack is = this.pattern.getStackInSlot(1);
            IPatternDetails details = PatternDetailsHelper.decodePattern(is, this.getHost().getBlockEntity().m_58904_());
            if (details instanceof AECraftingPattern) {
                this.setMode(EncodingMode.CRAFTING);
            } else if (details instanceof AEProcessingPattern) {
                this.setMode(EncodingMode.PROCESSING);
            }
            if (details instanceof IAEPatternDetails) {
                int x;
                IAEPatternDetails aeDetails = (IAEPatternDetails)details;
                this.setSubstitution(aeDetails.canSubstitute());
                this.setFluidSubstitution(aeDetails.canSubstituteFluids());
                for (x = 0; x < this.crafting.size() && x < aeDetails.getSparseInputs().length; ++x) {
                    this.crafting.setItemDirect(x, GenericStack.wrapInItemStack(aeDetails.getSparseInputs()[x]));
                }
                for (x = 0; x < this.output.size() && x < aeDetails.getSparseOutputs().length; ++x) {
                    this.output.setItemDirect(x, GenericStack.wrapInItemStack(aeDetails.getSparseOutputs()[x]));
                }
            }
        } else if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
        this.getHost().markForSave();
    }

    @Override
    public EncodingMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(EncodingMode mode) {
        this.mode = mode;
        this.fixCraftingRecipes();
    }

    @Override
    public boolean isSubstitution() {
        return this.substitute;
    }

    @Override
    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    @Override
    public boolean isFluidSubstitution() {
        return this.substituteFluids;
    }

    @Override
    public void setFluidSubstitution(boolean canSubstitute) {
        this.substituteFluids = canSubstitute;
    }

    @Override
    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)INV_CRAFTING)) {
            return this.crafting;
        }
        if (id.equals((Object)INV_OUTPUT)) {
            return this.output;
        }
        if (id.equals((Object)PATTERNS)) {
            return this.pattern;
        }
        return super.getSubInventory(id);
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }
}

