/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.stacks.AEKeyType;
import appeng.api.storage.AEKeyFilter;
import appeng.parts.automation.ExternalStorageStrategy;
import appeng.parts.automation.FluidPickupStrategy;
import appeng.parts.automation.FluidPlacementStrategy;
import appeng.parts.automation.ForgeExternalStorageStrategy;
import appeng.parts.automation.ItemPickupStrategy;
import appeng.parts.automation.ItemPlacementStrategy;
import appeng.parts.automation.PickupStrategy;
import appeng.parts.automation.PlacementStrategy;
import appeng.parts.automation.PlacementStrategyFacade;
import appeng.parts.automation.StackExportFacade;
import appeng.parts.automation.StackExportStrategy;
import appeng.parts.automation.StackImportFacade;
import appeng.parts.automation.StackImportStrategy;
import appeng.parts.automation.StorageExportStrategy;
import appeng.parts.automation.StorageImportStrategy;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class StackWorldBehaviors {
    private static final Map<AEKeyType, ImportStrategyFactory> importStrategies = new IdentityHashMap<AEKeyType, ImportStrategyFactory>();
    private static final Map<AEKeyType, ExportStrategyFactory> exportStrategies = new IdentityHashMap<AEKeyType, ExportStrategyFactory>();
    private static final Map<AEKeyType, ExternalStorageStrategyFactory> externalStorageStrategies = new IdentityHashMap<AEKeyType, ExternalStorageStrategyFactory>();
    private static final Map<AEKeyType, PlacementStrategyFactory> placementStrategies = new IdentityHashMap<AEKeyType, PlacementStrategyFactory>();
    private static final Map<AEKeyType, PickupStrategyFactory> pickupStrategies = new IdentityHashMap<AEKeyType, PickupStrategyFactory>();

    private StackWorldBehaviors() {
    }

    public static AEKeyFilter hasImportStrategyFilter() {
        return what -> importStrategies.containsKey((Object)what.getType());
    }

    public static AEKeyFilter hasExportStrategyFilter() {
        return what -> exportStrategies.containsKey((Object)what.getType());
    }

    public static AEKeyFilter hasPlacementStrategy() {
        return what -> placementStrategies.containsKey((Object)what.getType());
    }

    public static StackImportStrategy createImportFacade(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        ArrayList<StackImportStrategy> strategies = new ArrayList<StackImportStrategy>(importStrategies.size());
        for (ImportStrategyFactory supplier : importStrategies.values()) {
            strategies.add(supplier.create(level, fromPos, fromSide));
        }
        return new StackImportFacade(strategies);
    }

    public static StackExportStrategy createExportFacade(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        ArrayList<StackExportStrategy> strategies = new ArrayList<StackExportStrategy>(exportStrategies.size());
        for (ExportStrategyFactory supplier : exportStrategies.values()) {
            strategies.add(supplier.create(level, fromPos, fromSide));
        }
        return new StackExportFacade(strategies);
    }

    public static Map<AEKeyType, ExternalStorageStrategy> createExternalStorageStrategies(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        IdentityHashMap<AEKeyType, ExternalStorageStrategy> strategies = new IdentityHashMap<AEKeyType, ExternalStorageStrategy>(externalStorageStrategies.size());
        for (Map.Entry<AEKeyType, ExternalStorageStrategyFactory> entry : externalStorageStrategies.entrySet()) {
            strategies.put(entry.getKey(), entry.getValue().create(level, fromPos, fromSide));
        }
        return strategies;
    }

    public static PlacementStrategy createPlacementStrategies(ServerLevel level, BlockPos fromPos, Direction fromSide, BlockEntity host) {
        IdentityHashMap<AEKeyType, PlacementStrategy> strategies = new IdentityHashMap<AEKeyType, PlacementStrategy>(placementStrategies.size());
        for (Map.Entry<AEKeyType, PlacementStrategyFactory> entry : placementStrategies.entrySet()) {
            strategies.put(entry.getKey(), entry.getValue().create(level, fromPos, fromSide, host));
        }
        return new PlacementStrategyFacade(strategies);
    }

    public static List<PickupStrategy> createPickupStrategies(ServerLevel level, BlockPos fromPos, Direction fromSide, BlockEntity host, boolean allowSilkTouch) {
        return pickupStrategies.values().stream().map(f -> f.create(level, fromPos, fromSide, host, allowSilkTouch)).toList();
    }

    static {
        importStrategies.put(AEKeyType.items(), StorageImportStrategy::createItem);
        importStrategies.put(AEKeyType.fluids(), StorageImportStrategy::createFluid);
        exportStrategies.put(AEKeyType.items(), StorageExportStrategy::createItem);
        exportStrategies.put(AEKeyType.fluids(), StorageExportStrategy::createFluid);
        externalStorageStrategies.put(AEKeyType.items(), ForgeExternalStorageStrategy::createItem);
        externalStorageStrategies.put(AEKeyType.fluids(), ForgeExternalStorageStrategy::createFluid);
        placementStrategies.put(AEKeyType.fluids(), FluidPlacementStrategy::new);
        placementStrategies.put(AEKeyType.items(), ItemPlacementStrategy::new);
        pickupStrategies.put(AEKeyType.fluids(), FluidPickupStrategy::new);
        pickupStrategies.put(AEKeyType.items(), ItemPickupStrategy::new);
    }

    @FunctionalInterface
    static interface ImportStrategyFactory {
        public StackImportStrategy create(ServerLevel var1, BlockPos var2, Direction var3);
    }

    @FunctionalInterface
    static interface ExportStrategyFactory {
        public StackExportStrategy create(ServerLevel var1, BlockPos var2, Direction var3);
    }

    @FunctionalInterface
    static interface ExternalStorageStrategyFactory {
        public ExternalStorageStrategy create(ServerLevel var1, BlockPos var2, Direction var3);
    }

    @FunctionalInterface
    static interface PlacementStrategyFactory {
        public PlacementStrategy create(ServerLevel var1, BlockPos var2, Direction var3, BlockEntity var4);
    }

    @FunctionalInterface
    static interface PickupStrategyFactory {
        public PickupStrategy create(ServerLevel var1, BlockPos var2, Direction var3, BlockEntity var4, boolean var5);
    }
}

