/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.core.AEConfig;
import appeng.parts.automation.PlacementStrategy;
import appeng.util.Platform;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ItemPlacementStrategy
implements PlacementStrategy {
    private static final Random RANDOM_OFFSET = new Random();
    private final ServerLevel level;
    private final BlockPos pos;
    private final Direction side;
    private final BlockEntity host;
    private boolean blocked = false;

    public ItemPlacementStrategy(ServerLevel level, BlockPos pos, Direction side, BlockEntity host) {
        this.level = level;
        this.pos = pos;
        this.side = side;
        this.host = host;
    }

    @Override
    public void clearBlocked() {
        this.blocked = !this.level.m_8055_(this.pos).m_60767_().m_76336_();
    }

    @Override
    public final long placeInWorld(AEKey what, long amount, Actionable type, boolean placeAsEntity) {
        AEItemKey itemKey;
        block15: {
            block14: {
                if (this.blocked || !(what instanceof AEItemKey)) break block14;
                itemKey = (AEItemKey)what;
                if (amount > 0L) break block15;
            }
            return 0L;
        }
        Item i = itemKey.getItem();
        int maxStorage = (int)Math.min(amount, (long)i.m_41459_());
        ItemStack is = itemKey.toStack(maxStorage);
        boolean worked = false;
        Direction side = this.side.m_122424_();
        BlockPos placePos = this.pos;
        if (this.level.m_8055_(placePos).m_60767_().m_76336_()) {
            if (placeAsEntity) {
                int sum = this.countEntitesAround((Level)this.level, placePos);
                if (sum < AEConfig.instance().getFormationPlaneEntityLimit()) {
                    worked = true;
                    if (type == Actionable.MODULATE) {
                        is.m_41764_(maxStorage);
                        if (!ItemPlacementStrategy.spawnItemEntity((Level)this.level, this.host, side, is)) {
                            worked = false;
                        }
                    }
                }
            } else {
                Player player = Platform.getPlayer(this.level);
                Platform.configurePlayer(player, side, this.host);
                maxStorage = is.m_41613_();
                worked = true;
                if (type == Actionable.MODULATE) {
                    Direction lookDirection = side;
                    PlaneDirectionalPlaceContext context = new PlaneDirectionalPlaceContext((Level)this.level, player, placePos, lookDirection, is, lookDirection.m_122424_());
                    i.m_6225_((UseOnContext)context);
                    maxStorage -= is.m_41613_();
                } else {
                    maxStorage = 1;
                }
            }
        }
        boolean bl = this.blocked = !this.level.m_8055_(placePos).m_60767_().m_76336_();
        if (worked) {
            return maxStorage;
        }
        return 0L;
    }

    private static boolean spawnItemEntity(Level level, BlockEntity te, Direction side, ItemStack is) {
        Entity result;
        double centerX = (double)te.m_58899_().m_123341_() + 0.5;
        double centerY = te.m_58899_().m_123342_();
        double centerZ = (double)te.m_58899_().m_123343_() + 0.5;
        ItemEntity entity = new ItemEntity(level, centerX, centerY, centerZ, is.m_41777_());
        if (is.m_41720_().hasCustomEntity(is) && (result = is.m_41720_().createEntity(level, (Entity)entity, is)) != null) {
            entity.m_146870_();
            entity = result;
        }
        double additionalYOffset = side.m_122430_() == -1 ? (double)(1.0f - entity.m_20206_()) : 0.0;
        double spawnAreaHeight = Math.max(0.0f, 1.0f - entity.m_20206_());
        double spawnAreaWidth = Math.max(0.0f, 1.0f - entity.m_20205_());
        double offsetX = side.m_122429_() == 0 ? (double)RANDOM_OFFSET.nextFloat() * spawnAreaWidth - spawnAreaWidth / 2.0 : (double)side.m_122429_() * (0.525 + (double)(entity.m_20205_() / 2.0f));
        double offsetY = side.m_122430_() == 0 ? (double)RANDOM_OFFSET.nextFloat() * spawnAreaHeight : (double)side.m_122430_() + additionalYOffset;
        double offsetZ = side.m_122431_() == 0 ? (double)RANDOM_OFFSET.nextFloat() * spawnAreaWidth - spawnAreaWidth / 2.0 : (double)side.m_122431_() * (0.525 + (double)(entity.m_20205_() / 2.0f));
        double absoluteX = centerX + offsetX;
        double absoluteY = centerY + offsetY;
        double absoluteZ = centerZ + offsetZ;
        entity.m_6034_(absoluteX, absoluteY, absoluteZ);
        entity.m_20334_((double)side.m_122429_() * 0.1, (double)side.m_122430_() * 0.1, (double)side.m_122431_() * 0.1);
        if (!level.m_7967_((Entity)entity)) {
            entity.m_146870_();
            return false;
        }
        return true;
    }

    private int countEntitesAround(Level level, BlockPos pos) {
        AABB t = new AABB(pos).m_82400_(8.0);
        List list = level.m_45976_(Entity.class, t);
        return list.size();
    }

    private static class PlaneDirectionalPlaceContext
    extends BlockPlaceContext {
        private final Direction lookDirection;

        public PlaneDirectionalPlaceContext(Level level, Player player, BlockPos pos, Direction lookDirection, ItemStack itemStack, Direction facing) {
            super(level, player, InteractionHand.MAIN_HAND, itemStack, new BlockHitResult(Vec3.m_82539_((Vec3i)pos), facing, pos, false));
            this.lookDirection = lookDirection;
        }

        public BlockPos m_8083_() {
            return this.m_43718_().m_82425_();
        }

        public boolean m_7059_() {
            return this.m_43725_().m_8055_(this.m_8083_()).m_60629_((BlockPlaceContext)this);
        }

        public Direction m_7820_() {
            return Direction.DOWN;
        }

        public Direction[] m_6232_() {
            Direction[] directionArray;
            switch (this.lookDirection) {
                default: {
                    Direction[] directionArray2 = new Direction[6];
                    directionArray2[0] = Direction.DOWN;
                    directionArray2[1] = Direction.NORTH;
                    directionArray2[2] = Direction.EAST;
                    directionArray2[3] = Direction.SOUTH;
                    directionArray2[4] = Direction.WEST;
                    directionArray = directionArray2;
                    directionArray2[5] = Direction.UP;
                    break;
                }
                case UP: {
                    Direction[] directionArray3 = new Direction[6];
                    directionArray3[0] = Direction.DOWN;
                    directionArray3[1] = Direction.UP;
                    directionArray3[2] = Direction.NORTH;
                    directionArray3[3] = Direction.EAST;
                    directionArray3[4] = Direction.SOUTH;
                    directionArray = directionArray3;
                    directionArray3[5] = Direction.WEST;
                    break;
                }
                case NORTH: {
                    Direction[] directionArray4 = new Direction[6];
                    directionArray4[0] = Direction.DOWN;
                    directionArray4[1] = Direction.NORTH;
                    directionArray4[2] = Direction.EAST;
                    directionArray4[3] = Direction.WEST;
                    directionArray4[4] = Direction.UP;
                    directionArray = directionArray4;
                    directionArray4[5] = Direction.SOUTH;
                    break;
                }
                case SOUTH: {
                    Direction[] directionArray5 = new Direction[6];
                    directionArray5[0] = Direction.DOWN;
                    directionArray5[1] = Direction.SOUTH;
                    directionArray5[2] = Direction.EAST;
                    directionArray5[3] = Direction.WEST;
                    directionArray5[4] = Direction.UP;
                    directionArray = directionArray5;
                    directionArray5[5] = Direction.NORTH;
                    break;
                }
                case WEST: {
                    Direction[] directionArray6 = new Direction[6];
                    directionArray6[0] = Direction.DOWN;
                    directionArray6[1] = Direction.WEST;
                    directionArray6[2] = Direction.SOUTH;
                    directionArray6[3] = Direction.UP;
                    directionArray6[4] = Direction.NORTH;
                    directionArray = directionArray6;
                    directionArray6[5] = Direction.EAST;
                    break;
                }
                case EAST: {
                    Direction[] directionArray7 = new Direction[6];
                    directionArray7[0] = Direction.DOWN;
                    directionArray7[1] = Direction.EAST;
                    directionArray7[2] = Direction.SOUTH;
                    directionArray7[3] = Direction.UP;
                    directionArray7[4] = Direction.NORTH;
                    directionArray = directionArray7;
                    directionArray7[5] = Direction.WEST;
                }
            }
            return directionArray;
        }

        public Direction m_8125_() {
            return this.lookDirection.m_122434_() == Direction.Axis.Y ? Direction.NORTH : this.lookDirection;
        }

        public boolean m_7078_() {
            return false;
        }

        public float m_7074_() {
            return this.lookDirection.m_122416_() * 90;
        }
    }
}

