/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.stacks.AEItemKey;
import appeng.core.AppEng;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.core.sync.packets.ItemTransitionEffectPacket;
import appeng.parts.automation.PickupSink;
import appeng.parts.automation.PickupStrategy;
import appeng.util.Platform;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;

public class ItemPickupStrategy
implements PickupStrategy {
    private static final float SILK_TOUCH_FACTOR = 16.0f;
    public static final ResourceLocation TAG_BLACKLIST = new ResourceLocation("ae2", "blacklisted/annihilation_plane");
    private static final Tag<Block> BLOCK_BLACKLIST = BlockTags.createOptional((ResourceLocation)TAG_BLACKLIST);
    private static final Tag<Item> ITEM_BLACKLIST = ItemTags.createOptional((ResourceLocation)TAG_BLACKLIST);
    private final ServerLevel level;
    private final BlockPos pos;
    private final Direction side;
    private final BlockEntity host;
    private final boolean allowSilkTouch;
    private boolean isAccepting = true;

    public ItemPickupStrategy(ServerLevel level, BlockPos pos, Direction side, BlockEntity host, boolean allowSilkTouch) {
        this.level = level;
        this.pos = pos;
        this.side = side;
        this.host = host;
        this.allowSilkTouch = allowSilkTouch;
    }

    @Override
    public void reset() {
        this.isAccepting = true;
    }

    @Override
    public boolean canPickUpEntity(Entity entity) {
        return entity instanceof ItemEntity;
    }

    @Override
    public boolean pickUpEntity(IEnergySource energySource, PickupSink sink, Entity entity) {
        if (!this.isAccepting || !(entity instanceof ItemEntity)) {
            return false;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (ItemPickupStrategy.isItemBlacklisted(itemEntity.m_32055_().m_41720_())) {
            return false;
        }
        boolean changed = this.storeEntityItem(sink, itemEntity);
        if (changed) {
            AppEng.instance().sendToAllNearExcept(null, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), 64.0, (Level)this.level, new ItemTransitionEffectPacket(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.side));
        }
        return true;
    }

    @Override
    public PickupStrategy.Result tryStartPickup(IEnergySource energySource, PickupSink sink) {
        BlockState blockState;
        if (this.isAccepting && this.canHandleBlock(this.level, this.pos, blockState = this.level.m_8055_(this.pos))) {
            List<ItemStack> items = this.obtainBlockDrops(this.level, this.pos);
            float requiredPower = this.calculateEnergyUsage(this.level, this.pos, items);
            boolean hasPower = energySource.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) > (double)requiredPower - 0.1;
            boolean canStore = this.canStoreItemStacks(sink, items);
            if (hasPower && canStore) {
                return PickupStrategy.Result.PICKED_UP;
            }
            return PickupStrategy.Result.CANT_STORE;
        }
        return PickupStrategy.Result.CANT_PICKUP;
    }

    @Override
    public void completePickup(IEnergySource energySource, PickupSink sink) {
        BlockState blockState = this.level.m_8055_(this.pos);
        if (!this.canHandleBlock(this.level, this.pos, blockState)) {
            return;
        }
        List<ItemStack> items = this.obtainBlockDrops(this.level, this.pos);
        float requiredPower = this.calculateEnergyUsage(this.level, this.pos, items);
        if (!this.breakBlockAndStoreExtraItems(sink, this.level, this.pos)) {
            return;
        }
        for (ItemStack item : items) {
            int inserted = this.storeItemStack(sink, item);
            if (inserted >= item.m_41613_()) continue;
            item.m_41774_(inserted);
            Platform.spawnDrops((Level)this.level, this.pos, Collections.singletonList(item));
        }
        energySource.extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
        AppEng.instance().sendToAllNearExcept(null, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), 64.0, (Level)this.level, new BlockTransitionEffectPacket(this.pos, blockState, this.side, BlockTransitionEffectPacket.SoundMode.NONE));
    }

    private boolean storeEntityItem(PickupSink sink, ItemEntity entityItem) {
        if (entityItem.m_6084_()) {
            int inserted = this.storeItemStack(sink, entityItem.m_32055_());
            return this.handleOverflow(entityItem, inserted);
        }
        return false;
    }

    private int storeItemStack(PickupSink sink, ItemStack item) {
        int amount;
        if (item.m_41619_()) {
            return 0;
        }
        AEItemKey what = AEItemKey.of(item);
        int inserted = (int)sink.insert(what, amount = item.m_41613_(), Actionable.MODULATE);
        this.isAccepting = inserted >= amount;
        return inserted;
    }

    private boolean handleOverflow(ItemEntity entityItem, int inserted) {
        int entityItemCount = entityItem.m_32055_().m_41613_();
        if (inserted >= entityItemCount) {
            entityItem.m_146870_();
            return true;
        }
        int newStackSize = entityItemCount - inserted;
        boolean changed = entityItemCount != newStackSize;
        entityItem.m_32055_().m_41764_(newStackSize);
        return changed;
    }

    private boolean canHandleBlock(ServerLevel level, BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        if (ItemPickupStrategy.isBlockBlacklisted(state.m_60734_())) {
            return false;
        }
        Material material = state.m_60767_();
        float hardness = state.m_60800_((BlockGetter)level, pos);
        boolean ignoreAirAndFluids = material == Material.f_76296_ || material.m_76332_();
        return !ignoreAirAndFluids && hardness >= 0.0f && level.m_46805_(pos) && level.m_7966_(Platform.getPlayer(level), pos);
    }

    protected List<ItemStack> obtainBlockDrops(ServerLevel level, BlockPos pos) {
        Player fakePlayer = Platform.getPlayer(level);
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        HarvestTool harvestTool = this.createHarvestTool(state);
        ItemStack harvestToolItem = harvestTool.item();
        if (!state.m_60834_() && harvestTool.fallback()) {
            harvestToolItem = ItemStack.f_41583_;
        }
        return Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)fakePlayer, (ItemStack)harvestToolItem);
    }

    protected float calculateEnergyUsage(ServerLevel level, BlockPos pos, List<ItemStack> items) {
        BlockState state = level.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)level, pos);
        float requiredEnergy = 1.0f + hardness;
        for (ItemStack is : items) {
            requiredEnergy += (float)is.m_41613_();
        }
        if (this.allowSilkTouch) {
            requiredEnergy *= 16.0f;
        }
        return requiredEnergy;
    }

    private boolean canStoreItemStacks(PickupSink sink, List<ItemStack> itemStacks) {
        boolean canStore = itemStacks.isEmpty();
        for (ItemStack itemStack : itemStacks) {
            AEItemKey itemToTest = AEItemKey.of(itemStack);
            long inserted = sink.insert(itemToTest, itemStack.m_41613_(), Actionable.SIMULATE);
            if (inserted <= 0L) continue;
            canStore = true;
        }
        this.isAccepting = canStore;
        return canStore;
    }

    private boolean breakBlockAndStoreExtraItems(PickupSink sink, ServerLevel level, BlockPos pos) {
        if (!level.m_46961_(pos, false)) {
            return false;
        }
        AABB box = new AABB(pos).m_82400_(0.2);
        for (ItemEntity itemEntity : level.m_45976_(ItemEntity.class, box)) {
            this.storeEntityItem(sink, itemEntity);
        }
        return true;
    }

    private HarvestTool createHarvestTool(BlockState state) {
        HarvestTool tool = state.m_60620_((Tag)BlockTags.f_144282_) ? new HarvestTool(new ItemStack((ItemLike)Items.f_42390_, 1), false) : (state.m_60620_((Tag)BlockTags.f_144280_) ? new HarvestTool(new ItemStack((ItemLike)Items.f_42391_, 1), false) : (state.m_60620_((Tag)BlockTags.f_144283_) ? new HarvestTool(new ItemStack((ItemLike)Items.f_42389_, 1), false) : (state.m_60620_((Tag)BlockTags.f_144281_) ? new HarvestTool(new ItemStack((ItemLike)Items.f_42392_, 1), false) : new HarvestTool(new ItemStack((ItemLike)Items.f_42390_, 1), true))));
        if (this.allowSilkTouch) {
            ItemStack item = tool.item().m_41777_();
            EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)Enchantments.f_44985_, (Object)1), (ItemStack)item);
            tool = new HarvestTool(item, false);
        }
        return tool;
    }

    public static boolean isBlockBlacklisted(Block b) {
        return BLOCK_BLACKLIST.m_8110_((Object)b);
    }

    public static boolean isItemBlacklisted(Item i) {
        return ITEM_BLACKLIST.m_8110_((Object)i);
    }

    record HarvestTool(ItemStack item, boolean fallback) {
    }
}

