/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.items;

import appeng.api.config.SecurityPermissions;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.IPatternTerminalHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.slot.InaccessibleSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.util.inv.AppEngInternalInventory;
import com.google.common.primitives.Ints;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SetProcessingPatternAmountMenu
extends AEBaseMenu
implements ISubMenu {
    public static final MenuType<SetProcessingPatternAmountMenu> TYPE = MenuTypeBuilder.create(SetProcessingPatternAmountMenu::new, IPatternTerminalHost.class).requirePermission(SecurityPermissions.BUILD).build("set_processing_pattern_amount");
    public static final String ACTION_SET_AMOUNT = "setAmount";
    private final Slot visualSlot;
    @GuiSync(value=1)
    private int initialAmount = -1;
    @GuiSync(value=2)
    private int maxAmount = -1;
    private InternalInventory slotInv;
    private final IPatternTerminalHost host;

    public SetProcessingPatternAmountMenu(int id, Inventory ip, IPatternTerminalHost host) {
        super(TYPE, id, ip, host);
        this.registerClientAction(ACTION_SET_AMOUNT, Integer.class, this::confirm);
        this.host = host;
        this.visualSlot = new InaccessibleSlot(new AppEngInternalInventory(1), 0);
        this.addSlot(this.visualSlot, SlotSemantics.MACHINE_OUTPUT);
    }

    @Override
    public IPatternTerminalHost getHost() {
        return this.host;
    }

    public static void open(ServerPlayer player, MenuLocator locator, InternalInventory slotInv) {
        MenuOpener.open(TYPE, (Player)player, locator);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof SetProcessingPatternAmountMenu) {
            SetProcessingPatternAmountMenu menu = (SetProcessingPatternAmountMenu)abstractContainerMenu;
            menu.setPatternSlot(slotInv);
            menu.m_38946_();
        }
    }

    @Override
    public void m_38946_() {
        if (this.host.getMode() != EncodingMode.PROCESSING) {
            this.host.returnToMainMenu(this.getPlayer(), this);
            return;
        }
        super.m_38946_();
        this.verifyPermissions(SecurityPermissions.BUILD, false);
    }

    public Level getLevel() {
        return this.getPlayerInventory().f_35978_.f_19853_;
    }

    private void setPatternSlot(InternalInventory slotInv) {
        this.slotInv = slotInv;
        ItemStack stack = slotInv.getStackInSlot(0);
        GenericStack wrappedStack = GenericStack.unwrapItemStack(stack);
        this.initialAmount = wrappedStack != null ? Ints.saturatedCast((long)wrappedStack.amount()) : stack.m_41613_();
        this.maxAmount = Integer.MAX_VALUE;
        this.visualSlot.m_5852_(stack);
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public void confirm(int amount) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_AMOUNT, amount);
            return;
        }
        ItemStack currentStack = this.slotInv.getStackInSlot(0);
        if (!Objects.equals(currentStack, this.visualSlot.m_7993_())) {
            this.host.returnToMainMenu(this.getPlayer(), this);
            return;
        }
        if ((amount = Mth.m_14045_((int)amount, (int)0, (int)Integer.MAX_VALUE)) <= 0) {
            this.slotInv.setItemDirect(0, ItemStack.f_41583_);
        } else {
            GenericStack unwrapped = GenericStack.fromItemStack(currentStack);
            if (unwrapped != null) {
                this.slotInv.setItemDirect(0, GenericStack.wrapInItemStack(unwrapped.what(), amount));
            }
        }
        this.host.returnToMainMenu(this.getPlayer(), this);
    }

    public int getInitialAmount() {
        return this.initialAmount;
    }

    @Nullable
    public AEKey getWhatToStock() {
        GenericStack stack = GenericStack.fromItemStack(this.visualSlot.m_7993_());
        return stack != null ? stack.what() : null;
    }
}

