/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.items;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.StorageHelper;
import appeng.core.definitions.AEItems;
import appeng.core.sync.packets.PatternSlotPacket;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.IPatternTerminalHost;
import appeng.items.storage.ViewCellItem;
import appeng.me.helpers.MachineSource;
import appeng.menu.NullMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.SetProcessingPatternAmountMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.FakeCraftingMatrixSlot;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.IOptionalSlotHost;
import appeng.menu.slot.OptionalFakeSlot;
import appeng.menu.slot.PatternOutputsSlot;
import appeng.menu.slot.PatternTermSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.util.Platform;
import appeng.util.inv.CarriedItemInventory;
import appeng.util.inv.PlayerInternalInventory;
import appeng.util.prioritylist.IPartitionList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class PatternEncodingTermMenu
extends MEStorageMenu
implements IOptionalSlotHost,
IMenuCraftingPacket {
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_ENCODE = "encode";
    private static final String ACTION_CLEAR = "clear";
    private static final String ACTION_SET_SUBSTITUTION = "setSubstitution";
    private static final String ACTION_SET_FLUID_SUBSTITUTION = "setFluidSubstitution";
    private static final String ACTION_SHOW_MODIFY_AMOUNT_MENU = "showModifyAmountMenu";
    private static final String ACTION_CYCLE_PROCESSING_OUTPUT = "cycleProcessingOutput";
    private static final int GROUP_SECONDARY_OUTPUT = 1;
    private static final int GROUP_CRAFTING_RESULT = 2;
    public static MenuType<PatternEncodingTermMenu> TYPE = MenuTypeBuilder.create(PatternEncodingTermMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("patternterm");
    private final IPatternTerminalHost patternTerminal;
    private final InternalInventory craftingGridInv;
    private final FakeCraftingMatrixSlot[] craftingGridSlots = new FakeCraftingMatrixSlot[9];
    private final OptionalFakeSlot[] processingOutputSlots = new OptionalFakeSlot[3];
    private final PatternTermSlot craftOutputSlot;
    private final RestrictedInputSlot blankPatternSlot;
    private final RestrictedInputSlot encodedPatternSlot;
    private CraftingRecipe currentRecipe;
    private EncodingMode currentMode;
    @GuiSync(value=97)
    public EncodingMode mode = EncodingMode.CRAFTING;
    @GuiSync(value=96)
    public boolean substitute = false;
    @GuiSync(value=95)
    public boolean substituteFluids = true;
    public IntSet slotsSupportingFluidSubstitution = new IntArraySet();

    public PatternEncodingTermMenu(int id, Inventory ip, ITerminalHost host) {
        this(TYPE, id, ip, host, true);
    }

    public PatternEncodingTermMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host, boolean bindInventory) {
        super(menuType, id, ip, host, bindInventory);
        int i;
        this.patternTerminal = (IPatternTerminalHost)host;
        InternalInventory patternInv = this.getPatternTerminal().getSubInventory(ISegmentedInventory.PATTERNS);
        InternalInventory output = this.getPatternTerminal().getSubInventory(IPatternTerminalHost.INV_OUTPUT);
        this.craftingGridInv = this.getPatternTerminal().getSubInventory(IPatternTerminalHost.INV_CRAFTING);
        for (i = 0; i < 9; ++i) {
            this.craftingGridSlots[i] = new FakeCraftingMatrixSlot(this.craftingGridInv, i);
            this.addSlot(this.craftingGridSlots[i], SlotSemantics.CRAFTING_GRID);
        }
        this.craftOutputSlot = new PatternTermSlot(ip.f_35978_, this.getActionSource(), this.powerSource, host.getInventory(), this.craftingGridInv, patternInv, this, 2, this);
        this.addSlot(this.craftOutputSlot, SlotSemantics.CRAFTING_RESULT);
        this.craftOutputSlot.setIcon(null);
        this.processingOutputSlots[0] = new PatternOutputsSlot(output, this, 0, 1);
        this.addSlot(this.processingOutputSlots[0], SlotSemantics.PROCESSING_PRIMARY_RESULT);
        this.processingOutputSlots[1] = new PatternOutputsSlot(output, this, 1, 1);
        this.addSlot(this.processingOutputSlots[1], SlotSemantics.PROCESSING_FIRST_OPTIONAL_RESULT);
        this.processingOutputSlots[2] = new PatternOutputsSlot(output, this, 2, 1);
        this.addSlot(this.processingOutputSlots[2], SlotSemantics.PROCESSING_SECOND_OPTIONAL_RESULT);
        for (i = 0; i < 3; ++i) {
            this.processingOutputSlots[i].setRenderDisabled(false);
            this.processingOutputSlots[i].setIcon(null);
        }
        this.blankPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, patternInv, 0);
        this.addSlot(this.blankPatternSlot, SlotSemantics.BLANK_PATTERN);
        this.encodedPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, patternInv, 1);
        this.addSlot(this.encodedPatternSlot, SlotSemantics.ENCODED_PATTERN);
        this.encodedPatternSlot.setStackLimit(1);
        this.registerClientAction(ACTION_ENCODE, this::encode);
        this.registerClientAction(ACTION_CLEAR, this::clear);
        this.registerClientAction(ACTION_SET_MODE, EncodingMode.class, this.getPatternTerminal()::setMode);
        this.registerClientAction(ACTION_SET_SUBSTITUTION, Boolean.class, this.getPatternTerminal()::setSubstitution);
        this.registerClientAction(ACTION_SET_FLUID_SUBSTITUTION, Boolean.class, this.getPatternTerminal()::setFluidSubstitution);
        this.registerClientAction(ACTION_SHOW_MODIFY_AMOUNT_MENU, Integer.class, this::showModifyAmountMenu);
        this.registerClientAction(ACTION_CYCLE_PROCESSING_OUTPUT, this::cycleProcessingOutput);
    }

    public void m_182406_(int slotID, int stateId, ItemStack stack) {
        super.m_182406_(slotID, stateId, stack);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        Level level = this.getPlayerInventory().f_35978_.f_19853_;
        CraftingContainer ic = new CraftingContainer((AbstractContainerMenu)this, 3, 3);
        boolean invalidIngredients = false;
        for (int x = 0; x < ic.m_6643_(); ++x) {
            ItemStack stack = this.unwrapCraftingIngredient(this.craftingGridInv.getStackInSlot(x));
            if (stack != null) {
                ic.m_6836_(x, stack);
                continue;
            }
            invalidIngredients = true;
        }
        if (this.currentRecipe == null || !this.currentRecipe.m_5818_((Container)ic, level)) {
            this.currentRecipe = invalidIngredients ? null : (CraftingRecipe)level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)ic, level).orElse(null);
            this.currentMode = this.mode;
            this.checkFluidSubstitutionSupport();
        }
        ItemStack is = this.currentRecipe == null ? ItemStack.f_41583_ : this.currentRecipe.m_5874_((Container)ic);
        this.craftOutputSlot.setDisplayedCraftingOutput(is);
        return is;
    }

    private void checkFluidSubstitutionSupport() {
        IPatternDetails decodedPattern;
        this.slotsSupportingFluidSubstitution.clear();
        if (this.currentRecipe == null) {
            return;
        }
        ItemStack encodedPattern = this.encodePattern();
        if (encodedPattern != null && (decodedPattern = PatternDetailsHelper.decodePattern(encodedPattern, this.getPlayerInventory().f_35978_.f_19853_)) instanceof AECraftingPattern) {
            AECraftingPattern craftingPattern = (AECraftingPattern)decodedPattern;
            for (int i = 0; i < craftingPattern.getSparseInputs().length; ++i) {
                if (craftingPattern.getValidFluid(i) == null) continue;
                this.slotsSupportingFluidSubstitution.add(i);
            }
        }
    }

    public void encode() {
        if (this.isClient()) {
            this.sendClientAction(ACTION_ENCODE);
            return;
        }
        ItemStack encodedPattern = this.encodePattern();
        if (encodedPattern != null) {
            ItemStack encodeOutput = this.encodedPatternSlot.m_7993_();
            if (!(encodeOutput.m_41619_() || PatternDetailsHelper.isEncodedPattern(encodeOutput) || AEItems.BLANK_PATTERN.isSameAs(encodeOutput))) {
                return;
            }
            if (encodeOutput.m_41619_()) {
                ItemStack blankPattern = this.blankPatternSlot.m_7993_();
                if (!this.isPattern(blankPattern)) {
                    return;
                }
                blankPattern.m_41774_(1);
                if (blankPattern.m_41613_() <= 0) {
                    this.blankPatternSlot.m_5852_(ItemStack.f_41583_);
                }
            }
            this.encodedPatternSlot.m_5852_(encodedPattern);
        } else {
            this.clearPattern();
        }
    }

    private void clearPattern() {
        ItemStack encodedPattern = this.encodedPatternSlot.m_7993_();
        if (PatternDetailsHelper.isEncodedPattern(encodedPattern)) {
            this.encodedPatternSlot.m_5852_(AEItems.BLANK_PATTERN.stack(encodedPattern.m_41613_()));
        }
    }

    @Nullable
    private ItemStack encodePattern() {
        if (this.mode == EncodingMode.CRAFTING) {
            return this.encodeCraftingPattern();
        }
        return this.encodeProcessingPattern();
    }

    @Nullable
    private ItemStack encodeCraftingPattern() {
        ItemStack[] ingredients = new ItemStack[this.craftingGridSlots.length];
        boolean valid = false;
        for (int x = 0; x < this.craftingGridSlots.length; ++x) {
            ingredients[x] = this.unwrapCraftingIngredient(this.craftingGridSlots[x].m_7993_());
            if (ingredients[x] == null) {
                return null;
            }
            if (ingredients[x].m_41619_()) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        ItemStack result = this.getAndUpdateOutput();
        if (result.m_41619_() || this.currentRecipe == null) {
            return null;
        }
        return PatternDetailsHelper.encodeCraftingPattern(this.currentRecipe, ingredients, result, this.isSubstitute(), this.isSubstituteFluids());
    }

    @Nullable
    private ItemStack encodeProcessingPattern() {
        GenericStack[] inputs = new GenericStack[this.craftingGridSlots.length];
        boolean valid = false;
        for (int x = 0; x < this.craftingGridSlots.length; ++x) {
            inputs[x] = GenericStack.fromItemStack(this.craftingGridSlots[x].m_7993_());
            if (inputs[x] == null) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        GenericStack[] outputs = new GenericStack[3];
        for (int i = 0; i < this.processingOutputSlots.length; ++i) {
            outputs[i] = GenericStack.fromItemStack(this.processingOutputSlots[i].m_7993_());
        }
        if (outputs[0] == null) {
            return null;
        }
        return PatternDetailsHelper.encodeProcessingPattern(inputs, outputs);
    }

    @Nullable
    private ItemStack unwrapCraftingIngredient(ItemStack ingredient) {
        GenericStack unwrapped = GenericStack.unwrapItemStack(ingredient);
        if (unwrapped != null) {
            AEKey aEKey = unwrapped.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                return itemKey.toStack(1);
            }
            return null;
        }
        return ingredient;
    }

    private boolean isPattern(ItemStack output) {
        if (output.m_41619_()) {
            return false;
        }
        return AEItems.BLANK_PATTERN.isSameAs(output);
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        EncodingMode effectiveMode;
        EncodingMode encodingMode = effectiveMode = this.isServer() ? this.getPatternTerminal().getMode() : this.mode;
        if (idx == 1) {
            return this.mode == EncodingMode.PROCESSING;
        }
        if (idx == 2) {
            return this.mode == EncodingMode.CRAFTING;
        }
        return false;
    }

    public void craftOrGetItem(PatternSlotPacket packetPatternSlot) {
        ItemStack what = packetPatternSlot.what;
        if (what.m_41619_() || this.storage == null || !this.isPowered()) {
            return;
        }
        InternalInventory inv = new CarriedItemInventory(this);
        PlayerInternalInventory playerInv = new PlayerInternalInventory(this.getPlayerInventory());
        if (packetPatternSlot.intoPlayerInv) {
            inv = playerInv;
        }
        if (!inv.simulateAdd(what).m_41619_()) {
            return;
        }
        AEItemKey itemKey = AEItemKey.of(what);
        int amount = Mth.m_14045_((int)what.m_41613_(), (int)1, (int)what.m_41720_().m_41459_());
        long extracted = StorageHelper.poweredExtraction(this.powerSource, this.storage, itemKey, amount, this.getActionSource());
        Player p = this.getPlayerInventory().f_35978_;
        if (extracted > 0L) {
            what.m_41764_(amount);
            inv.addItems(what);
            this.m_38946_();
            return;
        }
        CraftingContainer ic = new CraftingContainer((AbstractContainerMenu)new NullMenu(), 3, 3);
        CraftingContainer real = new CraftingContainer((AbstractContainerMenu)new NullMenu(), 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.m_6836_(x, packetPatternSlot.pattern[x]);
        }
        CraftingRecipe r = p.f_19853_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)ic, p.f_19853_).orElse(null);
        if (r == null) {
            return;
        }
        KeyCounter all = this.getPreviousAvailableStacks();
        ItemStack is = r.m_5874_((Container)ic);
        IPartitionList partitionFilter = ViewCellItem.createItemFilter(this.getViewCells());
        for (int x = 0; x < ic.m_6643_(); ++x) {
            if (ic.m_8020_(x).m_41619_()) continue;
            ItemStack pulled = Platform.extractItemsByRecipe(this.powerSource, this.getActionSource(), this.storage, p.f_19853_, (Recipe<CraftingContainer>)r, is, ic, ic.m_8020_(x), x, all, Actionable.MODULATE, partitionFilter);
            real.m_6836_(x, pulled);
        }
        CraftingRecipe rr = p.f_19853_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)real, p.f_19853_).orElse(null);
        if (rr == r && ItemStack.m_150942_((ItemStack)rr.m_5874_((Container)real), (ItemStack)is)) {
            ResultContainer craftingResult = new ResultContainer();
            craftingResult.m_6029_((Recipe)rr);
            ResultSlot sc = new ResultSlot(p, real, (Container)craftingResult, 0, 0, 0);
            sc.m_142406_(p, is);
            for (int x = 0; x < real.m_6643_(); ++x) {
                ItemStack failed = playerInv.addItems(real.m_8020_(x));
                if (failed.m_41619_()) continue;
                p.m_36176_(failed, false);
            }
            inv.addItems(is);
            this.m_38946_();
        } else {
            for (int x = 0; x < real.m_6643_(); ++x) {
                ItemStack failed = real.m_8020_(x);
                if (failed.m_41619_()) continue;
                this.storage.insert(AEItemKey.of(failed), failed.m_41613_(), Actionable.MODULATE, new MachineSource(this.getPatternTerminal()));
            }
        }
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        if (this.isServer()) {
            if (this.mode != this.getPatternTerminal().getMode()) {
                this.setMode(this.getPatternTerminal().getMode());
            }
            this.substitute = this.patternTerminal.isSubstitution();
            this.substituteFluids = this.patternTerminal.isFluidSubstitution();
        }
    }

    @Override
    public void onServerDataSync() {
        super.onServerDataSync();
        for (FakeCraftingMatrixSlot slot : this.craftingGridSlots) {
            slot.setHideAmount(this.mode == EncodingMode.CRAFTING);
        }
        if (this.currentMode != this.mode) {
            this.getAndUpdateOutput();
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.encodedPatternSlot && this.isServer()) {
            this.m_38946_();
        }
        if (s == this.craftOutputSlot && this.isClient()) {
            this.getAndUpdateOutput();
        }
    }

    public void clear() {
        if (this.isClient()) {
            this.sendClientAction(ACTION_CLEAR);
            return;
        }
        for (FakeCraftingMatrixSlot fakeCraftingMatrixSlot : this.craftingGridSlots) {
            fakeCraftingMatrixSlot.m_5852_(ItemStack.f_41583_);
        }
        for (FakeSlot fakeSlot : this.processingOutputSlots) {
            fakeSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
        this.getAndUpdateOutput();
    }

    @Override
    public InternalInventory getCraftingMatrix() {
        return this.craftingGridInv;
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public EncodingMode getMode() {
        return this.mode;
    }

    public void setMode(EncodingMode mode) {
        if (this.isClient()) {
            this.sendClientAction(ACTION_SET_MODE, mode);
        } else {
            this.mode = mode;
        }
    }

    public IPatternTerminalHost getPatternTerminal() {
        return this.patternTerminal;
    }

    public boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        if (this.isClient()) {
            this.sendClientAction(ACTION_SET_SUBSTITUTION, substitute);
        } else {
            this.substitute = substitute;
        }
    }

    public boolean isSubstituteFluids() {
        return this.substituteFluids;
    }

    public void setSubstituteFluids(boolean substituteFluids) {
        if (this.isClient()) {
            this.sendClientAction(ACTION_SET_FLUID_SUBSTITUTION, substituteFluids);
        } else {
            this.substituteFluids = substituteFluids;
        }
    }

    @Override
    protected ItemStack transferStackToMenu(ItemStack input) {
        if (this.blankPatternSlot.m_5857_(input) && (input = this.blankPatternSlot.m_150659_(input)).m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.encodedPatternSlot.m_5857_(input) && (input = this.encodedPatternSlot.m_150659_(input)).m_41619_()) {
            return ItemStack.f_41583_;
        }
        return super.transferStackToMenu(input);
    }

    @Contract(value="null -> false")
    public boolean canModifyAmountForSlot(@Nullable Slot slot) {
        return this.isProcessingPatternSlot(slot) && slot.m_6657_();
    }

    @Contract(value="null -> false")
    public boolean isProcessingPatternSlot(@Nullable Slot slot) {
        if (slot == null || this.mode != EncodingMode.PROCESSING) {
            return false;
        }
        for (OptionalFakeSlot optionalFakeSlot : this.processingOutputSlots) {
            if (optionalFakeSlot != slot) continue;
            return true;
        }
        for (FakeSlot fakeSlot : this.craftingGridSlots) {
            if (fakeSlot != slot) continue;
            return true;
        }
        return false;
    }

    public FakeCraftingMatrixSlot[] getCraftingGridSlots() {
        return this.craftingGridSlots;
    }

    public OptionalFakeSlot[] getProcessingOutputSlots() {
        return this.processingOutputSlots;
    }

    public void showModifyAmountMenu(int slotIdx) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SHOW_MODIFY_AMOUNT_MENU, slotIdx);
        } else {
            Slot slot = (Slot)this.f_38839_.get(slotIdx);
            if (!this.canModifyAmountForSlot(slot) || !(slot instanceof AppEngSlot)) {
                return;
            }
            AppEngSlot aeSlot = (AppEngSlot)slot;
            SetProcessingPatternAmountMenu.open((ServerPlayer)this.getPlayer(), this.getLocator(), aeSlot.getSlotInv());
        }
    }

    public void cycleProcessingOutput() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CYCLE_PROCESSING_OUTPUT);
        } else {
            int i;
            if (this.mode != EncodingMode.PROCESSING) {
                return;
            }
            ItemStack[] newOutputs = new ItemStack[this.getProcessingOutputSlots().length];
            block0: for (i = 0; i < this.processingOutputSlots.length; ++i) {
                newOutputs[i] = ItemStack.f_41583_;
                if (this.processingOutputSlots[i].m_7993_().m_41619_()) continue;
                for (int j = 1; j < this.processingOutputSlots.length; ++j) {
                    ItemStack nextItem = this.processingOutputSlots[(i + j) % this.processingOutputSlots.length].m_7993_();
                    if (nextItem.m_41619_()) continue;
                    newOutputs[i] = nextItem;
                    continue block0;
                }
            }
            for (i = 0; i < newOutputs.length; ++i) {
                this.processingOutputSlots[i].m_5852_(newOutputs[i]);
            }
        }
    }

    public boolean canCycleProcessingOutputs() {
        return this.mode == EncodingMode.PROCESSING && Arrays.stream(this.processingOutputSlots).filter(s -> !s.m_7993_().m_41619_()).count() > 1L;
    }
}

