/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.items;

import appeng.api.config.SecurityPermissions;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.ITerminalHost;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.NullMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.slot.CraftingMatrixSlot;
import appeng.menu.slot.CraftingTermSlot;
import appeng.parts.reporting.CraftingTerminalPart;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CraftingTermMenu
extends MEStorageMenu
implements IMenuCraftingPacket {
    public static final MenuType<CraftingTermMenu> TYPE = MenuTypeBuilder.create(CraftingTermMenu::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("craftingterm");
    private final ISegmentedInventory craftingInventoryHost;
    private final CraftingMatrixSlot[] craftingSlots = new CraftingMatrixSlot[9];
    private final CraftingTermSlot outputSlot;
    private Recipe<CraftingContainer> currentRecipe;

    public CraftingTermMenu(int id, Inventory ip, ITerminalHost host) {
        this(TYPE, id, ip, host, true);
    }

    public CraftingTermMenu(MenuType<?> menuType, int id, Inventory ip, ITerminalHost host, boolean bindInventory) {
        super(menuType, id, ip, host, bindInventory);
        this.craftingInventoryHost = (ISegmentedInventory)((Object)host);
        InternalInventory craftingGridInv = this.craftingInventoryHost.getSubInventory(CraftingTerminalPart.INV_CRAFTING);
        for (int i = 0; i < 9; ++i) {
            this.craftingSlots[i] = new CraftingMatrixSlot(this, craftingGridInv, i);
            this.addSlot(this.craftingSlots[i], SlotSemantics.CRAFTING_GRID);
        }
        this.outputSlot = new CraftingTermSlot(this.getPlayerInventory().f_35978_, this.getActionSource(), this.powerSource, host.getInventory(), craftingGridInv, craftingGridInv, this);
        this.addSlot(this.outputSlot, SlotSemantics.CRAFTING_RESULT);
        this.m_6199_(craftingGridInv.toContainer());
    }

    public void m_6199_(Container inventory) {
        NullMenu cn = new NullMenu();
        CraftingContainer ic = new CraftingContainer((AbstractContainerMenu)cn, 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.m_6836_(x, this.craftingSlots[x].m_7993_());
        }
        Level level = this.getPlayerInventory().f_35978_.f_19853_;
        if (this.currentRecipe == null || !this.currentRecipe.m_5818_((Container)ic, level)) {
            this.currentRecipe = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)ic, level).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        } else {
            this.outputSlot.m_5852_(this.currentRecipe.m_5874_((Container)ic));
        }
    }

    @Override
    public InternalInventory getCraftingMatrix() {
        return this.craftingInventoryHost.getSubInventory(CraftingTerminalPart.INV_CRAFTING);
    }

    @Override
    public boolean useRealItems() {
        return true;
    }

    public Recipe<CraftingContainer> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void clearCraftingGrid() {
        Preconditions.checkState((boolean)this.isClient());
        CraftingMatrixSlot slot = this.craftingSlots[0];
        InventoryActionPacket p = new InventoryActionPacket(InventoryAction.MOVE_REGION, slot.f_40219_, 0L);
        NetworkHandler.instance().sendToServer(p);
    }

    @Override
    public boolean hasIngredient(Predicate<ItemStack> predicate, int amount) {
        for (Slot slot : this.getSlots(SlotSemantics.CRAFTING_GRID)) {
            ItemStack stackInSlot = slot.m_7993_();
            if (stackInSlot.m_41619_() || !predicate.test(stackInSlot)) continue;
            if (stackInSlot.m_41613_() >= amount) {
                return true;
            }
            amount -= stackInSlot.m_41613_();
        }
        return super.hasIngredient(predicate, amount);
    }

    public Set<Integer> findMissingIngredients(Map<Integer, Ingredient> ingredients) {
        HashSet<Integer> missingSlots = new HashSet<Integer>();
        Object2IntOpenHashMap reservedGridAmounts = new Object2IntOpenHashMap();
        NonNullList playerItems = this.getPlayerInventory().f_35974_;
        int[] reservedPlayerItems = new int[playerItems.size()];
        for (Map.Entry<Integer, Ingredient> entry : ingredients.entrySet()) {
            int neededAmount;
            Ingredient ingredient = entry.getValue();
            boolean found = false;
            for (int i = 0; i < playerItems.size(); ++i) {
                ItemStack stack = (ItemStack)playerItems.get(i);
                if (stack.m_41613_() - reservedPlayerItems[i] <= 0 || !ingredient.test(stack)) continue;
                int n = i;
                reservedPlayerItems[n] = reservedPlayerItems[n] + 1;
                found = true;
                break;
            }
            if (!found && this.hasIngredient((Predicate<ItemStack>)ingredient, neededAmount = reservedGridAmounts.getOrDefault((Object)ingredient, 0) + 1)) {
                reservedGridAmounts.put((Object)ingredient, neededAmount);
                found = true;
            }
            if (found) continue;
            missingSlots.add(entry.getKey());
        }
        return missingSlots;
    }
}

