/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEItems;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.inv.AppEngInternalInventory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.Event;

public class QuartzKnifeMenu
extends AEBaseMenu {
    private static final String ACTION_SET_NAME = "setName";
    public static final MenuType<QuartzKnifeMenu> TYPE = MenuTypeBuilder.create(QuartzKnifeMenu::new, ItemMenuHost.class).build("quartzknife");
    private final InternalInventory inSlot = new AppEngInternalInventory(null, 1, 1);
    private String currentName = "";

    public QuartzKnifeMenu(int id, Inventory ip, ItemMenuHost host) {
        super(TYPE, id, ip, host);
        this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.METAL_INGOTS, this.inSlot, 0), SlotSemantics.MACHINE_INPUT);
        this.addSlot(new QuartzKniveSlot(this.inSlot, 0, null), SlotSemantics.MACHINE_OUTPUT);
        this.createPlayerInventorySlots(ip);
        this.registerClientAction(ACTION_SET_NAME, String.class, this::setName);
    }

    public void setName(String value) {
        this.currentName = value;
        if (this.isClient()) {
            this.sendClientAction(ACTION_SET_NAME, value);
        }
    }

    public void m_6877_(Player player) {
        ItemStack item = this.inSlot.extractItem(0, Integer.MAX_VALUE, false);
        if (!item.m_41619_()) {
            player.m_36176_(item, false);
        }
    }

    private class QuartzKniveSlot
    extends OutputSlot {
        QuartzKniveSlot(InternalInventory inv, int invSlot, Icon icon) {
            super(inv, invSlot, icon);
        }

        @Override
        public ItemStack m_7993_() {
            InternalInventory baseInv = this.getInventory();
            ItemStack input = baseInv.getStackInSlot(0);
            if (input == ItemStack.f_41583_) {
                return ItemStack.f_41583_;
            }
            if (RestrictedInputSlot.isMetalIngot(input) && QuartzKnifeMenu.this.currentName.length() > 0) {
                ItemStack namePressStack = AEItems.NAME_PRESS.stack();
                CompoundTag compound = namePressStack.m_41784_();
                compound.m_128359_("InscribeName", QuartzKnifeMenu.this.currentName);
                return namePressStack;
            }
            return ItemStack.f_41583_;
        }

        @Override
        public ItemStack m_6201_(int amount) {
            ItemStack ret = this.m_7993_();
            if (!ret.m_41619_()) {
                this.makePlate();
            }
            return ret;
        }

        @Override
        public void m_5852_(ItemStack stack) {
            if (stack.m_41619_()) {
                this.makePlate();
            }
        }

        private void makePlate() {
            if (QuartzKnifeMenu.this.isServer() && !this.getInventory().extractItem(0, 1, false).m_41619_()) {
                ItemStack item = QuartzKnifeMenu.this.itemMenuHost.getItemStack();
                ItemStack before = item.m_41777_();
                Inventory playerInv = QuartzKnifeMenu.this.getPlayerInventory();
                item.m_41622_(1, (LivingEntity)playerInv.f_35978_, p -> {
                    playerInv.m_6836_(playerInv.f_35977_, ItemStack.f_41583_);
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(playerInv.f_35978_, before, null));
                });
                QuartzKnifeMenu.this.m_38946_();
            }
        }
    }
}

