/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.networking.IGridNode;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.parts.IPart;
import appeng.core.localization.InGameTooltip;
import appeng.integration.modules.waila.part.IPartDataProvider;
import appeng.me.service.AdHocNetworkError;
import appeng.me.service.PathingService;
import appeng.parts.networking.IUsedChannelProvider;
import mcp.mobius.waila.api.ITooltip;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class ChannelDataProvider
implements IPartDataProvider {
    private static final String TAG_MAX_CHANNELS = "maxChannels";
    private static final String TAG_USED_CHANNELS = "usedChannels";
    private static final String TAG_ERROR = "channelError";

    @Override
    public void appendBodyTooltip(IPart part, CompoundTag partTag, ITooltip tooltip) {
        if (partTag.m_128425_(TAG_ERROR, 8)) {
            ChannelError error = ChannelError.valueOf(partTag.m_128461_(TAG_ERROR));
            tooltip.add((Component)error.text.text().m_130940_(ChatFormatting.RED));
            return;
        }
        if (partTag.m_128425_(TAG_MAX_CHANNELS, 3)) {
            int usedChannels = partTag.m_128451_(TAG_USED_CHANNELS);
            int maxChannels = partTag.m_128451_(TAG_MAX_CHANNELS);
            if (maxChannels <= 0) {
                tooltip.add((Component)InGameTooltip.Channels.text(usedChannels));
            } else {
                tooltip.add((Component)InGameTooltip.ChannelsOf.text(usedChannels, maxChannels));
            }
        }
    }

    @Override
    public void appendServerData(ServerPlayer player, IPart part, CompoundTag partTag) {
        if (part instanceof IUsedChannelProvider) {
            IUsedChannelProvider usedChannelProvider = (IUsedChannelProvider)part;
            IGridNode gridNode = part.getGridNode();
            if (gridNode != null) {
                PathingService pathingService = (PathingService)gridNode.getGrid().getPathingService();
                if (pathingService.getControllerState() == ControllerState.NO_CONTROLLER) {
                    AdHocNetworkError adHocError = pathingService.getAdHocNetworkError();
                    if (adHocError != null) {
                        partTag.m_128359_(TAG_ERROR, switch (adHocError) {
                            default -> throw new IncompatibleClassChangeError();
                            case AdHocNetworkError.NESTED_P2P_TUNNEL -> ChannelError.AD_HOC_NESTED_P2P_TUNNEL.name();
                            case AdHocNetworkError.TOO_MANY_CHANNELS -> ChannelError.AD_HOC_TOO_MANY_CHANNELS.name();
                        });
                        return;
                    }
                } else if (pathingService.getControllerState() == ControllerState.CONTROLLER_CONFLICT) {
                    partTag.m_128359_(TAG_ERROR, ChannelError.CONTROLLER_CONFLICT.name());
                }
            }
            partTag.m_128405_(TAG_USED_CHANNELS, usedChannelProvider.getUsedChannelsInfo());
            partTag.m_128405_(TAG_MAX_CHANNELS, usedChannelProvider.getMaxChannelsInfo());
        }
    }

    static enum ChannelError {
        AD_HOC_NESTED_P2P_TUNNEL(InGameTooltip.ErrorNestedP2PTunnel),
        AD_HOC_TOO_MANY_CHANNELS(InGameTooltip.ErrorTooManyChannels),
        CONTROLLER_CONFLICT(InGameTooltip.ErrorControllerConflict);

        final InGameTooltip text;

        private ChannelError(InGameTooltip text) {
            this.text = text;
        }
    }
}

