/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoritePlacer;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.debug.MeteoriteSpawner;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class MeteoritePlacerItem
extends AEBaseItem {
    private static final String MODE_TAG = "mode";

    public MeteoritePlacerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        if (InteractionUtil.isInAlternateUseMode(player)) {
            ItemStack itemStack = player.m_21120_(hand);
            CompoundTag tag = itemStack.m_41784_();
            if (tag.m_128441_(MODE_TAG)) {
                byte mode = tag.m_128445_(MODE_TAG);
                tag.m_128344_(MODE_TAG, (byte)((mode + 1) % CraterType.values().length));
            } else {
                tag.m_128344_(MODE_TAG, (byte)CraterType.NORMAL.ordinal());
            }
            CraterType craterType = CraterType.values()[tag.m_128445_(MODE_TAG)];
            player.m_6352_((Component)new TextComponent(craterType.name()), Util.f_137441_);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43725_().m_5776_()) {
            return InteractionResult.PASS;
        }
        ServerPlayer player = (ServerPlayer)context.m_43723_();
        ServerLevel level = (ServerLevel)context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(MODE_TAG)) {
            tag.m_128344_(MODE_TAG, (byte)CraterType.NORMAL.ordinal());
        }
        float coreRadius = Platform.getRandomFloat() * 6.0f + 2.0f;
        boolean pureCrater = Platform.getRandomFloat() > 0.5f;
        MeteoriteSpawner spawner = new MeteoriteSpawner();
        CraterType craterType = CraterType.values()[tag.m_128445_(MODE_TAG)];
        PlacedMeteoriteSettings spawned = spawner.trySpawnMeteoriteAtSuitableHeight((LevelReader)level, pos, coreRadius, craterType, pureCrater);
        if (spawned == null) {
            player.m_6352_((Component)new TextComponent("Un-suitable Location."), Util.f_137441_);
            return InteractionResult.FAIL;
        }
        int range = (int)Math.ceil((coreRadius * 2.0f + 5.0f) * 5.0f);
        BoundingBox boundingBox = new BoundingBox(pos.m_123341_() - range, pos.m_123342_(), pos.m_123343_() - range, pos.m_123341_() + range, pos.m_123342_(), pos.m_123343_() + range);
        MeteoritePlacer placer = new MeteoritePlacer((LevelAccessor)level, spawned, boundingBox, level.f_46441_);
        placer.place();
        player.m_6352_((Component)new TextComponent("Spawned at y=" + spawned.getPos().m_123342_() + " range=" + range + " biomeCategory=" + level.m_46857_(pos).m_47567_()), Util.f_137441_);
        ChunkPos.m_45596_((ChunkPos)new ChunkPos(spawned.getPos()), (int)1).forEach(cp -> {
            LevelChunk c = level.m_6325_(cp.f_45578_, cp.f_45579_);
            player.f_8906_.m_141995_(Platform.getFullChunkPacket(c));
        });
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }
}

