/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.EventRepeater;
import appeng.client.gui.widgets.IScrollSource;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class Scrollbar
implements IScrollSource,
ICompositeWidget {
    private static int HANDLE_WIDTH = 12;
    private static int HANDLE_HEIGHT = 15;
    private static ResourceLocation TEXTURE = new ResourceLocation("minecraft", "textures/gui/container/creative_inventory/tabs.png");
    private static final Blitter ENABLED = Blitter.texture(TEXTURE).src(232, 0, HANDLE_WIDTH, HANDLE_HEIGHT);
    private static final Blitter DISABLED = Blitter.texture(TEXTURE).src(232 + HANDLE_WIDTH, 0, HANDLE_WIDTH, HANDLE_HEIGHT);
    private int displayX = 0;
    private int displayY = 0;
    private int width = HANDLE_WIDTH;
    private int height = 16;
    private int pageSize = 1;
    private int maxScroll = 0;
    private int minScroll = 0;
    private int currentScroll = 0;
    private boolean dragging;
    private int dragYOffset;
    private final EventRepeater eventRepeater = new EventRepeater(Duration.ofMillis(250L), Duration.ofMillis(150L));

    @Override
    public Rect2i getBounds() {
        return new Rect2i(this.displayX, this.displayY, this.width, this.height);
    }

    @Override
    public void drawForegroundLayer(PoseStack poseStack, int zIndex, Rect2i bounds, Point mouse) {
        Blitter image;
        int yOffset;
        if (this.getRange() == 0) {
            yOffset = 0;
            image = DISABLED;
        } else {
            yOffset = this.getHandleYOffset();
            image = ENABLED;
        }
        image.dest(this.displayX, this.displayY + yOffset).blit(poseStack, zIndex);
    }

    private int getHandleYOffset() {
        if (this.getRange() == 0) {
            return 0;
        }
        int availableHeight = this.height - HANDLE_HEIGHT;
        return (this.currentScroll - this.minScroll) * availableHeight / this.getRange();
    }

    private int getRange() {
        return this.maxScroll - this.minScroll;
    }

    public Scrollbar setHeight(int v) {
        this.height = v;
        return this;
    }

    @Override
    public void setPosition(Point position) {
        this.displayX = position.getX();
        this.displayY = position.getY();
    }

    @Override
    public void setSize(int width, int height) {
        if (width != 0) {
            this.width = width;
        }
        if (height != 0) {
            this.height = height;
        }
    }

    public void setRange(int min, int max, int pageSize) {
        this.minScroll = min;
        this.maxScroll = max;
        this.pageSize = pageSize;
        if (this.minScroll > this.maxScroll) {
            this.maxScroll = this.minScroll;
        }
        this.applyRange();
    }

    private void applyRange() {
        this.currentScroll = Math.max(Math.min(this.currentScroll, this.maxScroll), this.minScroll);
    }

    @Override
    public int getCurrentScroll() {
        return this.currentScroll;
    }

    @Override
    public boolean onMouseDown(Point mousePos, int button) {
        int handleYOffset;
        if (button != 0) {
            return false;
        }
        this.dragging = false;
        if (this.getRange() == 0) {
            return true;
        }
        int relY = mousePos.getY() - this.displayY;
        if (relY < (handleYOffset = this.getHandleYOffset())) {
            this.pageUp();
            this.eventRepeater.repeat(this::pageUp);
        } else if (relY < handleYOffset + HANDLE_HEIGHT) {
            this.dragging = true;
            this.dragYOffset = relY - handleYOffset;
        } else {
            this.pageDown();
            this.eventRepeater.repeat(this::pageDown);
        }
        return true;
    }

    @Override
    public boolean onMouseUp(Point mousePos, int button) {
        if (button == 0) {
            this.dragging = false;
            this.eventRepeater.stop();
        }
        return false;
    }

    @Override
    public boolean wantsAllMouseUpEvents() {
        return true;
    }

    @Override
    public boolean onMouseDrag(Point mousePos, int button) {
        if (this.getRange() == 0 || !this.dragging || this.eventRepeater.isRepeating()) {
            return false;
        }
        double handleUpperEdgeY = mousePos.getY() - this.displayY - this.dragYOffset;
        double availableHeight = this.height - HANDLE_HEIGHT;
        double position = Mth.m_14008_((double)(handleUpperEdgeY / availableHeight), (double)0.0, (double)1.0);
        this.currentScroll = this.minScroll + (int)Math.round(position * (double)this.getRange());
        this.applyRange();
        return true;
    }

    @Override
    public boolean onMouseWheel(Point mousePos, double delta) {
        if (this.getRange() == 0) {
            return false;
        }
        delta = Math.max(Math.min(-delta, 1.0), -1.0);
        this.currentScroll = (int)((double)this.currentScroll + delta * (double)this.pageSize);
        this.applyRange();
        return true;
    }

    @Override
    public boolean wantsAllMouseWheelEvents() {
        return true;
    }

    @Override
    public void tick() {
        this.eventRepeater.tick();
    }

    private void pageUp() {
        this.currentScroll -= this.pageSize;
        this.applyRange();
    }

    private void pageDown() {
        this.currentScroll += this.pageSize;
        this.applyRange();
    }
}

