/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.config.ActionItems;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.TabButton;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PatternSlotPacket;
import appeng.menu.SlotSemantics;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.PatternTermSlot;
import appeng.parts.encoding.EncodingMode;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class PatternEncodingTermScreen<C extends PatternEncodingTermMenu>
extends MEStorageScreen<C> {
    private static final String MODES_TEXTURE = "guis/pattern_modes.png";
    private static final Blitter CRAFTING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 0, 126, 68);
    private static final Blitter PROCESSING_MODE_BG = Blitter.texture("guis/pattern_modes.png").src(0, 70, 126, 68);
    private final TabButton tabCraftButton;
    private final TabButton tabProcessButton;
    private final ActionButton substitutionsEnabledBtn;
    private final ActionButton substitutionsDisabledBtn;
    private final ActionButton fluidSubstitutionsEnabledBtn;
    private final ActionButton fluidSubstitutionsDisabledBtn;
    private final ActionButton cycleProcessingOutputBtn;

    public PatternEncodingTermScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        ActionButton clearBtn = new ActionButton(ActionItems.CLOSE, act -> menu.clear());
        clearBtn.setHalfSize(true);
        this.widgets.add("clearPattern", (AbstractWidget)clearBtn);
        this.substitutionsEnabledBtn = new ActionButton(ActionItems.ENABLE_SUBSTITUTION, act -> ((PatternEncodingTermMenu)this.m_6262_()).setSubstitute(false));
        this.substitutionsEnabledBtn.setHalfSize(true);
        this.widgets.add("substitutionsEnabled", (AbstractWidget)this.substitutionsEnabledBtn);
        this.substitutionsDisabledBtn = new ActionButton(ActionItems.DISABLE_SUBSTITUTION, act -> ((PatternEncodingTermMenu)this.m_6262_()).setSubstitute(true));
        this.substitutionsDisabledBtn.setHalfSize(true);
        this.widgets.add("substitutionsDisabled", (AbstractWidget)this.substitutionsDisabledBtn);
        this.fluidSubstitutionsEnabledBtn = new ActionButton(ActionItems.ENABLE_FLUID_SUBSTITUTION, act -> ((PatternEncodingTermMenu)this.m_6262_()).setSubstituteFluids(false));
        this.fluidSubstitutionsEnabledBtn.setHalfSize(true);
        this.widgets.add("fluidSubstitutionsEnabled", (AbstractWidget)this.fluidSubstitutionsEnabledBtn);
        this.fluidSubstitutionsDisabledBtn = new ActionButton(ActionItems.DISABLE_FLUID_SUBSTITUTION, act -> ((PatternEncodingTermMenu)this.m_6262_()).setSubstituteFluids(true));
        this.fluidSubstitutionsDisabledBtn.setHalfSize(true);
        this.widgets.add("fluidSubstitutionsDisabled", (AbstractWidget)this.fluidSubstitutionsDisabledBtn);
        this.cycleProcessingOutputBtn = new ActionButton(ActionItems.CYCLE_PROCESSING_OUTPUT, act -> ((PatternEncodingTermMenu)this.m_6262_()).cycleProcessingOutput());
        this.cycleProcessingOutputBtn.setHalfSize(true);
        this.widgets.add("cycleProcessingOutput", (AbstractWidget)this.cycleProcessingOutputBtn);
        ActionButton encodeBtn = new ActionButton(ActionItems.ENCODE, act -> menu.encode());
        this.widgets.add("encodePattern", (AbstractWidget)encodeBtn);
        this.tabCraftButton = new TabButton(new ItemStack((ItemLike)Blocks.f_50091_), (Component)GuiText.CraftingPattern.text(), this.f_96542_, btn -> ((PatternEncodingTermMenu)this.m_6262_()).setMode(EncodingMode.PROCESSING));
        this.widgets.add("craftingPatternMode", (AbstractWidget)this.tabCraftButton);
        this.tabProcessButton = new TabButton(new ItemStack((ItemLike)Blocks.f_50094_), (Component)GuiText.ProcessingPattern.text(), this.f_96542_, btn -> ((PatternEncodingTermMenu)this.m_6262_()).setMode(EncodingMode.CRAFTING));
        this.widgets.add("processingPatternMode", (AbstractWidget)this.tabProcessButton);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        EncodingMode mode = ((PatternEncodingTermMenu)this.f_97732_).getMode();
        if (mode == EncodingMode.CRAFTING) {
            this.tabCraftButton.f_93624_ = true;
            this.tabProcessButton.f_93624_ = false;
            if (((PatternEncodingTermMenu)this.f_97732_).substitute) {
                this.substitutionsEnabledBtn.f_93624_ = true;
                this.substitutionsDisabledBtn.f_93624_ = false;
            } else {
                this.substitutionsEnabledBtn.f_93624_ = false;
                this.substitutionsDisabledBtn.f_93624_ = true;
            }
            if (((PatternEncodingTermMenu)this.f_97732_).substituteFluids) {
                this.fluidSubstitutionsEnabledBtn.f_93624_ = true;
                this.fluidSubstitutionsDisabledBtn.f_93624_ = false;
            } else {
                this.fluidSubstitutionsEnabledBtn.f_93624_ = false;
                this.fluidSubstitutionsDisabledBtn.f_93624_ = true;
            }
        } else {
            this.tabCraftButton.f_93624_ = false;
            this.tabProcessButton.f_93624_ = true;
            this.substitutionsEnabledBtn.f_93624_ = false;
            this.substitutionsDisabledBtn.f_93624_ = false;
            this.fluidSubstitutionsEnabledBtn.f_93624_ = false;
            this.fluidSubstitutionsDisabledBtn.f_93624_ = false;
        }
        this.cycleProcessingOutputBtn.f_93624_ = ((PatternEncodingTermMenu)this.f_97732_).canCycleProcessingOutputs();
        this.setSlotsHidden(SlotSemantics.CRAFTING_RESULT, mode != EncodingMode.CRAFTING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_PRIMARY_RESULT, mode != EncodingMode.PROCESSING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_FIRST_OPTIONAL_RESULT, mode != EncodingMode.PROCESSING);
        this.setSlotsHidden(SlotSemantics.PROCESSING_SECOND_OPTIONAL_RESULT, mode != EncodingMode.PROCESSING);
        this.widgets.setTooltipAreaEnabled("processing-primary-output", mode == EncodingMode.PROCESSING);
        this.widgets.setTooltipAreaEnabled("processing-optional-output1", mode == EncodingMode.PROCESSING);
        this.widgets.setTooltipAreaEnabled("processing-optional-output2", mode == EncodingMode.PROCESSING);
    }

    @Override
    public void drawBG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(poseStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        EncodingMode mode = ((PatternEncodingTermMenu)this.f_97732_).getMode();
        Blitter modeBg = mode == EncodingMode.CRAFTING ? CRAFTING_MODE_BG : PROCESSING_MODE_BG;
        modeBg.dest(this.f_97735_ + 9, this.f_97736_ + this.f_97727_ - 164).blit(poseStack, this.m_93252_());
        if (mode == EncodingMode.CRAFTING && ((PatternEncodingTermMenu)this.f_97732_).substituteFluids && this.fluidSubstitutionsEnabledBtn.m_5953_(mouseX, mouseY)) {
            for (Integer slotIndex : ((PatternEncodingTermMenu)this.f_97732_).slotsSupportingFluidSubstitution) {
                this.drawSlotGreenBG(poseStack, ((PatternEncodingTermMenu)this.f_97732_).getCraftingGridSlots()[slotIndex]);
            }
        }
    }

    private void drawSlotGreenBG(PoseStack poseStack, Slot slot) {
        int x = this.getGuiLeft() + slot.f_40220_;
        int y = this.getGuiTop() + slot.f_40221_;
        PatternEncodingTermScreen.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)0x7F00FF00);
    }

    @Override
    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        Slot slot;
        if (this.f_96541_.f_91066_.f_92097_.m_90830_(btn) && ((PatternEncodingTermMenu)this.f_97732_).canModifyAmountForSlot(slot = this.m_97744_(xCoord, yCoord))) {
            ((PatternEncodingTermMenu)this.f_97732_).showModifyAmountMenu(slot.f_40219_);
            return true;
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    @Override
    protected void m_6597_(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof PatternTermSlot) {
            if (!slot.m_7993_().m_41619_()) {
                PatternSlotPacket packet = new PatternSlotPacket(((PatternEncodingTermMenu)this.f_97732_).getCraftingMatrix(), slot.m_7993_(), PatternEncodingTermScreen.m_96638_());
                NetworkHandler.instance().sendToServer(packet);
            }
            return;
        }
        super.m_6597_(slot, slotIdx, mouseButton, clickType);
    }

    @Override
    protected void m_7025_(PoseStack poseStack, int x, int y) {
        if (((PatternEncodingTermMenu)this.f_97732_).m_142621_().m_41619_() && ((PatternEncodingTermMenu)this.f_97732_).canModifyAmountForSlot(this.f_97734_)) {
            ArrayList<Component> itemTooltip = new ArrayList<Component>(this.m_96555_(this.f_97734_.m_7993_()));
            GenericStack unwrapped = GenericStack.fromItemStack(this.f_97734_.m_7993_());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip(ButtonToolTips.Amount, unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(poseStack, x, y, itemTooltip);
        } else {
            super.m_7025_(poseStack, x, y);
        }
    }

    @Override
    protected EmptyingAction getEmptyingAction(Slot slot, ItemStack carried) {
        EmptyingAction emptyingAction;
        if (((PatternEncodingTermMenu)this.f_97732_).isProcessingPatternSlot(slot) && (emptyingAction = StackInteractions.getEmptyingAction(carried)) != null) {
            return emptyingAction;
        }
        return super.getEmptyingAction(slot, carried);
    }
}

