/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.Tooltip;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.TooltipArea;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.BackgroundPanel;
import appeng.client.gui.widgets.IResizableWidget;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.TabButton;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.menu.implementations.PriorityMenu;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;

public class WidgetContainer {
    private final ScreenStyle style;
    private final Map<String, AbstractWidget> widgets = new LinkedHashMap<String, AbstractWidget>();
    private final Map<String, ICompositeWidget> compositeWidgets = new LinkedHashMap<String, ICompositeWidget>();
    private final Map<String, ResolvedTooltipArea> tooltips = new LinkedHashMap<String, ResolvedTooltipArea>();

    public WidgetContainer(ScreenStyle style) {
        this.style = style;
    }

    public void add(String id, AbstractWidget widget) {
        int height;
        Preconditions.checkState((!this.compositeWidgets.containsKey(id) ? 1 : 0) != 0, (String)"%s already used for composite widget", (Object)id);
        WidgetStyle widgetStyle = this.style.getWidget(id);
        int width = widgetStyle.getWidth() != 0 ? widgetStyle.getWidth() : widget.m_5711_();
        int n = height = widgetStyle.getHeight() != 0 ? widgetStyle.getHeight() : widget.m_93694_();
        if (widget instanceof IResizableWidget) {
            IResizableWidget resizableWidget = (IResizableWidget)widget;
            resizableWidget.resize(width, height);
        } else {
            widget.m_93674_(width);
            widget.setHeight(height);
        }
        if (widget instanceof TabButton) {
            ((TabButton)widget).setHideEdge(widgetStyle.isHideEdge());
        }
        if (this.widgets.put(id, widget) != null) {
            throw new IllegalStateException("Duplicate id: " + id);
        }
    }

    public void add(String id, ICompositeWidget widget) {
        Preconditions.checkState((!this.widgets.containsKey(id) ? 1 : 0) != 0, (String)"%s already used for widget", (Object)id);
        WidgetStyle widgetStyle = this.style.getWidget(id);
        widget.setSize(widgetStyle.getWidth(), widgetStyle.getHeight());
        if (this.compositeWidgets.put(id, widget) != null) {
            throw new IllegalStateException("Duplicate id: " + id);
        }
    }

    public Button addButton(String id, Component text, Button.OnPress action, Button.OnTooltip tooltip) {
        Button button = new Button(0, 0, 0, 0, text, action, tooltip);
        this.add(id, (AbstractWidget)button);
        return button;
    }

    public Button addButton(String id, Component text, Button.OnPress action) {
        return this.addButton(id, text, action, Button.f_93716_);
    }

    public Button addButton(String id, Component text, Runnable action, Button.OnTooltip tooltip) {
        return this.addButton(id, text, btn -> action.run(), tooltip);
    }

    public Button addButton(String id, Component text, Runnable action) {
        return this.addButton(id, text, action, Button.f_93716_);
    }

    public Scrollbar addScrollBar(String id) {
        Scrollbar scrollbar = new Scrollbar();
        this.add(id, scrollbar);
        return scrollbar;
    }

    public void addBackgroundPanel(String id) {
        Blitter background = this.style.getImage(id).copy();
        this.add(id, new BackgroundPanel(background));
    }

    void populateScreen(Consumer<AbstractWidget> addWidget, Rect2i bounds, AEBaseScreen<?> screen) {
        for (Map.Entry<String, AbstractWidget> entry : this.widgets.entrySet()) {
            AbstractWidget abstractWidget = entry.getValue();
            if (abstractWidget.m_93696_()) {
                abstractWidget.m_5755_(false);
            }
            WidgetStyle widgetStyle = this.style.getWidget(entry.getKey());
            Point pos = widgetStyle.resolve(bounds);
            if (abstractWidget instanceof IResizableWidget) {
                IResizableWidget resizableWidget = (IResizableWidget)abstractWidget;
                resizableWidget.move(pos);
            } else {
                abstractWidget.f_93620_ = pos.getX();
                abstractWidget.f_93621_ = pos.getY();
            }
            addWidget.accept(abstractWidget);
        }
        Rect2i relativeBounds = new Rect2i(0, 0, bounds.m_110090_(), bounds.m_110091_());
        for (Map.Entry<String, ICompositeWidget> entry : this.compositeWidgets.entrySet()) {
            ICompositeWidget widget = entry.getValue();
            WidgetStyle widgetStyle = this.style.getWidget(entry.getKey());
            widget.setPosition(widgetStyle.resolve(relativeBounds));
            widget.populateScreen(addWidget, bounds, screen);
        }
        this.tooltips.clear();
        for (Map.Entry<String, Object> entry : this.style.getTooltips().entrySet()) {
            Point pos = ((TooltipArea)entry.getValue()).resolve(relativeBounds);
            Rect2i area = new Rect2i(pos.getX(), pos.getY(), ((TooltipArea)entry.getValue()).getWidth(), ((TooltipArea)entry.getValue()).getHeight());
            this.tooltips.put(entry.getKey(), new ResolvedTooltipArea(area, new Tooltip(((TooltipArea)entry.getValue()).getTooltip())));
        }
    }

    public void tick() {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.tick();
        }
    }

    public void updateBeforeRender() {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.updateBeforeRender();
        }
    }

    public void drawBackgroundLayer(PoseStack poseStack, int zIndex, Rect2i bounds, Point mouse) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.drawBackgroundLayer(poseStack, zIndex, bounds, mouse);
        }
    }

    public void drawForegroundLayer(PoseStack poseStack, int zIndex, Rect2i bounds, Point mouse) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.drawForegroundLayer(poseStack, zIndex, bounds, mouse);
        }
    }

    public boolean onMouseDown(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.wantsAllMouseDownEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseDown(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseUp(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.wantsAllMouseUpEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseUp(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseDrag(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.onMouseDrag(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    boolean onMouseWheel(Point mousePos, double wheelDelta) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!widget.wantsAllMouseWheelEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseWheel(mousePos, wheelDelta)) continue;
            return true;
        }
        return false;
    }

    public void addExclusionZones(List<Rect2i> exclusionZones, Rect2i bounds) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            widget.addExclusionZones(exclusionZones, bounds);
        }
    }

    public void addOpenPriorityButton() {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        this.add("openPriority", (AbstractWidget)new TabButton(Icon.WRENCH, (Component)GuiText.Priority.text(), itemRenderer, btn -> this.openPriorityGui()));
    }

    private void openPriorityGui() {
        NetworkHandler.instance().sendToServer(SwitchGuisPacket.openSubMenu(PriorityMenu.TYPE));
    }

    public void setTooltipAreaEnabled(String id, boolean enabled) {
        ResolvedTooltipArea tooltip = this.tooltips.get(id);
        Preconditions.checkArgument((tooltip != null ? 1 : 0) != 0, (Object)"No tooltip with id '%s' is defined");
        tooltip.enabled = enabled;
    }

    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        for (ICompositeWidget c : this.compositeWidgets.values()) {
            Tooltip tooltip;
            Rect2i bounds = c.getBounds();
            if (mouseX < bounds.m_110085_() || mouseX >= bounds.m_110085_() + bounds.m_110090_() || mouseY < bounds.m_110086_() || mouseY >= bounds.m_110086_() + bounds.m_110091_() || (tooltip = c.getTooltip(mouseX, mouseY)) == null) continue;
            return tooltip;
        }
        for (ResolvedTooltipArea tooltipArea : this.tooltips.values()) {
            if (!tooltipArea.enabled || !WidgetContainer.contains(tooltipArea.area, mouseX, mouseY)) continue;
            return tooltipArea.tooltip;
        }
        return null;
    }

    public boolean hitTest(Point mousePos) {
        for (ICompositeWidget widget : this.compositeWidgets.values()) {
            if (!mousePos.isIn(widget.getBounds())) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(Rect2i area, int mouseX, int mouseY) {
        return mouseX >= area.m_110085_() && mouseX < area.m_110085_() + area.m_110090_() && mouseY >= area.m_110086_() && mouseY < area.m_110086_() + area.m_110091_();
    }

    public AETextField addTextField(String id) {
        AETextField searchField = new AETextField(Minecraft.m_91087_().f_91062_, 0, 0, 0, 0);
        searchField.m_94182_(false);
        searchField.m_94199_(25);
        searchField.m_94202_(0xFFFFFF);
        searchField.setSelectionColor(-16744448);
        searchField.m_94194_(true);
        this.add(id, (AbstractWidget)searchField);
        return searchField;
    }

    private static class ResolvedTooltipArea {
        private final Rect2i area;
        private final Tooltip tooltip;
        private boolean enabled = true;

        public ResolvedTooltipArea(Rect2i area, Tooltip tooltip) {
            this.area = area;
            this.tooltip = tooltip;
        }
    }
}

