/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.google.common.collect.ImmutableMap;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeBlock;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeTileEntity;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NixieTubeRenderer
extends SafeTileEntityRenderer<NixieTubeTileEntity> {
    private Random r = new Random();
    public static final Map<DyeColor, Couple<Integer>> DYE_TABLE = new ImmutableMap.Builder().put((Object)DyeColor.BLACK, Couple.create(4538427, 2170911)).put((Object)DyeColor.RED, Couple.create(11614519, 6498103)).put((Object)DyeColor.GREEN, Couple.create(2132550, 1925189)).put((Object)DyeColor.BROWN, Couple.create(11306332, 6837054)).put((Object)DyeColor.BLUE, Couple.create(5476833, 5262224)).put((Object)DyeColor.GRAY, Couple.create(6121071, 3224888)).put((Object)DyeColor.LIGHT_GRAY, Couple.create(9803419, 0x707070)).put((Object)DyeColor.PURPLE, Couple.create(10441902, 0x63366C)).put((Object)DyeColor.CYAN, Couple.create(4107188, 3962994)).put((Object)DyeColor.PINK, Couple.create(14002379, 12086165)).put((Object)DyeColor.LIME, Couple.create(10739541, 5222767)).put((Object)DyeColor.YELLOW, Couple.create(15128406, 15313961)).put((Object)DyeColor.LIGHT_BLUE, Couple.create(6934226, 5278373)).put((Object)DyeColor.ORANGE, Couple.create(15635014, 14240039)).put((Object)DyeColor.MAGENTA, Couple.create(15753904, 12600456)).put((Object)DyeColor.WHITE, Couple.create(15592165, 0xBBB6B0)).build();

    public NixieTubeRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(NixieTubeTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ms.m_85836_();
        BlockState blockState = te.m_58900_();
        ((TransformStack)TransformStack.cast((PoseStack)ms).centre()).rotateY((double)AngleHelper.horizontalAngle((Direction)blockState.m_61143_((Property)NixieTubeBlock.f_54117_)));
        float height = (Boolean)blockState.m_61143_((Property)NixieTubeBlock.CEILING) != false ? 2.0f : 6.0f;
        float scale = 0.05f;
        Couple<String> s = te.getDisplayedStrings();
        DyeColor color = NixieTubeBlock.colorOf(te.m_58900_());
        ms.m_85836_();
        ms.m_85837_(-0.25, 0.0, 0.0);
        ms.m_85841_(scale, -scale, scale);
        this.drawTube(ms, buffer, (String)s.getFirst(), height, color);
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85837_(0.25, 0.0, 0.0);
        ms.m_85841_(scale, -scale, scale);
        this.drawTube(ms, buffer, (String)s.getSecond(), height, color);
        ms.m_85849_();
        ms.m_85849_();
    }

    private void drawTube(PoseStack ms, MultiBufferSource buffer, String c, float height, DyeColor color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        float charWidth = fontRenderer.m_92895_(c);
        float shadowOffset = 0.5f;
        float flicker = this.r.nextFloat();
        Couple<Integer> couple = DYE_TABLE.get(color);
        int brightColor = (Integer)couple.getFirst();
        int darkColor = (Integer)couple.getSecond();
        int flickeringBrightColor = Color.mixColors(brightColor, darkColor, flicker / 4.0f);
        ms.m_85836_();
        ms.m_85837_((double)((charWidth - shadowOffset) / -2.0f), (double)(-height), 0.0);
        NixieTubeRenderer.drawChar(ms, buffer, c, flickeringBrightColor);
        ms.m_85836_();
        ms.m_85837_((double)shadowOffset, (double)shadowOffset, -0.0625);
        NixieTubeRenderer.drawChar(ms, buffer, c, darkColor);
        ms.m_85849_();
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85841_(-1.0f, 1.0f, 1.0f);
        ms.m_85837_((double)((charWidth - shadowOffset) / -2.0f), (double)(-height), 0.0);
        NixieTubeRenderer.drawChar(ms, buffer, c, darkColor);
        ms.m_85836_();
        ms.m_85837_((double)(-shadowOffset), (double)shadowOffset, -0.0625);
        NixieTubeRenderer.drawChar(ms, buffer, c, Color.mixColors(darkColor, 0, 0.35f));
        ms.m_85849_();
        ms.m_85849_();
    }

    private static void drawChar(PoseStack ms, MultiBufferSource buffer, String c, int color) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        fontRenderer.m_92811_(c, 0.0f, 0.0f, color, false, ms.m_85850_().m_85861_(), buffer, false, 0, 0xF000F0);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            BakedGlyph texturedglyph = fontRenderer.m_92863_(Style.f_131100_).m_95064_();
            ((MultiBufferSource.BufferSource)buffer).m_109912_(texturedglyph.m_181387_(Font.DisplayMode.NORMAL));
        }
    }
}

