/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.curiosities.armor.BackTankUtil;
import com.simibubi.create.content.curiosities.weapons.BuiltinPotatoProjectileTypes;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonItemRenderer;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonPacket;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonProjectileType;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileEntity;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileTypeManager;
import com.simibubi.create.content.curiosities.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;

public class PotatoCannonItem
extends ProjectileWeaponItem {
    public static ItemStack CLIENT_CURRENT_AMMO = ItemStack.f_41583_;
    public static final int MAX_DAMAGE = 100;

    public PotatoCannonItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44988_) {
            return true;
        }
        if (enchantment == Enchantments.f_44989_) {
            return true;
        }
        if (enchantment == Enchantments.f_44990_) {
            return true;
        }
        if (enchantment == Enchantments.f_44982_) {
            return true;
        }
        if (enchantment == AllEnchantments.POTATO_RECOVERY.get()) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean m_142522_(ItemStack stack) {
        return BackTankUtil.isBarVisible(stack, this.maxUses());
    }

    public int m_142158_(ItemStack stack) {
        return BackTankUtil.getBarWidth(stack, this.maxUses());
    }

    public int m_142159_(ItemStack stack) {
        return BackTankUtil.getBarColor(stack, this.maxUses());
    }

    private int maxUses() {
        return (Integer)AllConfigs.SERVER.curiosities.maxPotatoCannonShots.get();
    }

    public boolean m_41465_() {
        return true;
    }

    public boolean isCannon(ItemStack stack) {
        return stack.m_41720_() instanceof PotatoCannonItem;
    }

    public int getMaxDamage(ItemStack stack) {
        return 100;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return this.findAmmoInInventory(world, player, stack).map(itemStack -> {
            if (ShootableGadgetItemMethods.shouldSwap(player, stack, hand, this::isCannon)) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (world.f_46443_) {
                CreateClient.POTATO_CANNON_RENDER_HANDLER.dontAnimateItem(hand);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == InteractionHand.MAIN_HAND, new Vec3(0.75, (double)-0.15f, 1.5));
            Vec3 correction = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == InteractionHand.MAIN_HAND, new Vec3((double)-0.05f, 0.0, 0.0)).m_82546_(player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0));
            PotatoCannonProjectileType projectileType = PotatoProjectileTypeManager.getTypeForStack(itemStack).orElse(BuiltinPotatoProjectileTypes.FALLBACK);
            Vec3 lookVec = player.m_20154_();
            Vec3 motion = lookVec.m_82549_(correction).m_82541_().m_82490_((double)projectileType.getVelocityMultiplier());
            float soundPitch = projectileType.getSoundPitch() + (Create.RANDOM.nextFloat() - 0.5f) / 4.0f;
            boolean spray = projectileType.getSplit() > 1;
            Vec3 sprayBase = VecHelper.rotate(new Vec3(0.0, 0.1, 0.0), 360.0f * Create.RANDOM.nextFloat(), Direction.Axis.Z);
            float sprayChange = 360.0f / (float)projectileType.getSplit();
            for (int i = 0; i < projectileType.getSplit(); ++i) {
                PotatoProjectileEntity projectile = AllEntityTypes.POTATO_PROJECTILE.create(world);
                projectile.setItem((ItemStack)itemStack);
                projectile.setEnchantmentEffectsFromCannon(stack);
                Vec3 splitMotion = motion;
                if (spray) {
                    float imperfection = 40.0f * (Create.RANDOM.nextFloat() - 0.5f);
                    Vec3 sprayOffset = VecHelper.rotate(sprayBase, (float)i * sprayChange + imperfection, Direction.Axis.Z);
                    splitMotion = splitMotion.m_82549_(VecHelper.lookAt(sprayOffset, motion));
                }
                if (i != 0) {
                    projectile.recoveryChance = 0.0f;
                }
                projectile.m_6034_(barrelPos.f_82479_, barrelPos.f_82480_, barrelPos.f_82481_);
                projectile.m_20256_(splitMotion);
                projectile.m_5602_((Entity)player);
                world.m_7967_((Entity)projectile);
            }
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
                if (itemStack.m_41619_()) {
                    player.m_150109_().m_36057_(itemStack);
                }
            }
            if (!BackTankUtil.canAbsorbDamage((LivingEntity)player, this.maxUses())) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            Integer cooldown = this.findAmmoInInventory(world, player, stack).flatMap(PotatoProjectileTypeManager::getTypeForStack).map(PotatoCannonProjectileType::getReloadTicks).orElse(10);
            ShootableGadgetItemMethods.applyCooldown(player, stack, hand, this::isCannon, cooldown);
            ShootableGadgetItemMethods.sendPackets(player, b -> new PotatoCannonPacket(barrelPos, lookVec.m_82541_(), (ItemStack)itemStack, hand, soundPitch, (boolean)b));
            return InteractionResultHolder.m_19090_((Object)stack);
        }).orElse(InteractionResultHolder.m_19098_((Object)stack));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.m_41720_() != oldStack.m_41720_();
    }

    private Optional<ItemStack> findAmmoInInventory(Level world, Player player, ItemStack held) {
        ItemStack findAmmo = player.m_6298_(held);
        return PotatoProjectileTypeManager.getTypeForStack(findAmmo).map($ -> findAmmo);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<ItemStack> getAmmoforPreview(ItemStack cannon) {
        if (AnimationTickHolder.getTicks() % 3 != 0) {
            return Optional.of(CLIENT_CURRENT_AMMO).filter(stack -> !stack.m_41619_());
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        CLIENT_CURRENT_AMMO = ItemStack.f_41583_;
        if (player == null) {
            return Optional.empty();
        }
        ItemStack findAmmo = player.m_6298_(cannon);
        Optional<ItemStack> found = PotatoProjectileTypeManager.getTypeForStack(findAmmo).map($ -> findAmmo);
        found.ifPresent(stack -> {
            CLIENT_CURRENT_AMMO = stack;
        });
        return found;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        int power = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        int punch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
        float additionalDamageMult = 1.0f + (float)power * 0.2f;
        float additionalKnockback = (float)punch * 0.5f;
        PotatoCannonItem.getAmmoforPreview(stack).ifPresent(ammo -> {
            String _attack = "potato_cannon.ammo.attack_damage";
            String _reload = "potato_cannon.ammo.reload_ticks";
            String _knockback = "potato_cannon.ammo.knockback";
            tooltip.add((Component)new TextComponent(""));
            tooltip.add((Component)new TranslatableComponent(ammo.m_41778_()).m_7220_((Component)new TextComponent(":")).m_130940_(ChatFormatting.GRAY));
            PotatoCannonProjectileType type = PotatoProjectileTypeManager.getTypeForStack(ammo).get();
            TextComponent spacing = new TextComponent(" ");
            ChatFormatting green = ChatFormatting.GREEN;
            ChatFormatting darkGreen = ChatFormatting.DARK_GREEN;
            float damageF = (float)type.getDamage() * additionalDamageMult;
            TextComponent damage = new TextComponent(damageF == (float)Mth.m_14143_((float)damageF) ? "" + Mth.m_14143_((float)damageF) : "" + damageF);
            TextComponent reloadTicks = new TextComponent("" + type.getReloadTicks());
            TextComponent knockback = new TextComponent("" + (type.getKnockback() + additionalKnockback));
            damage = damage.m_130940_(additionalDamageMult > 1.0f ? green : darkGreen);
            knockback = knockback.m_130940_(additionalKnockback > 0.0f ? green : darkGreen);
            reloadTicks = reloadTicks.m_130940_(darkGreen);
            tooltip.add((Component)spacing.m_6879_().m_7220_((Component)Lang.translate(_attack, damage).m_130940_(darkGreen)));
            tooltip.add((Component)spacing.m_6879_().m_7220_((Component)Lang.translate(_reload, reloadTicks).m_130940_(darkGreen)));
            tooltip.add((Component)spacing.m_6879_().m_7220_((Component)Lang.translate(_knockback, knockback).m_130940_(darkGreen)));
        });
        super.m_7373_(stack, world, tooltip, flag);
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> PotatoProjectileTypeManager.getTypeForStack(stack).isPresent();
    }

    public int m_6473_() {
        return 1;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_6615_() {
        return 15;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(SimpleCustomRenderer.create((Item)this, new PotatoCannonItemRenderer()));
    }
}

