/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.content.curiosities.symmetry.ConfigureSymmetryWandPacket;
import com.simibubi.create.content.curiosities.symmetry.SymmetryWandItem;
import com.simibubi.create.content.curiosities.symmetry.mirror.CrossPlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.PlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.TriplePlaneMirror;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SymmetryWandScreen
extends AbstractSimiScreen {
    private AllGuiTextures background;
    private ScrollInput areaType;
    private Label labelType;
    private ScrollInput areaAlign;
    private Label labelAlign;
    private IconButton confirmButton;
    private final Component mirrorType = Lang.translate("gui.symmetryWand.mirrorType", new Object[0]);
    private final Component orientation = Lang.translate("gui.symmetryWand.orientation", new Object[0]);
    private SymmetryMirror currentElement;
    private ItemStack wand;
    private InteractionHand hand;

    public SymmetryWandScreen(ItemStack wand, InteractionHand hand) {
        this.background = AllGuiTextures.WAND_OF_SYMMETRY;
        this.currentElement = SymmetryWandItem.getMirror(wand);
        if (this.currentElement instanceof EmptyMirror) {
            this.currentElement = new PlaneMirror(Vec3.f_82478_);
        }
        this.hand = hand;
        this.wand = wand;
    }

    @Override
    public void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-20, 0);
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.labelType = new Label(x + 49, y + 28, TextComponent.f_131282_).colored(-1).withShadow();
        this.labelAlign = new Label(x + 49, y + 50, TextComponent.f_131282_).colored(-1).withShadow();
        int state = this.currentElement instanceof TriplePlaneMirror ? 2 : (this.currentElement instanceof CrossPlaneMirror ? 1 : 0);
        this.areaType = new SelectionScrollInput(x + 45, y + 21, 109, 18).forOptions(SymmetryMirror.getMirrors()).titled(this.mirrorType.m_6879_()).writingTo(this.labelType).setState(state);
        this.areaType.calling(position -> {
            switch (position) {
                case 0: {
                    this.currentElement = new PlaneMirror(this.currentElement.getPosition());
                    break;
                }
                case 1: {
                    this.currentElement = new CrossPlaneMirror(this.currentElement.getPosition());
                    break;
                }
                case 2: {
                    this.currentElement = new TriplePlaneMirror(this.currentElement.getPosition());
                    break;
                }
            }
            this.initAlign(this.currentElement, x, y);
        });
        this.initAlign(this.currentElement, x, y);
        this.m_142416_(this.labelAlign);
        this.m_142416_(this.areaType);
        this.m_142416_(this.labelType);
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.m_7379_());
        this.m_142416_(this.confirmButton);
    }

    private void initAlign(SymmetryMirror element, int x, int y) {
        if (this.areaAlign != null) {
            this.m_169411_(this.areaAlign);
        }
        this.areaAlign = new SelectionScrollInput(x + 45, y + 43, 109, 18).forOptions(element.getAlignToolTips()).titled(this.orientation.m_6879_()).writingTo(this.labelAlign).setState(element.getOrientationIndex()).calling(element::setOrientation);
        this.m_142416_(this.areaAlign);
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(ms, x, y, (GuiComponent)this);
        this.f_96547_.m_92889_(ms, this.wand.m_41786_(), (float)(x + 11), (float)(y + 4), 7026690);
        this.renderBlock(ms, x, y);
        ((RenderElement)GuiGameElement.of(this.wand).scale(4.0).rotate(-70.0, 20.0, 20.0).at(x + 178, y + 448, -150.0f)).render(ms);
    }

    protected void renderBlock(PoseStack ms, int x, int y) {
        ms.m_85836_();
        ms.m_85837_((double)(x + 26), (double)(y + 39), 20.0);
        ms.m_85841_(16.0f, 16.0f, 16.0f);
        ms.m_85845_(new Vector3f(0.3f, 1.0f, 0.0f).m_122240_(-22.5f));
        this.currentElement.applyModelTransform(ms);
        GuiGameElement.of(this.currentElement.getModel()).render(ms);
        ms.m_85849_();
    }

    public void m_7861_() {
        SymmetryWandItem.configureSettings(this.wand, this.currentElement);
        AllPackets.channel.sendToServer((Object)new ConfigureSymmetryWandPacket(this.hand, this.currentElement));
    }
}

