/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.gantry;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.gantry.GantryCarriageRenderer;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class GantryCarriageInstance
extends ShaftInstance
implements DynamicInstance {
    private final ModelData gantryCogs;
    final Direction facing;
    final Boolean alongFirst;
    final Direction.Axis rotationAxis;
    final float rotationMult;
    final BlockPos visualPos;
    private float lastAngle = Float.NaN;

    public GantryCarriageInstance(MaterialManager dispatcher, KineticTileEntity tile) {
        super(dispatcher, tile);
        this.gantryCogs = (ModelData)this.getTransformMaterial().getModel(AllBlockPartials.GANTRY_COGS, this.blockState).createInstance();
        this.facing = (Direction)this.blockState.m_61143_((Property)GantryCarriageBlock.FACING);
        this.alongFirst = (Boolean)this.blockState.m_61143_((Property)GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        this.rotationAxis = KineticTileEntityRenderer.getRotationAxisOf(tile);
        this.rotationMult = GantryCarriageInstance.getRotationMultiplier(this.getGantryAxis(), this.facing);
        this.visualPos = this.facing.m_122421_() == Direction.AxisDirection.POSITIVE ? tile.m_58899_() : tile.m_58899_().m_142300_(this.facing.m_122424_());
        this.animateCogs(this.getCogAngle());
    }

    public void beginFrame() {
        float cogAngle = this.getCogAngle();
        if (Mth.m_14033_((float)cogAngle, (float)this.lastAngle)) {
            return;
        }
        this.animateCogs(cogAngle);
    }

    private float getCogAngle() {
        return GantryCarriageRenderer.getAngleForTe((KineticTileEntity)this.blockEntity, this.visualPos, this.rotationAxis) * this.rotationMult;
    }

    private void animateCogs(float cogAngle) {
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.gantryCogs.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY((double)AngleHelper.horizontalAngle(this.facing))).rotateX(this.facing == Direction.UP ? 0.0 : (this.facing == Direction.DOWN ? 180.0 : 90.0))).rotateY(this.alongFirst ^ this.facing.m_122434_() == Direction.Axis.X ? 0.0 : 90.0)).translate(0.0, -0.5625, 0.0).rotateX((double)(-cogAngle))).translate(0.0, 0.5625, 0.0).unCentre();
    }

    static float getRotationMultiplier(Direction.Axis gantryAxis, Direction facing) {
        float multiplier = 1.0f;
        if (gantryAxis == Direction.Axis.X && facing == Direction.UP) {
            multiplier *= -1.0f;
        }
        if (gantryAxis == Direction.Axis.Y && (facing == Direction.NORTH || facing == Direction.EAST)) {
            multiplier *= -1.0f;
        }
        return multiplier;
    }

    private Direction.Axis getGantryAxis() {
        Direction.Axis gantryAxis = Direction.Axis.X;
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == this.rotationAxis || axis == this.facing.m_122434_()) continue;
            gantryAxis = axis;
        }
        return gantryAxis;
    }

    @Override
    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.gantryCogs, this.rotatingModel});
    }

    @Override
    public void remove() {
        super.remove();
        this.gantryCogs.delete();
    }
}

