/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel;

import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.foundation.utility.animation.InterpolatedChasingValue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class FlywheelTileEntity
extends GeneratingKineticTileEntity {
    private float generatedCapacity;
    private float generatedSpeed;
    private int stoppingCooldown;
    InterpolatedChasingValue visualSpeed = new InterpolatedChasingValue();
    float angle;

    public FlywheelTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setRotation(float speed, float capacity) {
        if (this.generatedSpeed != speed || this.generatedCapacity != capacity) {
            if (speed == 0.0f) {
                if (this.stoppingCooldown == 0) {
                    this.stoppingCooldown = 40;
                }
                return;
            }
            this.stoppingCooldown = 0;
            this.generatedSpeed = speed;
            this.generatedCapacity = capacity;
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        return FlywheelTileEntity.convertToDirection(this.generatedSpeed, (Direction)this.m_58900_().m_61143_(FlywheelBlock.HORIZONTAL_FACING));
    }

    @Override
    public float calculateAddedStressCapacity() {
        this.lastCapacityProvided = this.generatedCapacity;
        return this.lastCapacityProvided;
    }

    @Override
    public AABB makeRenderBoundingBox() {
        return super.makeRenderBoundingBox().m_82400_(2.0);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128350_("GeneratedSpeed", this.generatedSpeed);
        compound.m_128350_("GeneratedCapacity", this.generatedCapacity);
        compound.m_128405_("Cooldown", this.stoppingCooldown);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.generatedSpeed = compound.m_128457_("GeneratedSpeed");
        this.generatedCapacity = compound.m_128457_("GeneratedCapacity");
        this.stoppingCooldown = compound.m_128451_("Cooldown");
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.visualSpeed.withSpeed(0.03125f).target(this.getGeneratedSpeed());
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            float targetSpeed = this.isVirtual() ? this.speed : this.getGeneratedSpeed();
            this.visualSpeed.target(targetSpeed);
            this.visualSpeed.tick();
            this.angle += this.visualSpeed.value * 3.0f / 10.0f;
            this.angle %= 360.0f;
            return;
        }
        if (this.getGeneratedSpeed() != 0.0f && this.getSpeed() == 0.0f) {
            this.updateGeneratedRotation();
        }
        if (this.stoppingCooldown == 0) {
            return;
        }
        --this.stoppingCooldown;
        if (this.stoppingCooldown == 0) {
            this.generatedCapacity = 0.0f;
            this.generatedSpeed = 0.0f;
            this.updateGeneratedRotation();
        }
    }
}

