/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedDefaultDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.SimplePos;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public abstract class MovedProjectileDispenserBehaviour
extends MovedDefaultDispenseItemBehaviour {
    @Override
    protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3 facing) {
        double z;
        double y;
        double x = (double)pos.m_123341_() + facing.f_82479_ * 0.7 + 0.5;
        Projectile ProjectileEntity = this.getProjectileEntity(context.world, x, y = (double)pos.m_123342_() + facing.f_82480_ * 0.7 + 0.5, z = (double)pos.m_123343_() + facing.f_82481_ * 0.7 + 0.5, itemStack.m_41777_());
        if (ProjectileEntity == null) {
            return itemStack;
        }
        Vec3 effectiveMovementVec = facing.m_82490_((double)this.getProjectileVelocity()).m_82549_(context.motion);
        ProjectileEntity.m_6686_(effectiveMovementVec.f_82479_, effectiveMovementVec.f_82480_, effectiveMovementVec.f_82481_, (float)effectiveMovementVec.m_82553_(), this.getProjectileInaccuracy());
        context.world.m_7967_((Entity)ProjectileEntity);
        itemStack.m_41774_(1);
        return itemStack;
    }

    @Override
    protected void playDispenseSound(LevelAccessor world, BlockPos pos) {
        world.m_46796_(1002, pos, 0);
    }

    @Nullable
    protected abstract Projectile getProjectileEntity(Level var1, double var2, double var4, double var6, ItemStack var8);

    protected float getProjectileInaccuracy() {
        return 6.0f;
    }

    protected float getProjectileVelocity() {
        return 1.1f;
    }

    public static MovedProjectileDispenserBehaviour of(final AbstractProjectileDispenseBehavior vanillaBehaviour) {
        return new MovedProjectileDispenserBehaviour(){

            @Override
            protected Projectile getProjectileEntity(Level world, double x, double y, double z, ItemStack itemStack) {
                try {
                    return (Projectile)MovedProjectileDispenserBehaviour.getProjectileEntityLookup().invoke((Object)vanillaBehaviour, world, new SimplePos(x, y, z), itemStack);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }

            @Override
            protected float getProjectileInaccuracy() {
                try {
                    return ((Float)MovedProjectileDispenserBehaviour.getProjectileInaccuracyLookup().invoke((Object)vanillaBehaviour, new Object[0])).floatValue();
                }
                catch (Throwable throwable) {
                    return super.getProjectileInaccuracy();
                }
            }

            @Override
            protected float getProjectileVelocity() {
                try {
                    return ((Float)MovedProjectileDispenserBehaviour.getProjectileVelocityLookup().invoke((Object)vanillaBehaviour, new Object[0])).floatValue();
                }
                catch (Throwable throwable) {
                    return super.getProjectileVelocity();
                }
            }
        };
    }

    private static Method getProjectileEntityLookup() {
        Method getProjectileEntity = ObfuscationReflectionHelper.findMethod(AbstractProjectileDispenseBehavior.class, (String)"m_6895_", (Class[])new Class[]{Level.class, Position.class, ItemStack.class});
        getProjectileEntity.setAccessible(true);
        return getProjectileEntity;
    }

    private static Method getProjectileInaccuracyLookup() {
        Method getProjectileInaccuracy = ObfuscationReflectionHelper.findMethod(AbstractProjectileDispenseBehavior.class, (String)"m_7101_", (Class[])new Class[0]);
        getProjectileInaccuracy.setAccessible(true);
        return getProjectileInaccuracy;
    }

    private static Method getProjectileVelocityLookup() {
        Method getProjectileVelocity = ObfuscationReflectionHelper.findMethod(AbstractProjectileDispenseBehavior.class, (String)"m_7104_", (Class[])new Class[0]);
        getProjectileVelocity.setAccessible(true);
        return getProjectileVelocity;
    }
}

