/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SequencedAssemblyCategory
extends CreateRecipeCategory<SequencedAssemblyRecipe> {
    Map<ResourceLocation, SequencedAssemblySubCategory> subCategories = new HashMap<ResourceLocation, SequencedAssemblySubCategory>();
    final String[] romans = new String[]{"I", "II", "III", "IV", "V", "VI", "-"};

    public SequencedAssemblyCategory() {
        super(SequencedAssemblyCategory.itemIcon((ItemLike)AllItems.PRECISION_MECHANISM.get()), new EmptyBackground(180, 115));
    }

    public Class<? extends SequencedAssemblyRecipe> getRecipeClass() {
        return SequencedAssemblyRecipe.class;
    }

    public void setIngredients(SequencedAssemblyRecipe recipe, IIngredients ingredients) {
        List<Ingredient> assemblyIngredients = this.getAllItemIngredients(recipe);
        List<FluidIngredient> assemblyFluidIngredients = this.getAllFluidIngredients(recipe);
        ingredients.setInputIngredients(assemblyIngredients);
        if (!assemblyFluidIngredients.isEmpty()) {
            ingredients.setInputLists(VanillaTypes.FLUID, assemblyFluidIngredients.stream().map(FluidIngredient::getMatchingFluidStacks).collect(Collectors.toList()));
        }
        ingredients.setOutputs(VanillaTypes.ITEM, (List)ImmutableList.of((Object)recipe.m_8043_(), (Object)recipe.getTransitionalItem()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, SequencedAssemblyRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        int xOffset = recipe.getOutputChance() == 1.0f ? 0 : -7;
        itemStacks.init(0, true, 26 + xOffset, 90);
        itemStacks.set(0, Arrays.asList(recipe.getIngredient().m_43908_()));
        ItemStack result = recipe.m_8043_();
        itemStacks.init(1, false, 131 + xOffset, 90);
        itemStacks.set(1, result);
        int width = 0;
        int margin = 3;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
        }
        int x = (width -= margin) / -2 + this.getBackground().getWidth() / 2;
        int index = 2;
        int fluidIndex = 0;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            SequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
            index += subCategory.addItemIngredients(sequencedRecipe, itemStacks, x, index);
            fluidIndex += subCategory.addFluidIngredients(sequencedRecipe, fluidStacks, x, fluidIndex);
            x += subCategory.getWidth() + margin;
        }
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex != 1) {
                return;
            }
            float chance = recipe.getOutputChance();
            if (chance != 1.0f) {
                tooltip.add(1, Lang.translate("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).m_130940_(ChatFormatting.GOLD));
            }
        });
    }

    private SequencedAssemblySubCategory getSubCategory(SequencedRecipe<?> sequencedRecipe) {
        return this.subCategories.computeIfAbsent(sequencedRecipe.getRecipe().m_7707_().getRegistryName(), rl -> sequencedRecipe.getAsAssemblyRecipe().getJEISubCategory().get().get());
    }

    public void draw(SequencedAssemblyRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 15.0, 0.0);
        boolean singleOutput = recipe.getOutputChance() == 1.0f;
        int xOffset = singleOutput ? 0 : -7;
        AllGuiTextures.JEI_SLOT.render(matrixStack, 26 + xOffset, 75);
        (singleOutput ? AllGuiTextures.JEI_SLOT : AllGuiTextures.JEI_CHANCE_SLOT).render(matrixStack, 131 + xOffset, 75);
        AllGuiTextures.JEI_LONG_ARROW.render(matrixStack, 52 + xOffset, 79);
        if (!singleOutput) {
            AllGuiTextures.JEI_CHANCE_SLOT.render(matrixStack, 150 + xOffset, 75);
            MutableComponent component = new TextComponent("?").m_130940_(ChatFormatting.BOLD);
            font.m_92763_(matrixStack, (Component)component, (float)(font.m_92852_((FormattedText)component) / -2 + 8 + 150 + xOffset), 80.0f, 0xEFEFEF);
        }
        if (recipe.getLoops() > 1) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(15.0, 9.0, 0.0);
            AllIcons.I_SEQ_REPEAT.render(matrixStack, 50 + xOffset, 75);
            TextComponent repeat = new TextComponent("x" + recipe.getLoops());
            font.m_92889_(matrixStack, (Component)repeat, (float)(66 + xOffset), 80.0f, 0x888888);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        int width = 0;
        int margin = 3;
        for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
            width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
        }
        matrixStack.m_85837_((double)((width -= margin) / -2 + this.getBackground().getWidth() / 2), 0.0, 0.0);
        matrixStack.m_85836_();
        List<SequencedRecipe<?>> sequence = recipe.getSequence();
        for (int i = 0; i < sequence.size(); ++i) {
            SequencedRecipe<?> sequencedRecipe = sequence.get(i);
            SequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
            int subWidth = subCategory.getWidth();
            TextComponent component = new TextComponent(this.romans[Math.min(i, 6)]);
            font.m_92889_(matrixStack, (Component)component, (float)(font.m_92852_((FormattedText)component) / -2 + subWidth / 2), 2.0f, 0x888888);
            subCategory.draw(sequencedRecipe, matrixStack, mouseX, mouseY, i);
            matrixStack.m_85837_((double)(subWidth + margin), 0.0, 0.0);
        }
        matrixStack.m_85849_();
    }

    public List<Component> getTooltipStrings(SequencedAssemblyRecipe recipe, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        TranslatableComponent junk = Lang.translate("recipe.assembly.junk", new Object[0]);
        boolean singleOutput = recipe.getOutputChance() == 1.0f;
        boolean willRepeat = recipe.getLoops() > 1;
        int xOffset = -7;
        int minX = 150 + xOffset;
        int maxX = minX + 18;
        int minY = 90;
        int maxY = minY + 18;
        if (!singleOutput && mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
            float chance = recipe.getOutputChance();
            tooltip.add((Component)junk);
            tooltip.add((Component)Lang.translate("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf(100 - (int)(chance * 100.0f))).m_130940_(ChatFormatting.GOLD));
            return tooltip;
        }
        minX = 55 + xOffset;
        maxX = minX + 65;
        minY = 92;
        maxY = minY + 24;
        if (willRepeat && mouseX >= (double)minX && mouseX < (double)maxX && mouseY >= (double)minY && mouseY < (double)maxY) {
            tooltip.add((Component)Lang.translate("recipe.assembly.repeat", recipe.getLoops()));
            return tooltip;
        }
        if (mouseY > 5.0 && mouseY < 84.0) {
            int width = 0;
            int margin = 3;
            for (SequencedRecipe<?> sequencedRecipe : recipe.getSequence()) {
                width += this.getSubCategory(sequencedRecipe).getWidth() + margin;
            }
            xOffset = (width -= margin) / 2 + this.getBackground().getWidth() / -2;
            double relativeX = mouseX + (double)xOffset;
            List<SequencedRecipe<?>> sequence = recipe.getSequence();
            for (int i = 0; i < sequence.size(); ++i) {
                SequencedRecipe<?> sequencedRecipe = sequence.get(i);
                SequencedAssemblySubCategory subCategory = this.getSubCategory(sequencedRecipe);
                if (relativeX >= 0.0 && relativeX < (double)subCategory.getWidth()) {
                    tooltip.add((Component)Lang.translate("recipe.assembly.step", i + 1));
                    tooltip.add((Component)sequencedRecipe.getAsAssemblyRecipe().getDescriptionForAssembly().m_6879_().m_130940_(ChatFormatting.DARK_GREEN));
                    return tooltip;
                }
                relativeX -= (double)(subCategory.getWidth() + margin);
            }
        }
        return tooltip;
    }

    private List<FluidIngredient> getAllFluidIngredients(SequencedAssemblyRecipe recipe) {
        ArrayList<FluidIngredient> assemblyFluidIngredients = new ArrayList<FluidIngredient>();
        recipe.addAdditionalFluidIngredients(assemblyFluidIngredients);
        return assemblyFluidIngredients;
    }

    private List<Ingredient> getAllItemIngredients(SequencedAssemblyRecipe recipe) {
        ArrayList<Ingredient> assemblyIngredients = new ArrayList<Ingredient>();
        assemblyIngredients.add(recipe.getIngredient());
        assemblyIngredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{recipe.getTransitionalItem()}));
        recipe.addAdditionalIngredientsAndMachines(assemblyIngredients);
        return assemblyIngredients;
    }
}

