/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.Engine;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.ParallelTaskEngine;
import com.jozufozu.flywheel.backend.instancing.batching.BatchingEngine;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstanceManager;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstanceManager;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.config.FlwEngine;
import com.jozufozu.flywheel.core.Contexts;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class InstanceWorld {
    protected final Engine engine;
    protected final InstanceManager<Entity> entityInstanceManager;
    protected final InstanceManager<BlockEntity> blockEntityInstanceManager;
    protected final ParallelTaskEngine taskEngine;

    public InstanceWorld(LevelAccessor levelAccessor) {
        Level world = (Level)levelAccessor;
        this.taskEngine = new ParallelTaskEngine("Flywheel " + world.m_46472_().m_135782_());
        this.taskEngine.startWorkers();
        FlwEngine engine = Backend.getEngine();
        switch (engine) {
            case INSTANCING: {
                InstancingEngine<WorldProgram> manager = InstancingEngine.builder(Contexts.WORLD).build();
                this.entityInstanceManager = new EntityInstanceManager(manager);
                this.blockEntityInstanceManager = new BlockEntityInstanceManager(manager);
                manager.addListener(this.entityInstanceManager);
                manager.addListener(this.blockEntityInstanceManager);
                this.engine = manager;
                break;
            }
            case BATCHING: {
                this.engine = new BatchingEngine();
                this.entityInstanceManager = new EntityInstanceManager(this.engine);
                this.blockEntityInstanceManager = new BlockEntityInstanceManager(this.engine);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown engine type");
            }
        }
    }

    public InstanceManager<Entity> getEntityInstanceManager() {
        return this.entityInstanceManager;
    }

    public InstanceManager<BlockEntity> getBlockEntityInstanceManager() {
        return this.blockEntityInstanceManager;
    }

    public void delete() {
        this.taskEngine.stopWorkers();
        this.engine.delete();
        this.entityInstanceManager.detachLightListeners();
        this.blockEntityInstanceManager.detachLightListeners();
    }

    public void beginFrame(BeginFrameEvent event) {
        this.engine.beginFrame(event.getCamera());
        this.taskEngine.syncPoint();
        this.blockEntityInstanceManager.beginFrame(this.taskEngine, event.getCamera());
        this.entityInstanceManager.beginFrame(this.taskEngine, event.getCamera());
    }

    public void tick() {
        Entity renderViewEntity;
        Minecraft mc = Minecraft.m_91087_();
        Object object = renderViewEntity = mc.f_91075_ != null ? mc.f_91075_ : mc.f_91074_;
        if (renderViewEntity == null) {
            return;
        }
        this.blockEntityInstanceManager.tick(this.taskEngine, renderViewEntity.m_20185_(), renderViewEntity.m_20186_(), renderViewEntity.m_20189_());
        this.entityInstanceManager.tick(this.taskEngine, renderViewEntity.m_20185_(), renderViewEntity.m_20186_(), renderViewEntity.m_20189_());
    }

    public void renderLayer(RenderLayerEvent event) {
        this.taskEngine.syncPoint();
        event.stack.m_85836_();
        event.stack.m_85837_(-event.camX, -event.camY, -event.camZ);
        this.engine.render(this.taskEngine, event);
        event.stack.m_85849_();
    }

    public void loadEntities(ClientLevel world) {
        world.m_104735_().forEach(this.entityInstanceManager::add);
    }
}

