/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.InitializationData;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class ClientVoicechatConnection
extends Thread {
    private ClientVoicechat client;
    private final InitializationData data;
    private final DatagramSocket socket;
    private final InetAddress address;
    private boolean running;
    private boolean authenticated;
    private final AuthThread authThread;
    private long lastKeepAlive;

    public ClientVoicechatConnection(ClientVoicechat client, InitializationData data) throws IOException {
        this.client = client;
        this.data = data;
        this.address = InetAddress.getByName(data.getServerIP());
        this.socket = new DatagramSocket();
        this.socket.setTrafficClass(4);
        this.lastKeepAlive = -1L;
        this.running = true;
        this.authThread = new AuthThread();
        this.authThread.start();
        this.setDaemon(true);
        this.setName("VoiceChatConnectionThread");
    }

    public InitializationData getData() {
        return this.data;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public void run() {
        block7: {
            try {
                while (this.running) {
                    NetworkMessage in = NetworkMessage.readPacketClient(this.socket, this);
                    if (in.getPacket() instanceof AuthenticateAckPacket) {
                        if (this.authenticated) continue;
                        Voicechat.LOGGER.info("Server acknowledged authentication");
                        this.authenticated = true;
                        ClientCompatibilityManager.INSTANCE.emitVoiceChatConnectedEvent(this);
                        this.lastKeepAlive = System.currentTimeMillis();
                        continue;
                    }
                    Packet<? extends Packet> packet = in.getPacket();
                    if (packet instanceof SoundPacket) {
                        SoundPacket packet2 = (SoundPacket)packet;
                        this.client.processSoundPacket(packet2);
                        continue;
                    }
                    packet = in.getPacket();
                    if (packet instanceof PingPacket) {
                        PingPacket packet3 = (PingPacket)packet;
                        Voicechat.LOGGER.info("Received ping {}, sending pong...", (Object)packet3.getId());
                        this.sendToServer(new NetworkMessage(packet3));
                        continue;
                    }
                    if (!(in.getPacket() instanceof KeepAlivePacket)) continue;
                    this.lastKeepAlive = System.currentTimeMillis();
                    this.sendToServer(new NetworkMessage(new KeepAlivePacket()));
                }
            }
            catch (InterruptedException in) {
            }
            catch (Exception e) {
                if (!this.running) break block7;
                Voicechat.LOGGER.error("Failed to process packet from server: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void close() {
        Voicechat.LOGGER.info("Disconnecting voicechat");
        this.running = false;
        this.socket.close();
        this.authThread.close();
    }

    public boolean isConnected() {
        return this.running && !this.socket.isClosed();
    }

    public void sendToServer(NetworkMessage message) throws Exception {
        byte[] bytes = message.writeClient(this);
        this.socket.send(new DatagramPacket(bytes, bytes.length, this.address, this.data.getServerPort()));
    }

    public void checkTimeout() {
        if (this.lastKeepAlive >= 0L && System.currentTimeMillis() - this.lastKeepAlive > (long)this.data.getKeepAlive() * 10L) {
            Voicechat.LOGGER.info("Connection timeout");
            ClientCompatibilityManager.INSTANCE.emitVoiceChatDisconnectedEvent();
        }
    }

    private class AuthThread
    extends Thread {
        private boolean running = true;

        public AuthThread() {
            this.setDaemon(true);
            this.setName("VoiceChatAuthenticationThread");
        }

        @Override
        public void run() {
            while (this.running && !ClientVoicechatConnection.this.authenticated) {
                block3: {
                    try {
                        Voicechat.LOGGER.info("Trying to authenticate voice connection");
                        ClientVoicechatConnection.this.sendToServer(new NetworkMessage(new AuthenticatePacket(ClientVoicechatConnection.this.data.getPlayerUUID(), ClientVoicechatConnection.this.data.getSecret())));
                    }
                    catch (Exception e) {
                        if (ClientVoicechatConnection.this.socket.isClosed()) break block3;
                        Voicechat.LOGGER.error("Failed to authenticate voice connection: {}", (Object)e.getMessage());
                    }
                }
                Utils.sleep(1000);
            }
        }

        public void close() {
            this.running = false;
        }
    }
}

