/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.macos;

import de.maxhenkel.voicechat.macos.MacApplication;
import de.maxhenkel.voicechat.macos.Main;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;

public class MacosFrame
extends JFrame
implements DropTargetListener {
    private final JLabel dragText;

    public MacosFrame() {
        System.setProperty("apple.awt.application.appearance", "system");
        System.setProperty("apple.awt.application.name", "Simple Voice Chat");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.setLocationRelativeTo(null);
        this.setMinimumSize(new Dimension(600, 500));
        this.setSize(900, 700);
        this.setTitle("Simple Voice Chat");
        this.setDefaultCloseOperation(2);
        try {
            this.setIconImage(new ImageIcon(this.getClass().getResource("/icon.png")).getImage());
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        Container pane = this.getContentPane();
        JEditorPane ep = new JEditorPane();
        ep.setContentType("text/html");
        ep.setText("<body style=\"font-family: Sans-Serif;\">\n    <h1 style=\"text-align: center;\">Simple Voice Chat MacOS Microphone Permission</h1>\n    <p>\n    Your Minecraft launcher does not allow access to your microphone.\n    </p>\n    <p><b>Please read <a href=\"https://github.com/henkelmax/simple-voice-chat/tree/1.18.1/macos#how-to-patch-your-launcher\">this guide</a> on how to patch your launcher.</b></p>\n    <p>\n    You need to drag your Minecraft launcher from your applications folder onto the area below.\n    Note that this will remove the original signature of your launcher.\n    If you don't trust this, you can take a look at the <a href=\"https://github.com/henkelmax/simple-voice-chat/tree/1.18.1/macos\">source code</a> of this application.\n    </p>\n    <p>\n    Doing this may result in your launcher not working correctly.\n    </p>\n    <p><b>Use at your own risk!</b></p>\n    <p align=\"right\">Version %s</p>\n</body>\n".formatted(Main.getVersion()));
        ep.setEditable(false);
        ep.setBorder(new LineBorder(Color.WHITE, 10));
        ep.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(e.getURL().toURI());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        pane.add((Component)ep, "First");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new LineBorder(Color.WHITE, 10));
        JPanel dragPanel = new JPanel();
        dragPanel.setBorder(BorderFactory.createDashedBorder(Color.BLACK, 3.0f, 5.0f, 5.0f, true));
        dragPanel.setBackground(Color.WHITE);
        dragPanel.setLayout(new BorderLayout());
        this.dragText = new JLabel("Drag the launcher application here");
        this.dragText.setFont(new Font(null, 0, 24));
        this.dragText.setHorizontalAlignment(0);
        this.dragText.setBorder(null);
        dragPanel.add((Component)this.dragText, "Center");
        panel.add((Component)dragPanel, "Center");
        pane.add((Component)panel, "Center");
        this.setVisible(true);
        new DropTarget(this, this);
    }

    public void setApplication(MacApplication application) {
        int result = JOptionPane.showOptionDialog(null, "      Do you really want to patch '%s'?\n      Use at your own risk!\n".formatted(application.getName()), "Patch Application", 1, 3, null, new Object[]{"Yes", "No", "Cancel"}, null);
        if (result != 0) {
            return;
        }
        try {
            application.removeSignature();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            return;
        }
        try {
            application.fixMicrophoneUsageDescription();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            return;
        }
        JOptionPane.showMessageDialog(this, "Successfully patched '%s'.\nPlease restart your game and launcher for this change to take effect.\n".formatted(application.getName()), "Success", 1);
    }

    private void resetDragText() {
        this.dragText.setText("Drag the launcher application here");
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragText.setText("");
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.resetDragText();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor[] flavors;
        Transferable tr = dtde.getTransferable();
        for (DataFlavor flavor : flavors = tr.getTransferDataFlavors()) {
            try {
                if (!flavor.isFlavorJavaFileListType()) continue;
                dtde.acceptDrop(dtde.getDropAction());
                List transferData = (List)tr.getTransferData(flavor);
                Iterator iterator = transferData.iterator();
                if (!iterator.hasNext()) continue;
                File file = (File)iterator.next();
                this.resetDragText();
                try {
                    MacApplication application = new MacApplication(file.toPath());
                    this.setApplication(application);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

