/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.EnterPasswordScreen;
import de.maxhenkel.voicechat.gui.SkinUtils;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.widgets.WidgetBase;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;

public class JoinGroupList
extends WidgetBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_join_group.png");
    private static final ResourceLocation LOCK = new ResourceLocation("voicechat", "textures/icons/lock.png");
    protected int offset;
    private final VoiceChatScreenBase.HoverArea[] hoverAreas;
    private final int columnHeight;
    private final int columnCount;

    public JoinGroupList(VoiceChatScreenBase screen, int posX, int posY, int xSize, int ySize) {
        super(screen, posX, posY, xSize, ySize);
        this.columnHeight = 22;
        this.columnCount = 4;
        this.hoverAreas = new VoiceChatScreenBase.HoverArea[this.columnCount];
        for (int i = 0; i < this.hoverAreas.length; ++i) {
            this.hoverAreas[i] = new VoiceChatScreenBase.HoverArea(0, i * this.columnHeight, xSize, this.columnHeight);
        }
    }

    public List<Group> getGroups() {
        HashMap<UUID, Group> groups = new HashMap<UUID, Group>();
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates(true);
        for (PlayerState state : playerStates) {
            if (!state.hasGroup()) continue;
            Group group = groups.getOrDefault(state.getGroup().getId(), new Group(state.getGroup()));
            group.members.add(state);
            group.members.sort(Comparator.comparing(PlayerState::getName));
            groups.put(state.getGroup().getId(), group);
        }
        return new ArrayList<Group>(groups.values());
    }

    @Override
    public void drawGuiContainerForegroundLayer(PoseStack matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        List<Group> entries = this.getGroups();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            int pos = i - this.getOffset();
            VoiceChatScreenBase.HoverArea hoverArea = this.hoverAreas[pos];
            int startY = this.guiTop + pos * this.columnHeight;
            Group group = entries.get(i);
            boolean hasPassword = group.group.hasPassword();
            if (hasPassword) {
                matrixStack.m_85836_();
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)LOCK);
                Screen.m_93133_((PoseStack)matrixStack, (int)(this.guiLeft + 3), (int)(startY + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                matrixStack.m_85849_();
            }
            TextComponent groupName = new TextComponent(group.group.getName());
            this.mc.f_91062_.m_92889_(matrixStack, (Component)groupName, (float)(this.guiLeft + 3 + (hasPassword ? 19 : 0)), (float)(startY + 7), 0);
            int textWidth = this.mc.f_91062_.m_92852_((FormattedText)groupName) + (hasPassword ? 19 : 0);
            int headsPerRow = (this.xSize - (3 + textWidth + 3 + 3)) / 9;
            for (int j = 0; j < group.members.size(); ++j) {
                PlayerState state = group.members.get(j);
                int headXIndex = j % headsPerRow;
                int headYIndex = j / headsPerRow;
                if (headYIndex > 1) break;
                int headPosX = this.guiLeft + this.xSize - 8 - 2 - headXIndex * 9;
                int headPosY = startY + 2 + 10 - 10 * headYIndex;
                matrixStack.m_85836_();
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)SkinUtils.getSkin(state.getUuid()));
                matrixStack.m_85837_((double)headPosX, (double)headPosY, 0.0);
                Screen.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                Screen.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                matrixStack.m_85849_();
            }
            if (!hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) continue;
            ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
            tooltip.add(new TranslatableComponent("message.voicechat.group_members").m_130940_(ChatFormatting.WHITE).m_7532_());
            for (PlayerState state : group.members) {
                tooltip.add(new TextComponent("- " + state.getName()).m_130940_(ChatFormatting.GRAY).m_7532_());
            }
            this.screen.m_96617_(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        List<Group> entries = this.getGroups();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            int pos = i - this.getOffset();
            VoiceChatScreenBase.HoverArea hoverArea = this.hoverAreas[pos];
            boolean hovered = hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY);
            int startY = this.guiTop + pos * this.columnHeight;
            Group group = entries.get(i);
            if (hovered) {
                Screen.m_93133_((PoseStack)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)39.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
                continue;
            }
            Screen.m_93133_((PoseStack)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)17.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        if (entries.size() > this.columnCount) {
            float h = this.ySize - 17;
            float perc = (float)this.getOffset() / (float)(entries.size() - this.columnCount);
            int posY = this.guiTop + (int)(h * perc);
            Screen.m_93133_((PoseStack)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)posY, (float)195.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        } else {
            Screen.m_93133_((PoseStack)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)this.guiTop, (float)207.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        }
    }

    public int getOffset() {
        List<Group> entries = this.getGroups();
        if (entries.size() <= this.columnCount) {
            this.offset = 0;
        } else if (this.offset > entries.size() - this.columnCount) {
            this.offset = entries.size() - this.columnCount;
        }
        return this.offset;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        List<Group> entries = this.getGroups();
        if (entries.size() > this.columnCount) {
            this.offset = delta < 0.0 ? Math.min(this.getOffset() + 1, entries.size() - this.columnCount) : Math.max(this.getOffset() - 1, 0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<Group> entries = this.getGroups();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < entries.size(); ++i) {
            if (!this.hoverAreas[i].isHovered(this.guiLeft, this.guiTop, (int)mouseX, (int)mouseY)) continue;
            Group group = entries.get(this.getOffset() + i);
            this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            if (group.group.hasPassword()) {
                this.mc.m_91152_((Screen)new EnterPasswordScreen(group.group));
                continue;
            }
            NetManager.sendToServer(new JoinGroupPacket(group.group.getId(), null));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public static class Group {
        private final ClientGroup group;
        private final List<PlayerState> members;

        public Group(ClientGroup group) {
            this.group = group;
            this.members = new ArrayList<PlayerState>();
        }
    }
}

