/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.simibubi.create.content.curiosities.zapper.ShootableGadgetRenderHandler;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public abstract class ShootGadgetPacket
extends SimplePacketBase {
    public Vec3 location;
    public InteractionHand hand;
    public boolean self;

    public ShootGadgetPacket(Vec3 location, InteractionHand hand, boolean self) {
        this.location = location;
        this.hand = hand;
        this.self = self;
    }

    public ShootGadgetPacket(FriendlyByteBuf buffer) {
        this.hand = buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.self = buffer.readBoolean();
        this.location = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.readAdditional(buffer);
    }

    @Override
    public final void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
        buffer.writeBoolean(this.self);
        buffer.writeDouble(this.location.f_82479_);
        buffer.writeDouble(this.location.f_82480_);
        buffer.writeDouble(this.location.f_82481_);
        this.writeAdditional(buffer);
    }

    protected abstract void readAdditional(FriendlyByteBuf var1);

    protected abstract void writeAdditional(FriendlyByteBuf var1);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void handleAdditional();

    @OnlyIn(value=Dist.CLIENT)
    protected abstract ShootableGadgetRenderHandler getHandler();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public final void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity renderViewEntity = Minecraft.m_91087_().m_91288_();
            if (renderViewEntity == null) {
                return;
            }
            if (renderViewEntity.m_20182_().m_82554_(this.location) > 100.0) {
                return;
            }
            ShootableGadgetRenderHandler handler = this.getHandler();
            this.handleAdditional();
            if (this.self) {
                handler.shoot(this.hand, this.location);
            } else {
                handler.playSound(this.hand, this.location);
            }
        });
        context.get().setPacketHandled(true);
    }
}

