/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.actors.AttachedActorBlock;
import com.simibubi.create.content.contraptions.components.actors.HarvesterBlock;
import com.simibubi.create.content.contraptions.components.actors.PloughBlock;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.content.contraptions.components.fan.NozzleBlock;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkBearingTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.SailBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.WindmillBearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.WindmillBearingTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankConnectivityHandler;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkBlock;
import com.simibubi.create.content.logistics.block.vault.ItemVaultBlock;
import com.simibubi.create.content.logistics.block.vault.ItemVaultConnectivityHandler;
import com.simibubi.create.foundation.config.ContraptionMovementSetting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public class BlockMovementChecks {
    private static final List<MovementNecessaryCheck> MOVEMENT_NECESSARY_CHECKS = new ArrayList<MovementNecessaryCheck>();
    private static final List<MovementAllowedCheck> MOVEMENT_ALLOWED_CHECKS = new ArrayList<MovementAllowedCheck>();
    private static final List<BrittleCheck> BRITTLE_CHECKS = new ArrayList<BrittleCheck>();
    private static final List<AttachedCheck> ATTACHED_CHECKS = new ArrayList<AttachedCheck>();
    private static final List<NotSupportiveCheck> NOT_SUPPORTIVE_CHECKS = new ArrayList<NotSupportiveCheck>();
    public static final ResourceLocation NON_MOVABLE = Create.asResource("non_movable");

    public static void registerMovementNecessaryCheck(MovementNecessaryCheck check) {
        MOVEMENT_NECESSARY_CHECKS.add(0, check);
    }

    public static void registerMovementAllowedCheck(MovementAllowedCheck check) {
        MOVEMENT_ALLOWED_CHECKS.add(0, check);
    }

    public static void registerBrittleCheck(BrittleCheck check) {
        BRITTLE_CHECKS.add(0, check);
    }

    public static void registerAttachedCheck(AttachedCheck check) {
        ATTACHED_CHECKS.add(0, check);
    }

    public static void registerNotSupportiveCheck(NotSupportiveCheck check) {
        NOT_SUPPORTIVE_CHECKS.add(0, check);
    }

    public static void registerAllChecks(AllChecks checks) {
        BlockMovementChecks.registerMovementNecessaryCheck(checks);
        BlockMovementChecks.registerMovementAllowedCheck(checks);
        BlockMovementChecks.registerBrittleCheck(checks);
        BlockMovementChecks.registerAttachedCheck(checks);
        BlockMovementChecks.registerNotSupportiveCheck(checks);
    }

    public static boolean isMovementNecessary(BlockState state, Level world, BlockPos pos) {
        for (MovementNecessaryCheck check : MOVEMENT_NECESSARY_CHECKS) {
            CheckResult result = check.isMovementNecessary(state, world, pos);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isMovementNecessaryFallback(state, world, pos);
    }

    public static boolean isMovementAllowed(BlockState state, Level world, BlockPos pos) {
        for (MovementAllowedCheck check : MOVEMENT_ALLOWED_CHECKS) {
            CheckResult result = check.isMovementAllowed(state, world, pos);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isMovementAllowedFallback(state, world, pos);
    }

    public static boolean isBrittle(BlockState state) {
        for (BrittleCheck check : BRITTLE_CHECKS) {
            CheckResult result = check.isBrittle(state);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isBrittleFallback(state);
    }

    public static boolean isBlockAttachedTowards(BlockState state, Level world, BlockPos pos, Direction direction) {
        for (AttachedCheck check : ATTACHED_CHECKS) {
            CheckResult result = check.isBlockAttachedTowards(state, world, pos, direction);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isBlockAttachedTowardsFallback(state, world, pos, direction);
    }

    public static boolean isNotSupportive(BlockState state, Direction facing) {
        for (NotSupportiveCheck check : NOT_SUPPORTIVE_CHECKS) {
            CheckResult result = check.isNotSupportive(state, facing);
            if (result == CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecks.isNotSupportiveFallback(state, facing);
    }

    private static boolean isMovementNecessaryFallback(BlockState state, Level world, BlockPos pos) {
        if (BlockMovementChecks.isBrittle(state)) {
            return true;
        }
        if (state.m_60734_() instanceof FenceGateBlock) {
            return true;
        }
        if (state.m_60767_().m_76336_()) {
            return false;
        }
        return !state.m_60812_((BlockGetter)world, pos).m_83281_();
    }

    private static boolean isMovementAllowedFallback(BlockState state, Level world, BlockPos pos) {
        BlockEntity te;
        Block block = state.m_60734_();
        if (block instanceof AbstractChassisBlock) {
            return true;
        }
        if (state.m_60800_((BlockGetter)world, pos) == -1.0f) {
            return false;
        }
        if (state.m_60734_().getTags().contains(NON_MOVABLE)) {
            return false;
        }
        if (ContraptionMovementSetting.get(state.m_60734_()) == ContraptionMovementSetting.UNMOVABLE) {
            return false;
        }
        if (block instanceof MechanicalPistonBlock && state.m_61143_(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.MOVING) {
            return true;
        }
        if (block instanceof MechanicalBearingBlock && (te = world.m_7702_(pos)) instanceof MechanicalBearingTileEntity) {
            return !((MechanicalBearingTileEntity)te).isRunning();
        }
        if (block instanceof WindmillBearingBlock && (te = world.m_7702_(pos)) instanceof WindmillBearingTileEntity) {
            return !((WindmillBearingTileEntity)te).isRunning();
        }
        if (block instanceof ClockworkBearingBlock && (te = world.m_7702_(pos)) instanceof ClockworkBearingTileEntity) {
            return !((ClockworkBearingTileEntity)te).isRunning();
        }
        if (block instanceof PulleyBlock && (te = world.m_7702_(pos)) instanceof PulleyTileEntity) {
            return !((PulleyTileEntity)te).running;
        }
        if (AllBlocks.BELT.has(state)) {
            return true;
        }
        if (state.m_60734_() instanceof GrindstoneBlock) {
            return true;
        }
        return state.m_60811_() != PushReaction.BLOCK;
    }

    private static boolean isBrittleFallback(BlockState state) {
        Block block = state.m_60734_();
        if (state.m_61138_((Property)BlockStateProperties.f_61435_)) {
            return true;
        }
        if (block instanceof LadderBlock) {
            return true;
        }
        if (block instanceof TorchBlock) {
            return true;
        }
        if (block instanceof SignBlock) {
            return true;
        }
        if (block instanceof BasePressurePlateBlock) {
            return true;
        }
        if (block instanceof FaceAttachedHorizontalDirectionalBlock && !(block instanceof GrindstoneBlock)) {
            return true;
        }
        if (block instanceof CartAssemblerBlock) {
            return false;
        }
        if (block instanceof BaseRailBlock) {
            return true;
        }
        if (block instanceof DiodeBlock) {
            return true;
        }
        if (block instanceof RedStoneWireBlock) {
            return true;
        }
        if (block instanceof WoolCarpetBlock) {
            return true;
        }
        return AllTags.AllBlockTags.BRITTLE.tag.m_8110_((Object)block);
    }

    private static boolean isBlockAttachedTowardsFallback(BlockState state, Level world, BlockPos pos, Direction direction) {
        Block block = state.m_60734_();
        if (block instanceof LadderBlock) {
            return state.m_61143_((Property)LadderBlock.f_54337_) == direction.m_122424_();
        }
        if (block instanceof WallTorchBlock) {
            return state.m_61143_((Property)WallTorchBlock.f_58119_) == direction.m_122424_();
        }
        if (block instanceof WallSignBlock) {
            return state.m_61143_((Property)WallSignBlock.f_58064_) == direction.m_122424_();
        }
        if (block instanceof StandingSignBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof BasePressurePlateBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof DoorBlock) {
            if (state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER && direction == Direction.UP) {
                return true;
            }
            return direction == Direction.DOWN;
        }
        if (block instanceof BedBlock) {
            Direction facing = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
            if (state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
                facing = facing.m_122424_();
            }
            return direction == facing;
        }
        if (block instanceof RedstoneLinkBlock) {
            return direction.m_122424_() == state.m_61143_((Property)RedstoneLinkBlock.f_52588_);
        }
        if (block instanceof FlowerPotBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof DiodeBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedStoneWireBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof WoolCarpetBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedstoneWallTorchBlock) {
            return state.m_61143_((Property)RedstoneWallTorchBlock.f_55740_) == direction.m_122424_();
        }
        if (block instanceof TorchBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof FaceAttachedHorizontalDirectionalBlock) {
            AttachFace attachFace = (AttachFace)state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_);
            if (attachFace == AttachFace.CEILING) {
                return direction == Direction.UP;
            }
            if (attachFace == AttachFace.FLOOR) {
                return direction == Direction.DOWN;
            }
            if (attachFace == AttachFace.WALL) {
                return direction.m_122424_() == state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_54117_);
            }
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61435_)) {
            return direction == ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_) != false ? Direction.UP : Direction.DOWN);
        }
        if (block instanceof BaseRailBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof AttachedActorBlock) {
            return direction == ((Direction)state.m_61143_((Property)HarvesterBlock.f_54117_)).m_122424_();
        }
        if (block instanceof HandCrankBlock) {
            return direction == ((Direction)state.m_61143_((Property)HandCrankBlock.FACING)).m_122424_();
        }
        if (block instanceof NozzleBlock) {
            return direction == ((Direction)state.m_61143_((Property)NozzleBlock.f_52588_)).m_122424_();
        }
        if (block instanceof EngineBlock) {
            return direction == ((Direction)state.m_61143_((Property)EngineBlock.f_54117_)).m_122424_();
        }
        if (block instanceof BellBlock) {
            BellAttachType attachment = (BellAttachType)state.m_61143_((Property)BlockStateProperties.f_61377_);
            if (attachment == BellAttachType.FLOOR) {
                return direction == Direction.DOWN;
            }
            if (attachment == BellAttachType.CEILING) {
                return direction == Direction.UP;
            }
            return direction == state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        }
        if (state.m_60734_() instanceof SailBlock) {
            return direction.m_122434_() != ((Direction)state.m_61143_((Property)SailBlock.f_52588_)).m_122434_();
        }
        if (state.m_60734_() instanceof FluidTankBlock) {
            return FluidTankConnectivityHandler.isConnected((BlockGetter)world, pos, pos.m_142300_(direction));
        }
        if (state.m_60734_() instanceof ItemVaultBlock) {
            return ItemVaultConnectivityHandler.isConnected((BlockGetter)world, pos, pos.m_142300_(direction));
        }
        if (AllBlocks.STICKER.has(state) && ((Boolean)state.m_61143_((Property)StickerBlock.EXTENDED)).booleanValue()) {
            return direction == state.m_61143_((Property)StickerBlock.f_52588_) && !BlockMovementChecks.isNotSupportive(world.m_8055_(pos.m_142300_(direction)), direction.m_122424_());
        }
        return false;
    }

    private static boolean isNotSupportiveFallback(BlockState state, Direction facing) {
        if (AllBlocks.MECHANICAL_DRILL.has(state)) {
            return state.m_61143_((Property)BlockStateProperties.f_61372_) == facing;
        }
        if (AllBlocks.MECHANICAL_BEARING.has(state)) {
            return state.m_61143_((Property)BlockStateProperties.f_61372_) == facing;
        }
        if (AllBlocks.MECHANICAL_HARVESTER.has(state)) {
            return state.m_61143_((Property)HarvesterBlock.f_54117_) == facing;
        }
        if (AllBlocks.MECHANICAL_PLOUGH.has(state)) {
            return state.m_61143_((Property)PloughBlock.f_54117_) == facing;
        }
        if (AllBlocks.CART_ASSEMBLER.has(state)) {
            return Direction.DOWN == facing;
        }
        if (AllBlocks.MECHANICAL_SAW.has(state)) {
            return state.m_61143_((Property)BlockStateProperties.f_61372_) == facing;
        }
        if (AllBlocks.PORTABLE_STORAGE_INTERFACE.has(state)) {
            return state.m_61143_((Property)PortableStorageInterfaceBlock.f_52588_) == facing;
        }
        if (state.m_60734_() instanceof AttachedActorBlock) {
            return state.m_61143_((Property)BlockStateProperties.f_61374_) == facing;
        }
        if (AllBlocks.ROPE_PULLEY.has(state)) {
            return facing == Direction.DOWN;
        }
        if (state.m_60734_() instanceof WoolCarpetBlock) {
            return facing == Direction.UP;
        }
        if (state.m_60734_() instanceof SailBlock) {
            return facing.m_122434_() == ((Direction)state.m_61143_((Property)SailBlock.f_52588_)).m_122434_();
        }
        if (AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            return facing.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        }
        if (AllBlocks.MECHANICAL_PISTON_HEAD.has(state)) {
            return facing.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        }
        if (AllBlocks.STICKER.has(state) && !((Boolean)state.m_61143_((Property)StickerBlock.EXTENDED)).booleanValue()) {
            return facing == state.m_61143_((Property)StickerBlock.f_52588_);
        }
        return BlockMovementChecks.isBrittle(state);
    }

    public static interface MovementNecessaryCheck {
        public CheckResult isMovementNecessary(BlockState var1, Level var2, BlockPos var3);
    }

    public static interface MovementAllowedCheck {
        public CheckResult isMovementAllowed(BlockState var1, Level var2, BlockPos var3);
    }

    public static interface BrittleCheck {
        public CheckResult isBrittle(BlockState var1);
    }

    public static interface AttachedCheck {
        public CheckResult isBlockAttachedTowards(BlockState var1, Level var2, BlockPos var3, Direction var4);
    }

    public static interface NotSupportiveCheck {
        public CheckResult isNotSupportive(BlockState var1, Direction var2);
    }

    public static enum CheckResult {
        SUCCESS,
        FAIL,
        PASS;


        public Boolean toBoolean() {
            return this == PASS ? null : Boolean.valueOf(this == SUCCESS);
        }

        public static CheckResult of(boolean b) {
            return b ? SUCCESS : FAIL;
        }

        public static CheckResult of(Boolean b) {
            return b == null ? PASS : (b != false ? SUCCESS : FAIL);
        }
    }

    public static interface AllChecks
    extends MovementNecessaryCheck,
    MovementAllowedCheck,
    BrittleCheck,
    AttachedCheck,
    NotSupportiveCheck {
    }
}

