/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crusher;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crusher.CrushingWheelBlock;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CrushingWheelTileEntity
extends KineticTileEntity {
    public static DamageSource damageSource = new DamageSource("create.crush").m_19380_().m_19386_();

    public CrushingWheelTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.fixControllers();
    }

    public void fixControllers() {
        for (Direction d : Iterate.directions) {
            ((CrushingWheelBlock)this.m_58900_().m_60734_()).updateControllers(this.m_58900_(), this.m_58904_(), this.m_58899_(), d);
        }
    }

    @Override
    public AABB makeRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(1.0);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.fixControllers();
    }

    @SubscribeEvent
    public static void crushingIsFortunate(LootingLevelEvent event) {
        if (event.getDamageSource() != damageSource) {
            return;
        }
        event.setLootingLevel(2);
    }

    @SubscribeEvent
    public static void handleCrushedMobDrops(LivingDropsEvent event) {
        if (event.getSource() != damageSource) {
            return;
        }
        Vec3 outSpeed = Vec3.f_82478_;
        for (ItemEntity outputItem : event.getDrops()) {
            outputItem.m_20256_(outSpeed);
        }
    }
}

