/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.clock;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.clock.CuckooClockBlock;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.InterpolatedChasingValue;
import com.simibubi.create.foundation.utility.animation.InterpolatedValue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CuckooClockTileEntity
extends KineticTileEntity {
    public static DamageSource CUCKOO_SURPRISE = new DamageSource("create.cuckoo_clock_explosion").m_19375_();
    public InterpolatedChasingValue hourHand = new InterpolatedChasingValue().withSpeed(0.2f);
    public InterpolatedChasingValue minuteHand = new InterpolatedChasingValue().withSpeed(0.2f);
    public InterpolatedValue animationProgress = new InterpolatedValue();
    public Animation animationType = Animation.NONE;
    private boolean sendAnimationUpdate;

    public CuckooClockTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket && compound.m_128441_("Animation")) {
            this.animationType = NBTHelper.readEnum(compound, "Animation", Animation.class);
            this.animationProgress.lastValue = 0.0f;
            this.animationProgress.value = 0.0f;
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        if (clientPacket && this.sendAnimationUpdate) {
            NBTHelper.writeEnum(compound, "Animation", this.animationType);
        }
        this.sendAnimationUpdate = false;
        super.write(compound, clientPacket);
    }

    @Override
    public void tick() {
        block23: {
            block26: {
                block24: {
                    block25: {
                        super.tick();
                        if (this.getSpeed() == 0.0f) {
                            return;
                        }
                        boolean isNatural = this.f_58857_.m_6042_().m_63956_();
                        int dayTime = (int)(this.f_58857_.m_46468_() * (long)(isNatural ? 1 : 24) % 24000L);
                        int hours = (dayTime / 1000 + 6) % 24;
                        int minutes = dayTime % 1000 * 60 / 1000;
                        if (!isNatural) {
                            if (this.f_58857_.f_46443_) {
                                this.moveHands(hours, minutes);
                                if (AnimationTickHolder.getTicks() % 6 == 0) {
                                    this.playSound(SoundEvents.f_12215_, 0.0625f, 2.0f);
                                } else if (AnimationTickHolder.getTicks() % 3 == 0) {
                                    this.playSound(SoundEvents.f_12215_, 0.0625f, 1.5f);
                                }
                            }
                            return;
                        }
                        if (!this.f_58857_.f_46443_) {
                            if (this.animationType == Animation.NONE) {
                                if (hours == 12 && minutes < 5) {
                                    this.startAnimation(Animation.PIG);
                                }
                                if (hours == 18 && minutes < 36 && minutes > 31) {
                                    this.startAnimation(Animation.CREEPER);
                                }
                            } else {
                                float value = this.animationProgress.value;
                                this.animationProgress.set(value + 1.0f);
                                if (value > 100.0f) {
                                    this.animationType = Animation.NONE;
                                }
                                if (this.animationType == Animation.SURPRISE && this.animationProgress.value == 50.0f) {
                                    Vec3 center = VecHelper.getCenterOf((Vec3i)this.f_58858_);
                                    this.f_58857_.m_46961_(this.f_58858_, false);
                                    this.f_58857_.m_7703_(null, CUCKOO_SURPRISE, null, center.f_82479_, center.f_82480_, center.f_82481_, 3.0f, false, Explosion.BlockInteraction.BREAK);
                                }
                            }
                        }
                        if (!this.f_58857_.f_46443_) break block23;
                        this.moveHands(hours, minutes);
                        if (this.animationType != Animation.NONE) break block24;
                        if (AnimationTickHolder.getTicks() % 32 != 0) break block25;
                        this.playSound(SoundEvents.f_12215_, 0.0625f, 2.0f);
                        break block26;
                    }
                    if (AnimationTickHolder.getTicks() % 16 != 0) break block26;
                    this.playSound(SoundEvents.f_12215_, 0.0625f, 1.5f);
                    break block26;
                }
                boolean isSurprise = this.animationType == Animation.SURPRISE;
                float value = this.animationProgress.value;
                this.animationProgress.set(value + 1.0f);
                if (value > 100.0f) {
                    this.animationType = null;
                }
                if (value == 1.0f) {
                    this.playSound(SoundEvents.f_12211_, 2.0f, 0.5f);
                }
                if (value == 21.0f) {
                    this.playSound(SoundEvents.f_12211_, 2.0f, 0.793701f);
                }
                if (value > 30.0f && isSurprise) {
                    Vec3 pos = VecHelper.offsetRandomly(VecHelper.getCenterOf((Vec3i)this.f_58858_), this.f_58857_.f_46441_, 0.5f);
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
                }
                if (value == 40.0f && isSurprise) {
                    this.playSound(SoundEvents.f_12512_, 1.0f, 1.0f);
                }
                int step = isSurprise ? 3 : 15;
                for (int phase = 30; phase <= 60; phase += step) {
                    if (value == (float)(phase - step / 3)) {
                        this.playSound(SoundEvents.f_11749_, 0.0625f, 2.0f);
                    }
                    if (value == (float)phase) {
                        if (this.animationType == Animation.PIG) {
                            this.playSound(SoundEvents.f_12233_, 0.25f, 1.0f);
                        } else {
                            this.playSound(SoundEvents.f_11836_, 0.25f, 3.0f);
                        }
                    }
                    if (value != (float)(phase + step / 3)) continue;
                    this.playSound(SoundEvents.f_11747_, 0.0625f, 2.0f);
                }
            }
            return;
        }
    }

    public void startAnimation(Animation animation) {
        this.animationType = animation;
        if (animation != null && CuckooClockBlock.containsSurprise(this.m_58900_())) {
            this.animationType = Animation.SURPRISE;
        }
        this.animationProgress.lastValue = 0.0f;
        this.animationProgress.value = 0.0f;
        this.sendAnimationUpdate = true;
        if (animation == Animation.CREEPER) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.CUCKOO, (LevelAccessor)this.f_58857_, this.f_58858_, 10);
        }
        this.sendData();
    }

    public void moveHands(int hours, int minutes) {
        float hourTarget = 30 * (hours % 12);
        float minuteTarget = 6 * minutes;
        this.hourHand.target(this.hourHand.value + AngleHelper.rad(AngleHelper.getShortestAngleDiff(AngleHelper.deg(this.hourHand.value), hourTarget)));
        this.minuteHand.target(this.minuteHand.value + AngleHelper.rad(AngleHelper.getShortestAngleDiff(AngleHelper.deg(this.minuteHand.value), minuteTarget)));
        this.hourHand.tick();
        this.minuteHand.tick();
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        this.f_58857_.m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, sound, SoundSource.BLOCKS, volume, pitch, false);
    }

    static enum Animation {
        PIG,
        CREEPER,
        SURPRISE,
        NONE;

    }
}

