/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.ModelBlockModel;
import org.dynmap.modsupport.impl.BlockModelImpl;
import org.dynmap.modsupport.impl.ModModelDefinitionImpl;

public class ModelBlockModelImpl
extends BlockModelImpl
implements ModelBlockModel {
    private ArrayList<ModelBlockImpl> boxes = new ArrayList();
    private String rotsourceblockname;
    private int rotsourcemetaindex;
    private int xrot;
    private int yrot;
    private int zrot;
    private static HashMap<BlockSide, String> fromBlockSide = new HashMap();

    public ModelBlockModelImpl(String blkname, ModModelDefinitionImpl mdf) {
        super(blkname, mdf);
    }

    public ModelBlockModelImpl(String blkname, ModModelDefinitionImpl mdf, ModelBlockModel mod, int xrot, int yrot, int zrot) {
        super(blkname, mdf);
        this.rotsourceblockname = mod.getBlockNames()[0];
        this.rotsourcemetaindex = Integer.numberOfTrailingZeros(mod.getMetaValueMask());
        this.xrot = xrot;
        this.yrot = yrot;
        this.zrot = zrot;
    }

    @Override
    public String getLine() {
        String ids = this.getIDsAndMeta();
        if (ids == null) {
            return null;
        }
        String line = String.format("patchblock:%s", ids);
        if (this.rotsourceblockname != null) {
            line = line + "\npatchrotate:id=" + this.rotsourceblockname + ",data=" + this.rotsourcemetaindex;
            if (this.xrot != 0) {
                line = line + ",rotx=" + this.xrot;
            }
            if (this.yrot != 0) {
                line = line + ",roty=" + this.yrot;
            }
            if (this.zrot != 0) {
                line = line + ",rotz=" + this.yrot;
            }
        } else {
            for (ModelBlockImpl mb : this.boxes) {
                line = line + String.format(",box=%f/%f/%f:%f/%f/%f", mb.from[0], mb.from[1], mb.from[2], mb.to[0], mb.to[1], mb.to[2]);
                if (mb.xrot != 0.0 || mb.yrot != 0.0 || mb.zrot != 0.0) {
                    line = line + String.format("/%f/%f/%f", mb.xrot, mb.yrot, mb.zrot);
                }
                for (BlockSide bs : fromBlockSide.keySet()) {
                    String side = fromBlockSide.get((Object)bs);
                    ModelSide mside = (ModelSide)mb.sides.get((Object)bs);
                    if (mside == null) continue;
                    String rval = side;
                    switch (mside.rot) {
                        default: {
                            break;
                        }
                        case DEG90: {
                            rval = rval + "90";
                            break;
                        }
                        case DEG180: {
                            rval = rval + "180";
                            break;
                        }
                        case DEG270: {
                            rval = rval + "270";
                        }
                    }
                    if (mside.uv != null) {
                        line = line + String.format(":%s/%d/%f/%f/%f/%f", rval, mside.textureid, mside.uv[0], mside.uv[1], mside.uv[2], mside.uv[3]);
                        continue;
                    }
                    line = line + String.format(":%s/%d", rval, mside.textureid);
                }
            }
        }
        return line;
    }

    @Override
    public ModelBlockModel.ModelBlock addModelBlock(double[] from, double[] to, double xrot, double yrot, double zrot) {
        ModelBlockImpl mbi = new ModelBlockImpl();
        if (from != null) {
            ((ModelBlockImpl)mbi).from[0] = from[0];
            ((ModelBlockImpl)mbi).from[1] = from[1];
            ((ModelBlockImpl)mbi).from[2] = from[2];
        }
        if (to != null) {
            ((ModelBlockImpl)mbi).to[0] = to[0];
            ((ModelBlockImpl)mbi).to[1] = to[1];
            ((ModelBlockImpl)mbi).to[2] = to[2];
        }
        mbi.xrot = xrot;
        mbi.yrot = yrot;
        mbi.zrot = zrot;
        this.boxes.add(mbi);
        return mbi;
    }

    static {
        fromBlockSide.put(BlockSide.TOP, "u");
        fromBlockSide.put(BlockSide.BOTTOM, "d");
        fromBlockSide.put(BlockSide.NORTH, "n");
        fromBlockSide.put(BlockSide.SOUTH, "s");
        fromBlockSide.put(BlockSide.WEST, "e");
        fromBlockSide.put(BlockSide.EAST, "w");
    }

    private static class ModelBlockImpl
    implements ModelBlockModel.ModelBlock {
        private HashMap<BlockSide, ModelSide> sides = new HashMap();
        private double[] from = new double[]{0.0, 0.0, 0.0};
        private double[] to = new double[]{16.0, 16.0, 16.0};
        private double xrot = 0.0;
        private double yrot = 0.0;
        private double zrot = 0.0;

        private ModelBlockImpl() {
        }

        @Override
        public void addBlockSide(BlockSide side, double[] uv, ModelBlockModel.SideRotation rot, int textureid) {
            ModelSide ms = new ModelSide();
            ms.textureid = textureid;
            if (uv != null) {
                ModelSide.access$102(ms, Arrays.copyOf(uv, uv.length));
            }
            if (rot != null) {
                ms.rot = rot;
            }
            if (side == BlockSide.FACE_0 || side == BlockSide.Y_MINUS) {
                side = BlockSide.BOTTOM;
            }
            if (side == BlockSide.FACE_1 || side == BlockSide.Y_PLUS) {
                side = BlockSide.TOP;
            }
            if (side == BlockSide.FACE_2 || side == BlockSide.Z_MINUS) {
                side = BlockSide.NORTH;
            }
            if (side == BlockSide.FACE_3 || side == BlockSide.Z_PLUS) {
                side = BlockSide.SOUTH;
            }
            if (side == BlockSide.FACE_4 || side == BlockSide.X_MINUS) {
                side = BlockSide.WEST;
            }
            if (side == BlockSide.FACE_5 || side == BlockSide.X_PLUS) {
                side = BlockSide.EAST;
            }
            this.sides.put(side, ms);
        }
    }

    private static class ModelSide {
        private double[] uv;
        private ModelBlockModel.SideRotation rot;
        int textureid;

        private ModelSide() {
        }

        static /* synthetic */ double[] access$102(ModelSide x0, double[] x1) {
            x0.uv = x1;
            return x1;
        }
    }
}

