/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dynmap.Client;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.MapTypeState;
import org.dynmap.UpdateQueue;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.storage.MapStorage;
import org.dynmap.storage.MapStorageTile;
import org.dynmap.utils.DynmapBufferedImage;
import org.dynmap.utils.ImageIOManager;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;
import org.dynmap.utils.RectangleVisibilityLimit;
import org.dynmap.utils.RoundVisibilityLimit;
import org.dynmap.utils.TileFlags;
import org.dynmap.utils.VisibilityLimit;

public abstract class DynmapWorld {
    public List<MapType> maps = new ArrayList<MapType>();
    public List<MapTypeState> mapstate = new ArrayList<MapTypeState>();
    public UpdateQueue updates = new UpdateQueue();
    public DynmapLocation center;
    public List<DynmapLocation> seedloc;
    private List<DynmapLocation> seedloccfg;
    public List<VisibilityLimit> visibility_limits;
    public List<VisibilityLimit> hidden_limits;
    public MapChunkCache.HiddenChunkStyle hiddenchunkstyle;
    public int servertime;
    public boolean sendposition;
    public boolean sendhealth;
    public boolean showborder;
    private int extrazoomoutlevels;
    private boolean cancelled;
    private final String wname;
    private final int hashcode;
    private final String raw_wname;
    private String title;
    public int tileupdatedelay;
    private boolean is_enabled;
    boolean is_protected;
    protected int[] brightnessTable = new int[16];
    private MapStorage storage;
    public int worldheight;
    public int minY;
    public int sealevel;
    private static final int[] stepseq = new int[]{3, 1, 2, 0};

    protected void updateWorldHeights(int worldheight, int minY, int sealevel) {
        this.worldheight = worldheight;
        this.minY = minY;
        this.sealevel = sealevel;
    }

    protected DynmapWorld(String wname, int worldheight, int sealevel) {
        this(wname, worldheight, sealevel, 0);
    }

    protected DynmapWorld(String wname, int worldheight, int sealevel, int miny) {
        this.raw_wname = wname;
        this.wname = DynmapWorld.normalizeWorldName(wname);
        this.hashcode = this.wname.hashCode();
        this.title = wname;
        this.worldheight = worldheight;
        this.minY = miny;
        this.sealevel = sealevel;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.setBrightnessTableEntry(i, (1.0f - f1) / (f1 * 3.0f + 1.0f));
        }
    }

    protected void setBrightnessTableEntry(int level, float value) {
        if (level < 0 || level > 15) {
            return;
        }
        this.brightnessTable[level] = (int)(256.0 * (double)value);
        if (this.brightnessTable[level] > 256) {
            this.brightnessTable[level] = 256;
        }
        if (this.brightnessTable[level] < 0) {
            this.brightnessTable[level] = 0;
        }
    }

    public int[] getBrightnessTable() {
        return this.brightnessTable;
    }

    public void setExtraZoomOutLevels(int lvl) {
        this.extrazoomoutlevels = lvl;
    }

    public int getExtraZoomOutLevels() {
        return this.extrazoomoutlevels;
    }

    public void enqueueZoomOutUpdate(MapStorageTile tile) {
        MapTypeState mts = this.getMapState(tile.map);
        if (mts != null) {
            mts.setZoomOutInv(tile.x, tile.y, tile.zoom);
        }
    }

    public void freshenZoomOutFiles() {
        MapTypeState.ZoomOutCoord c = new MapTypeState.ZoomOutCoord();
        for (MapTypeState mts : this.mapstate) {
            if (this.cancelled) {
                return;
            }
            MapType mt = mts.type;
            MapType.ImageVariant[] var = mt.getVariants();
            mts.startZoomOutIter();
            while (mts.nextZoomOutInv(c)) {
                if (this.cancelled) {
                    return;
                }
                for (int varIdx = 0; varIdx < var.length; ++varIdx) {
                    MapStorageTile tile = this.storage.getTile(this, mt, c.x, c.y, c.zoomlevel, var[varIdx]);
                    this.processZoomFile(mts, tile, varIdx == 0);
                }
            }
        }
    }

    public void cancelZoomOutFreshen() {
        this.cancelled = true;
    }

    public void activateZoomOutFreshen() {
        this.cancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processZoomFile(MapTypeState mts, MapStorageTile tile, boolean firstVariant) {
        long mostRecentTimestamp = 0L;
        int step = 1 << tile.zoom;
        MapStorageTile ztile = tile.getZoomOutTile();
        int width = 128;
        int height = 128;
        BufferedImage zIm = null;
        DynmapBufferedImage kzIm = null;
        boolean blank = true;
        int[] argb = new int[width * height];
        int tx = ztile.x;
        int ty = ztile.y;
        ty -= step;
        kzIm = DynmapBufferedImage.allocateBufferedImage(width, height);
        zIm = kzIm.buf_img;
        for (int i = 0; i < 4; ++i) {
            boolean doblit;
            block27: {
                doblit = true;
                int tx1 = tx + step * (1 & stepseq[i]);
                int ty1 = ty + step * (stepseq[i] >> 1);
                MapStorageTile tile1 = this.storage.getTile(this, tile.map, tx1, ty1, tile.zoom, tile.var);
                if (tile1 == null) continue;
                tile1.getReadLock();
                if (firstVariant) {
                    mts.clearZoomOutInv(tile1.x, tile1.y, tile1.zoom);
                }
                try {
                    MapStorageTile.TileRead tr = tile1.read();
                    if (tr != null) {
                        BufferedImage im = null;
                        try {
                            im = ImageIOManager.imageIODecode(tr);
                            mostRecentTimestamp = Math.max(mostRecentTimestamp, tr.lastModified);
                        }
                        catch (IOException iox) {
                            tile1.delete();
                        }
                        if (im != null && im.getWidth() >= width && im.getHeight() >= height) {
                            int iheight;
                            int iwidth = im.getWidth();
                            if (iwidth > (iheight = im.getHeight())) {
                                iwidth = iheight;
                            }
                            if (iwidth == width && iheight == height) {
                                im.getRGB(0, 0, width, height, argb, 0, width);
                                im.flush();
                                int off = 0;
                                for (int y = 0; y < height; y += 2) {
                                    off = y * width;
                                    int x = 0;
                                    while (x < width) {
                                        int p0 = argb[off];
                                        int p1 = argb[off + 1];
                                        int p2 = argb[off + width];
                                        int p3 = argb[off + width + 1];
                                        int alpha = (p0 >> 24 & 0xFF) + (p1 >> 24 & 0xFF) + (p2 >> 24 & 0xFF) + (p3 >> 24 & 0xFF);
                                        int red = (p0 >> 16 & 0xFF) + (p1 >> 16 & 0xFF) + (p2 >> 16 & 0xFF) + (p3 >> 16 & 0xFF);
                                        int green = (p0 >> 8 & 0xFF) + (p1 >> 8 & 0xFF) + (p2 >> 8 & 0xFF) + (p3 >> 8 & 0xFF);
                                        int blue = (p0 & 0xFF) + (p1 & 0xFF) + (p2 & 0xFF) + (p3 & 0xFF);
                                        argb[off >> 1] = (alpha >> 2 & 0xFF) << 24 | (red >> 2 & 0xFF) << 16 | (green >> 2 & 0xFF) << 8 | blue >> 2 & 0xFF;
                                        x += 2;
                                        off += 2;
                                    }
                                }
                            } else {
                                int[] buf = new int[iwidth * iwidth];
                                im.getRGB(0, 0, iwidth, iwidth, buf, 0, iwidth);
                                im.flush();
                                TexturePack.scaleTerrainPNGSubImage(iwidth, width / 2, buf, argb);
                                zIm.setRGB(i >> 1 != 0 ? 0 : width / 2, (i & 1) * height / 2, width / 2, height / 2, argb, 0, width / 2);
                                doblit = false;
                            }
                            blank = false;
                        } else {
                            if (tile1.map.getImageFormat().getEncoding() == MapType.ImageEncoding.JPG) {
                                Arrays.fill(argb, tile1.map.getBackgroundARGB(tile1.var));
                            } else {
                                Arrays.fill(argb, 0);
                            }
                            tile1.delete();
                        }
                        break block27;
                    }
                    if (tile1.map.getImageFormat().getEncoding() == MapType.ImageEncoding.JPG) {
                        Arrays.fill(argb, tile1.map.getBackgroundARGB(tile1.var));
                    } else {
                        Arrays.fill(argb, 0);
                    }
                }
                finally {
                    tile1.releaseReadLock();
                }
            }
            if (!doblit) continue;
            zIm.setRGB(i >> 1 != 0 ? 0 : width / 2, (i & 1) * height / 2, width / 2, height / 2, argb, 0, width);
        }
        ztile.getWriteLock();
        try {
            MapManager mm = MapManager.mapman;
            if (mm == null) {
                return;
            }
            long crc = MapStorage.calculateImageHashCode(kzIm.argb_buf, 0, kzIm.argb_buf.length);
            if (blank) {
                if (ztile.exists()) {
                    ztile.delete();
                    MapManager.mapman.pushUpdate(this, (Client.Update)new Client.Tile(ztile.getURI()));
                    this.enqueueZoomOutUpdate(ztile);
                }
            } else {
                ztile.write(crc, zIm, mostRecentTimestamp == 0L ? System.currentTimeMillis() : mostRecentTimestamp);
                MapManager.mapman.pushUpdate(this, (Client.Update)new Client.Tile(ztile.getURI()));
                this.enqueueZoomOutUpdate(ztile);
            }
        }
        finally {
            ztile.releaseWriteLock();
            DynmapBufferedImage.freeBufferedImage(kzIm);
        }
    }

    public String getName() {
        return this.wname;
    }

    public abstract boolean isNether();

    public abstract DynmapLocation getSpawnLocation();

    public int hashCode() {
        return this.hashcode;
    }

    public abstract long getTime();

    public abstract boolean hasStorm();

    public abstract boolean isThundering();

    public abstract boolean isLoaded();

    public abstract void setWorldUnloaded();

    public abstract int getLightLevel(int var1, int var2, int var3);

    public abstract int getHighestBlockYAt(int var1, int var2);

    public abstract boolean canGetSkyLightLevel();

    public abstract int getSkyLightLevel(int var1, int var2, int var3);

    public abstract String getEnvironment();

    public abstract MapChunkCache getChunkCache(List<DynmapChunk> var1);

    public String getTitle() {
        return this.title;
    }

    public DynmapLocation getCenterLocation() {
        if (this.center != null) {
            return this.center;
        }
        return this.getSpawnLocation();
    }

    public boolean loadConfiguration(DynmapCore core, ConfigurationNode worldconfig) {
        List<ConfigurationNode> list;
        this.is_enabled = worldconfig.getBoolean("enabled", false);
        if (!this.is_enabled) {
            return false;
        }
        this.title = worldconfig.getString("title", this.title);
        ConfigurationNode ctr = worldconfig.getNode("center");
        int mid_y = (this.worldheight + this.minY) / 2;
        this.center = ctr != null ? new DynmapLocation(this.wname, ctr.getDouble("x", 0.0), ctr.getDouble("y", mid_y), ctr.getDouble("z", 0.0)) : null;
        List<ConfigurationNode> loclist = worldconfig.getNodes("fullrenderlocations");
        this.seedloc = new ArrayList<DynmapLocation>();
        this.seedloccfg = new ArrayList<DynmapLocation>();
        this.servertime = (int)(this.getTime() % 24000L);
        this.sendposition = worldconfig.getBoolean("sendposition", true);
        this.sendhealth = worldconfig.getBoolean("sendhealth", true);
        this.showborder = worldconfig.getBoolean("showborder", true);
        this.is_protected = worldconfig.getBoolean("protected", false);
        this.setExtraZoomOutLevels(worldconfig.getInteger("extrazoomout", 0));
        this.setTileUpdateDelay(worldconfig.getInteger("tileupdatedelay", -1));
        this.storage = core.getDefaultMapStorage();
        if (loclist != null) {
            for (ConfigurationNode configurationNode : loclist) {
                DynmapLocation dynmapLocation = new DynmapLocation(this.wname, configurationNode.getDouble("x", 0.0), configurationNode.getDouble("y", mid_y), configurationNode.getDouble("z", 0.0));
                this.seedloc.add(dynmapLocation);
                this.seedloccfg.add(dynmapLocation);
            }
        }
        this.maps.clear();
        Log.verboseinfo("Loading maps of world '" + this.wname + "'...");
        for (MapType mapType : worldconfig.createInstances("maps", new Class[]{DynmapCore.class}, new Object[]{core})) {
            if (mapType.getName() == null) continue;
            this.maps.add(mapType);
        }
        this.mapstate.clear();
        for (MapType mapType : this.maps) {
            MapTypeState mapTypeState = new MapTypeState(this, mapType);
            mapTypeState.setInvalidatePeriod(mapType.getTileUpdateDelay(this));
            this.mapstate.add(mapTypeState);
        }
        Log.info("Loaded " + this.maps.size() + " maps of world '" + this.wname + "'.");
        List<ConfigurationNode> vislimits = worldconfig.getNodes("visibilitylimits");
        if (vislimits != null) {
            this.visibility_limits = new ArrayList<VisibilityLimit>();
            for (ConfigurationNode configurationNode : vislimits) {
                VisibilityLimit lim;
                if (configurationNode.containsKey("r")) {
                    int x_center = configurationNode.getInteger("x", 0);
                    int z_center = configurationNode.getInteger("z", 0);
                    int radius = configurationNode.getInteger("r", 0);
                    lim = new RoundVisibilityLimit(x_center, z_center, radius);
                } else {
                    int x0 = configurationNode.getInteger("x0", 0);
                    int x1 = configurationNode.getInteger("x1", 0);
                    int z0 = configurationNode.getInteger("z0", 0);
                    int z1 = configurationNode.getInteger("z1", 0);
                    lim = new RectangleVisibilityLimit(x0, z0, x1, z1);
                }
                this.visibility_limits.add(lim);
                this.seedloc.add(new DynmapLocation(this.wname, lim.xCenter(), 64.0, lim.zCenter()));
            }
        }
        if ((list = worldconfig.getNodes("hiddenlimits")) != null) {
            this.hidden_limits = new ArrayList<VisibilityLimit>();
            for (ConfigurationNode vis : list) {
                VisibilityLimit lim;
                if (vis.containsKey("r")) {
                    int x_center = vis.getInteger("x", 0);
                    int z_center = vis.getInteger("z", 0);
                    int radius = vis.getInteger("r", 0);
                    lim = new RoundVisibilityLimit(x_center, z_center, radius);
                } else {
                    int x0 = vis.getInteger("x0", 0);
                    int x1 = vis.getInteger("x1", 0);
                    int z0 = vis.getInteger("z0", 0);
                    int z1 = vis.getInteger("z1", 0);
                    lim = new RectangleVisibilityLimit(x0, z0, x1, z1);
                }
                this.hidden_limits.add(lim);
            }
        }
        String string = worldconfig.getString("hidestyle", "stone");
        this.hiddenchunkstyle = MapChunkCache.HiddenChunkStyle.fromValue(string);
        if (this.hiddenchunkstyle == null) {
            this.hiddenchunkstyle = MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN;
        }
        return true;
    }

    public ConfigurationNode saveConfiguration() {
        RoundVisibilityLimit round_lim;
        RectangleVisibilityLimit rect_lim;
        LinkedHashMap<String, Integer> lv;
        VisibilityLimit lim;
        ArrayList lims;
        int i;
        ConfigurationNode node = new ConfigurationNode();
        node.put("name", (Object)this.wname);
        node.put("title", (Object)this.getTitle());
        node.put("enabled", (Object)this.is_enabled);
        node.put("protected", (Object)this.is_protected);
        node.put("showborder", (Object)this.showborder);
        if (this.tileupdatedelay > 0) {
            node.put("tileupdatedelay", (Object)this.tileupdatedelay);
        }
        if (this.center != null) {
            ConfigurationNode c = new ConfigurationNode();
            c.put("x", (Object)this.center.x);
            c.put("y", (Object)this.center.y);
            c.put("z", (Object)this.center.z);
            node.put("center", (Object)c.entries);
        }
        if (this.seedloccfg.size() > 0) {
            ArrayList<Map<String, Object>> locs = new ArrayList<Map<String, Object>>();
            for (i = 0; i < this.seedloccfg.size(); ++i) {
                DynmapLocation dl = this.seedloccfg.get(i);
                ConfigurationNode ll = new ConfigurationNode();
                ll.put("x", (Object)dl.x);
                ll.put("y", (Object)dl.y);
                ll.put("z", (Object)dl.z);
                locs.add(ll.entries);
            }
            node.put("fullrenderlocations", (Object)locs);
        }
        node.put("sendposition", (Object)this.sendposition);
        node.put("sendhealth", (Object)this.sendhealth);
        node.put("extrazoomout", (Object)this.extrazoomoutlevels);
        if (this.visibility_limits != null) {
            lims = new ArrayList();
            for (i = 0; i < this.visibility_limits.size(); ++i) {
                lim = this.visibility_limits.get(i);
                lv = new LinkedHashMap<String, Integer>();
                if (lim instanceof RectangleVisibilityLimit) {
                    rect_lim = (RectangleVisibilityLimit)lim;
                    lv.put("x0", rect_lim.x_min);
                    lv.put("z0", rect_lim.z_min);
                    lv.put("x1", rect_lim.x_max);
                    lv.put("z1", rect_lim.z_max);
                } else {
                    round_lim = (RoundVisibilityLimit)lim;
                    lv.put("x", round_lim.x_center);
                    lv.put("z", round_lim.z_center);
                    lv.put("r", round_lim.radius);
                }
                lims.add(lv);
            }
            node.put("visibilitylimits", (Object)lims);
        }
        if (this.hidden_limits != null) {
            lims = new ArrayList();
            for (i = 0; i < this.hidden_limits.size(); ++i) {
                lim = this.hidden_limits.get(i);
                lv = new LinkedHashMap();
                if (lim instanceof RectangleVisibilityLimit) {
                    rect_lim = (RectangleVisibilityLimit)lim;
                    lv.put("x0", rect_lim.x_min);
                    lv.put("z0", rect_lim.z_min);
                    lv.put("x1", rect_lim.x_max);
                    lv.put("z1", rect_lim.z_max);
                } else {
                    round_lim = (RoundVisibilityLimit)lim;
                    lv.put("x", round_lim.x_center);
                    lv.put("z", round_lim.z_center);
                    lv.put("r", round_lim.radius);
                }
                lims.add(lv);
            }
            node.put("hiddenlimits", (Object)lims);
        }
        node.put("hidestyle", (Object)this.hiddenchunkstyle.getValue());
        ArrayList<ConfigurationNode> mapinfo = new ArrayList<ConfigurationNode>();
        for (MapType mt : this.maps) {
            ConfigurationNode mnode = mt.saveConfiguration();
            mapinfo.add(mnode);
        }
        node.put("maps", (Object)mapinfo);
        return node;
    }

    public boolean isEnabled() {
        return this.is_enabled;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static String normalizeWorldName(String n) {
        return n != null ? n.replace('/', '-').replace('[', '_').replace(']', '_') : null;
    }

    public String getRawName() {
        return this.raw_wname;
    }

    public boolean isProtected() {
        return this.is_protected;
    }

    public int getTileUpdateDelay() {
        if (this.tileupdatedelay > 0) {
            return this.tileupdatedelay;
        }
        return MapManager.mapman.getDefTileUpdateDelay();
    }

    public void setTileUpdateDelay(int time_sec) {
        this.tileupdatedelay = time_sec;
    }

    public static void doInitialScan(boolean doscan) {
    }

    public int getChunkMap(TileFlags map) {
        return -1;
    }

    public MapTypeState getMapState(MapType m) {
        for (int i = 0; i < this.maps.size(); ++i) {
            MapType mt = this.maps.get(i);
            if (mt != m) continue;
            return this.mapstate.get(i);
        }
        return null;
    }

    public void purgeTree() {
        this.storage.purgeMapTiles(this, null);
    }

    public void purgeMap(MapType mt) {
        this.storage.purgeMapTiles(this, mt);
    }

    public MapStorage getMapStorage() {
        return this.storage;
    }

    public Polygon getWorldBorder() {
        return null;
    }
}

