/*
 * Decompiled with CFR 0.152.
 */
package appeng.mixins.structure;

import appeng.api.features.AEWorldGenType;
import appeng.init.worldgen.InitBiomeModifications;
import appeng.worldgen.meteorite.MeteoriteStructure;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StructureFeatures.class})
public class StructureFeaturesMixin {
    @Inject(method={"registerStructures"}, at={@At(value="TAIL")})
    private static void registerStructures(BiConsumer<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> consumer, CallbackInfo ci) {
        for (Map.Entry entry : BuiltinRegistries.f_123865_.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            Biome.BiomeCategory category = ((Biome)entry.getValue()).m_47567_();
            if (!InitBiomeModifications.shouldGenerateIn(key.m_135782_(), true, AEWorldGenType.METEORITES, category)) continue;
            consumer.accept(MeteoriteStructure.CONFIGURED_INSTANCE, (ResourceKey<Biome>)key);
        }
    }
}

