/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.integration.modules.jei.GenericEntryStackHelper;
import appeng.menu.AEBaseMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.FakeSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

class GhostIngredientHandler
implements IGhostIngredientHandler<AEBaseScreen> {
    GhostIngredientHandler() {
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(AEBaseScreen gui, I ingredient, boolean doStart) {
        ItemStack wrapped = GhostIngredientHandler.wrapDraggedItem(ingredient);
        if (wrapped == null) {
            return Collections.emptyList();
        }
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        GhostIngredientHandler.addItemStackTargets(gui, targets, wrapped);
        return targets;
    }

    @Nullable
    private static ItemStack wrapDraggedItem(Object ingredient) {
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            return itemStack;
        }
        GenericStack genericStack = GenericEntryStackHelper.of(ingredient);
        if (genericStack != null) {
            return GenericStack.wrapInItemStack(genericStack);
        }
        return null;
    }

    private static <I> void addItemStackTargets(AEBaseScreen<?> gui, List<IGhostIngredientHandler.Target<I>> targets, ItemStack draggedStack) {
        for (Slot slot : ((AEBaseMenu)gui.m_6262_()).f_38839_) {
            FakeSlot fakeSlot;
            AppEngSlot appEngSlot;
            if (!(slot instanceof AppEngSlot) || !(appEngSlot = (AppEngSlot)slot).isSlotEnabled() || !(appEngSlot instanceof FakeSlot) || !(fakeSlot = (FakeSlot)appEngSlot).canSetFilterTo(draggedStack)) continue;
            targets.add(new ItemSlotTarget(gui, appEngSlot));
        }
    }

    public void onComplete() {
    }

    private static class ItemSlotTarget
    implements IGhostIngredientHandler.Target<Object> {
        private final AppEngSlot slot;
        private final Rect2i area;

        public ItemSlotTarget(AEBaseScreen<?> screen, AppEngSlot slot) {
            this.slot = slot;
            this.area = new Rect2i(screen.getGuiLeft() + slot.f_40220_, screen.getGuiTop() + slot.f_40221_, 16, 16);
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(Object ingredient) {
            ItemStack wrapped = GhostIngredientHandler.wrapDraggedItem(ingredient);
            if (wrapped != null) {
                NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, this.slot.f_40219_, wrapped));
            }
        }
    }
}

