/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public final class GenericEntryStackHelper {
    public static final List<IngredientType<?>> INGREDIENT_TYPES = ImmutableList.of(new IngredientType(VanillaTypes.ITEM, i -> i.getAllIngredients().stream().map(GenericStack::fromItemStack).toList()), new IngredientType(VanillaTypes.FLUID, i -> i.getAllIngredients().stream().map(GenericStack::fromFluidStack).toList()));

    private GenericEntryStackHelper() {
    }

    @Nullable
    public static GenericStack of(Object ingredient) {
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            return GenericStack.fromItemStack(itemStack);
        }
        if (ingredient instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)ingredient;
            return new GenericStack(AEFluidKey.of(fluidStack.getFluid(), fluidStack.getTag()), fluidStack.getAmount());
        }
        return null;
    }

    public static List<List<GenericStack>> ofInputs(IRecipeLayout recipeLayout) {
        return GenericEntryStackHelper.ofRecipeLayout(recipeLayout, IGuiIngredient::isInput);
    }

    public static List<GenericStack> ofOutputs(IRecipeLayout recipeLayout) {
        return GenericEntryStackHelper.ofRecipeLayout(recipeLayout, ingredient -> !ingredient.isInput()).stream().flatMap(e -> e.stream().limit(1L)).toList();
    }

    private static List<List<GenericStack>> ofRecipeLayout(IRecipeLayout recipeLayout, Predicate<IGuiIngredient<?>> predicate) {
        return INGREDIENT_TYPES.stream().flatMap(type -> type.getConverted(recipeLayout, predicate)).toList();
    }

    public record IngredientType<T>(IIngredientType<T> type, Function<IGuiIngredient<T>, List<GenericStack>> converter) {
        public Stream<List<GenericStack>> getConverted(IRecipeLayout layout, Predicate<IGuiIngredient<?>> predicate) {
            return layout.getIngredientsGroup(this.type).getGuiIngredients().entrySet().stream().filter(e -> predicate.test((IGuiIngredient)e.getValue())).sorted(Comparator.comparingInt(Map.Entry::getKey)).map(e -> this.converter.apply((IGuiIngredient)e.getValue()));
        }
    }
}

