/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.iface;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class PatternProviderReturnInventory
extends GenericStackInv {
    public static int NUMBER_OF_SLOTS = 9;
    private boolean injectingIntoNetwork = false;
    private final IItemHandler itemHandler = new ItemHandler();
    private final LazyOptional<IItemHandler> itemHandlerOpt = LazyOptional.of(() -> this.itemHandler);
    private final IFluidHandler fluidHandler = new FluidHandler();
    private final LazyOptional<IFluidHandler> fluidHandlerOpt = LazyOptional.of(() -> this.fluidHandler);

    public PatternProviderReturnInventory(Runnable listener) {
        super(listener, NUMBER_OF_SLOTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean injectIntoNetwork(MEStorage storage, IActionSource src) {
        boolean didSomething = false;
        this.injectingIntoNetwork = true;
        try {
            for (int i = 0; i < this.stacks.length; ++i) {
                GenericStack stack = this.stacks[i];
                if (stack == null) continue;
                long sizeBefore = stack.amount();
                long inserted = storage.insert(stack.what(), stack.amount(), Actionable.MODULATE, src);
                this.stacks[i] = inserted >= stack.amount() ? null : new GenericStack(stack.what(), stack.amount() - inserted);
                if (GenericStack.getStackSizeOrZero(this.stacks[i]) == sizeBefore) continue;
                didSomething = true;
            }
        }
        finally {
            this.injectingIntoNetwork = false;
        }
        return didSomething;
    }

    public void addDrops(List<ItemStack> drops) {
        for (GenericStack stack : this.stacks) {
            AEKey aEKey;
            if (stack == null || !((aEKey = stack.what()) instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)aEKey;
            drops.add(itemKey.toStack((int)Math.min(Integer.MAX_VALUE, stack.amount())));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerOpt.cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerOpt.cast();
        }
        return LazyOptional.empty();
    }

    private class ItemHandler
    implements IItemHandler {
        private ItemHandler() {
        }

        public int getSlots() {
            return PatternProviderReturnInventory.this.size();
        }

        public ItemStack getStackInSlot(int slot) {
            AEKey aEKey;
            if (PatternProviderReturnInventory.this.stacks[slot] != null && (aEKey = PatternProviderReturnInventory.this.stacks[slot].what()) instanceof AEItemKey) {
                AEItemKey what = (AEItemKey)aEKey;
                return what.toStack((int)Math.min(Integer.MAX_VALUE, PatternProviderReturnInventory.this.stacks[slot].amount()));
            }
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            long inserted;
            if (PatternProviderReturnInventory.this.injectingIntoNetwork) {
                return stack;
            }
            GenericStack genericStack = GenericStack.fromItemStack(stack);
            if (genericStack != null && (inserted = PatternProviderReturnInventory.this.insert(slot, genericStack.what(), genericStack.amount(), simulate ? Actionable.SIMULATE : Actionable.MODULATE)) > 0L) {
                return Platform.copyStackWithSize(stack, stack.m_41613_() - (int)inserted);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public int getTanks() {
            return PatternProviderReturnInventory.this.size();
        }

        public FluidStack getFluidInTank(int tank) {
            AEKey aEKey;
            if (PatternProviderReturnInventory.this.stacks[tank] != null && (aEKey = PatternProviderReturnInventory.this.stacks[tank].what()) instanceof AEFluidKey) {
                AEFluidKey what = (AEFluidKey)aEKey;
                return what.toStack((int)Math.min(Integer.MAX_VALUE, PatternProviderReturnInventory.this.stacks[tank].amount()));
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 4000;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (PatternProviderReturnInventory.this.injectingIntoNetwork) {
                return 0;
            }
            AEFluidKey what = AEFluidKey.of(resource);
            if (what == null) {
                return 0;
            }
            long filled = 0L;
            for (int i = 0; i < PatternProviderReturnInventory.this.stacks.length && (long)resource.getAmount() - filled > 0L; ++i) {
                filled += PatternProviderReturnInventory.this.insert(i, what, (long)resource.getAmount() - filled, Actionable.of(action));
            }
            return (int)filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

